/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.messagetracker;

import com.modus.mule.modules.as2.GlobalContext;
import com.modus.mule.modules.as2.common.AS2ConnectorException;
import com.modus.mule.modules.as2.messagetracker.As2Transmission;
import com.modus.mule.modules.as2.messagetracker.As2Transmissions;
import com.modus.mule.modules.as2.messagetracker.Callback;
import com.modus.mule.modules.as2.messagetracker.MessageTracker;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.IOUtils;

public class RemoteMessageTracker
implements MessageTracker {
    private CloseableHttpAsyncClient httpAsyncClient;
    private CloseableHttpClient httpClient;
    private String messageTrackerAddress;
    private ObjectMapper objectMapper;
    private static final Logger logger = Logger.getLogger(RemoteMessageTracker.class);

    public RemoteMessageTracker(String messageTrackerAddress) {
        this.messageTrackerAddress = messageTrackerAddress;
        this.objectMapper = GlobalContext.getInstance().getObjectMapper();
        this.httpAsyncClient = GlobalContext.getInstance().getHttpAsyncClient();
        this.httpClient = GlobalContext.getInstance().getHttpClient();
    }

    @Override
    public void create(final As2Transmission as2Transmission, final Callback<As2Transmission> callback) throws Exception {
        HttpPost createHttpPost = null;
        try {
            createHttpPost = this.buildCreateRequest(as2Transmission);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to record AS2 transmission " + as2Transmission.getAs2MessageId()), (Throwable)e);
        }
        this.httpAsyncClient.execute(createHttpPost, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(HttpResponse httpResponse) {
                try {
                    if (RemoteMessageTracker.this.isSuccessful(httpResponse)) {
                        logger.debug((Object)("AS2 transmission recorded for " + as2Transmission.getAs2MessageId()));
                        callback.completed();
                    } else {
                        RemoteMessageTracker.this.logRecordError(httpResponse);
                        callback.failed(new Exception());
                    }
                }
                finally {
                    RemoteMessageTracker.this.closeHttpStream(httpResponse);
                }
            }

            @Override
            public void failed(Exception e) {
                callback.failed(e);
            }

            @Override
            public void cancelled() {
                logger.error((Object)"AS2 transmission save operation cancelled");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(As2Transmission as2Transmission) throws Exception {
        block4: {
            CloseableHttpResponse httpResponse = this.httpClient.execute(this.buildCreateRequest(as2Transmission));
            try {
                if (this.isSuccessful(httpResponse)) {
                    logger.debug((Object)("AS2 transmission recorded for " + as2Transmission.getAs2MessageId()));
                    break block4;
                }
                this.logRecordError(httpResponse);
                throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)"Failed to record AS2 transmission"));
            }
            finally {
                this.closeHttpStream(httpResponse);
            }
        }
    }

    @Override
    public void update(final As2Transmission as2Transmission, final Callback<As2Transmission> callback) throws Exception {
        HttpPut httpPut = new HttpPut(this.messageTrackerAddress + "/as2Transmissions/as2Transmission/" + as2Transmission.getAs2MessageId());
        httpPut.setHeader("Content-Type", "application/json");
        httpPut.setEntity(new StringEntity(this.objectMapper.writeValueAsString((Object)as2Transmission)));
        logger.debug((Object)("Writing updated AS2 transmission " + as2Transmission.getAs2MessageId() + " to " + httpPut.getURI()));
        this.httpAsyncClient.execute(httpPut, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(HttpResponse httpResponse) {
                try {
                    if (RemoteMessageTracker.this.isSuccessful(httpResponse)) {
                        logger.debug((Object)("AS2 transmission " + as2Transmission.getAs2MessageId() + " updated"));
                        callback.completed();
                    } else {
                        try {
                            logger.error((Object)("Failed to update AS2 transmission. The HTTP status code is: " + httpResponse.getStatusLine().getStatusCode() + ". The reply's content is: \n\n" + IOUtils.toString((InputStream)httpResponse.getEntity().getContent())));
                        }
                        catch (IOException e) {
                            logger.error((Object)("Failed to update AS2 transmission. The HTTP status code is: " + httpResponse.getStatusLine().getStatusCode() + ". Could not log the reply's content due to " + e), (Throwable)e);
                        }
                    }
                }
                finally {
                    RemoteMessageTracker.this.closeHttpStream(httpResponse);
                }
            }

            @Override
            public void failed(Exception e) {
                logger.error((Object)("An error occurred while updating AS2 transmission" + e));
                callback.failed(e);
            }

            @Override
            public void cancelled() {
                logger.error((Object)"AS2 transmission save operation cancelled");
            }
        });
    }

    @Override
    public void get(As2Transmission as2Transmission, Callback<As2Transmission> callback) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public As2Transmission get(As2Transmission as2Transmission) throws Exception {
        String criteria = URLEncoder.encode("{\"field\":\"as2MessageId\",\"value\":\"" + as2Transmission.getAs2MessageId() + "\",\"operator\":\"EQUALS\"}", "UTF-8");
        HttpGet httpGet = new HttpGet(this.messageTrackerAddress + "/as2Transmissions?count=1&page=1&offset=0&criteria=" + criteria);
        httpGet.addHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = this.httpClient.execute(httpGet);
        logger.debug((Object)("Retrieving AS2 transmission " + as2Transmission.getAs2MessageId() + " from " + httpGet.getURI()));
        try {
            if (this.isSuccessful(httpResponse)) {
                As2Transmissions as2Transmissions = (As2Transmissions)this.objectMapper.readValue(httpResponse.getEntity().getContent(), As2Transmissions.class);
                if (as2Transmissions.getCount() != null && as2Transmissions.getCount() > 0) {
                    logger.debug((Object)("AS2 transmission " + as2Transmission.getAs2MessageId() + " retrieved"));
                    As2Transmission as2Transmission2 = as2Transmissions.getAs2Transmissions().get(0);
                    return as2Transmission2;
                }
                logger.warn((Object)("AS2 transmission " + as2Transmission.getAs2MessageId() + " was not retrieved"));
                As2Transmission as2Transmission3 = null;
                return as2Transmission3;
            }
            try {
                logger.error((Object)("Failed to retrieve AS2 transmission. The HTTP status code is: " + httpResponse.getStatusLine().getStatusCode() + ". The reply's content is: \n\n" + IOUtils.toString((InputStream)httpResponse.getEntity().getContent())));
            }
            catch (IOException e) {
                logger.error((Object)("Failed to retrieve AS2 transmission. The HTTP status code is: " + httpResponse.getStatusLine().getStatusCode() + ". Could not log the reply's content due to " + e), (Throwable)e);
            }
            As2Transmission as2Transmission4 = null;
            return as2Transmission4;
        }
        finally {
            this.closeHttpStream(httpResponse);
        }
    }

    private HttpPost buildCreateRequest(As2Transmission as2Transmission) throws Exception {
        HttpPost httpPost = new HttpPost(this.messageTrackerAddress + "/as2Transmissions");
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setEntity(new StringEntity(this.objectMapper.writeValueAsString((Object)as2Transmission)));
        logger.debug((Object)("Writing AS2 transmission " + as2Transmission.getAs2MessageId() + " to " + httpPost.getURI()));
        return httpPost;
    }

    private boolean isSuccessful(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode() >= 200 && httpResponse.getStatusLine().getStatusCode() < 300;
    }

    private void logRecordError(HttpResponse httpResponse) {
        try {
            logger.error((Object)("Failed to record AS2 transmission. The HTTP status code is: " + httpResponse.getStatusLine().getStatusCode() + ". The reply's content is: \n\n" + IOUtils.toString((InputStream)httpResponse.getEntity().getContent())));
        }
        catch (IOException e) {
            logger.error((Object)("Failed to record AS2 transmission. The HTTP status code is: " + httpResponse.getStatusLine().getStatusCode() + ". Could not log the reply's content due"), (Throwable)e);
        }
    }

    private void closeHttpStream(HttpResponse httpResponse) {
        try {
            httpResponse.getEntity().getContent().close();
        }
        catch (IOException e) {
            logger.error((Object)"An error occurred while closing HTTP stream", (Throwable)e);
        }
    }
}

