/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.server;

import com.modus.common.message.Message;
import com.modus.common.message.MessageMDN;
import com.modus.common.service.agreement.Agreement;
import com.modus.common.service.agreement.SecurityInfo;
import com.modus.common.service.result.AS2Result;
import com.modus.mule.modules.as2.ConnectorContext;
import com.modus.mule.modules.as2.GlobalContext;
import com.modus.mule.modules.as2.common.AS2ConnectorException;
import com.modus.mule.modules.as2.common.MessageLogger;
import com.modus.mule.modules.as2.common.MicAlgorithmOptionEnum;
import com.modus.mule.modules.as2.messagetracker.As2Transmission;
import com.modus.mule.modules.as2.messagetracker.MdnContent;
import com.modus.mule.modules.as2.messagetracker.MessageTracker;
import com.modus.mule.modules.as2.server.ServerConfig;
import com.modus.mule.modules.as2.tpm.As2Spec;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Header;
import javax.net.ssl.SSLContext;
import javax.resource.spi.work.Work;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.log4j.Logger;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.callback.SourceCallback;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.NotificationException;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.security.oauth.processor.AbstractListeningMessageProcessor;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class ServerFacade {
    private static final Logger logger = Logger.getLogger(ServerFacade.class);
    private MuleContext muleContext;
    private InboundEndpoint inboundEndpoint;
    private SourceCallback callback;
    private ServerConfig serverConfig;
    private Agreement userDefinedAgreement;
    private ConnectorContext connectorContext;
    private MessageTracker messageTracker;
    private CloseableHttpAsyncClient httpAsyncClient;
    private CloseableHttpAsyncClient httpsAsyncClient;
    private FutureCallback asyncReceiptReplyFutureCallback;

    public ServerFacade(SourceCallback callback, MuleContext muleContext, ServerConfig serverConfig, ConnectorContext connectorContext) throws AS2ConnectorException {
        this.muleContext = muleContext;
        this.callback = callback;
        this.serverConfig = serverConfig;
        this.connectorContext = connectorContext;
        this.messageTracker = connectorContext.getMessageTracker();
        this.httpAsyncClient = GlobalContext.getInstance().getHttpAsyncClient();
        this.httpsAsyncClient = this.createHttpsClient(serverConfig);
        this.asyncReceiptReplyFutureCallback = this.createAsyncReceiptReplyHandler();
    }

    public void start() throws AS2ConnectorException {
        if (this.connectorContext.getAs2Service() == null) {
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)"AS2Service is not set"));
        }
        EndpointURIEndpointBuilder endpointBuilder = (EndpointURIEndpointBuilder)this.muleContext.getRegistry().lookupObject(this.serverConfig.getHttpEndpointRef());
        if (endpointBuilder == null) {
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)("Invalid global HTTP/s endpoint reference: " + this.serverConfig.getHttpEndpointRef() + ". Make sure the connector config is pointing to the correct global HTTP/s endpoint")));
        }
        try {
            FlowConstruct flowConstruct = ((AbstractListeningMessageProcessor)this.callback).getFlowConstruct();
            this.inboundEndpoint = this.muleContext.getEndpointFactory().getInboundEndpoint((EndpointBuilder)endpointBuilder);
            this.inboundEndpoint.setFlowConstruct(flowConstruct);
            this.inboundEndpoint.setListener((MessageProcessor)new Listener(this.callback));
            this.setShutdownListener();
            this.muleContext.getRegistry().registerObject(this.inboundEndpoint.getName(), (Object)this.inboundEndpoint, ImmutableEndpoint.class);
            this.inboundEndpoint.start();
        }
        catch (Exception e) {
            throw new AS2ConnectorException(e);
        }
    }

    private void stop() throws AS2ConnectorException {
        if (this.inboundEndpoint != null) {
            try {
                this.inboundEndpoint.stop();
            }
            catch (Exception e) {
                throw new AS2ConnectorException(e);
            }
        }
    }

    private HttpPost messageMdnToHttpPost(String destination, MessageMDN mdnAs2Message) throws Exception {
        HttpPost httpPost = new HttpPost(destination);
        AbstractHttpEntity httpEntity = mdnAs2Message.getData() != null ? new ByteArrayEntity(IOUtils.toByteArray((InputStream)mdnAs2Message.getData().getInputStream())) : new StringEntity("");
        httpPost.setEntity(httpEntity);
        Enumeration headers = mdnAs2Message.getHeaders().getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            httpPost.setHeader(header.getName(), header.getValue());
        }
        return httpPost;
    }

    private CloseableHttpAsyncClient createHttpsClient(ServerConfig serverConfig) throws AS2ConnectorException {
        try {
            if (serverConfig.getKeyStorePath() != null) {
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                InputStream keyStoreInputStream = IOUtils.getResourceAsStream((String)serverConfig.getKeyStorePath(), this.getClass(), (boolean)true, (boolean)false);
                if (keyStoreInputStream == null) {
                    throw new AS2ConnectorException(new FileNotFoundException("Key store not found"));
                }
                if (!this.loadTrustStore(serverConfig, trustStore, keyStoreInputStream)) {
                    return null;
                }
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore).build();
                SSLIOSessionStrategy sslSessionStrategy = new SSLIOSessionStrategy(sslcontext, new String[]{"TLSv1"}, null, SSLIOSessionStrategy.ALLOW_ALL_HOSTNAME_VERIFIER);
                return HttpAsyncClients.custom().setSSLStrategy(sslSessionStrategy).build();
            }
            return null;
        }
        catch (Exception e) {
            throw new AS2ConnectorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTrustStore(ServerConfig serverConfig, KeyStore trustStore, InputStream keyStoreInputStream) throws NoSuchAlgorithmException, CertificateException, IOException {
        boolean loaded = true;
        try {
            trustStore.load(keyStoreInputStream, serverConfig.getKeyStorePassword().toCharArray());
        }
        catch (IOException e) {
            logger.warn((Object)"Exception occurred while trying to load the key store for receiving async receipts over HTTPs. Make sure you are using a JKS key store.", (Throwable)e);
            loaded = false;
        }
        finally {
            keyStoreInputStream.close();
        }
        return loaded;
    }

    private FutureCallback<HttpResponse> createAsyncReceiptReplyHandler() {
        return new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(HttpResponse httpResponse) {
                try {
                    MessageLogger.logIncomingMessage(httpResponse, "Received reply", logger);
                }
                catch (Exception ex) {
                    logger.error((Object)"An error occurred while logging the reply", (Throwable)ex);
                }
                finally {
                    try {
                        httpResponse.getEntity().getContent().close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"An error occurred while closing HTTP stream", (Throwable)e);
                    }
                }
            }

            @Override
            public void failed(Exception ex) {
                logger.error((Object)"An error occurred while sending the async receipt", (Throwable)ex);
            }

            @Override
            public void cancelled() {
            }
        };
    }

    private void sendReceiptOverHttps(String asyncToUrl, AS2Result as2Result) throws Exception {
        if (this.httpsAsyncClient != null) {
            if (!this.httpsAsyncClient.isRunning()) {
                this.httpsAsyncClient.start();
            }
            this.httpsAsyncClient.execute(this.messageMdnToHttpPost(asyncToUrl, as2Result.getMDN()), this.asyncReceiptReplyFutureCallback);
        } else {
            logger.error((Object)"No key store is set so the receipt will NOT be sent over HTTPs");
        }
    }

    private void setShutdownListener() throws AS2ConnectorException {
        try {
            this.muleContext.registerListener((ServerNotificationListener)new ShutdownListener());
        }
        catch (NotificationException e) {
            throw new AS2ConnectorException(e);
        }
    }

    private final class ShutdownListener
    implements MuleContextNotificationListener {
        private ShutdownListener() {
        }

        public void onNotification(ServerNotification notification) {
            try {
                if (notification.getAction() == 105 || notification.getAction() == 107) {
                    ServerFacade.this.stop();
                }
            }
            catch (AS2ConnectorException e) {
                logger.error((Object)"An error occurred while stopping the connector", (Throwable)((Object)e));
            }
        }
    }

    private class Listener
    implements MessageProcessor {
        private SourceCallback callback;

        public Listener(SourceCallback callback) throws AS2ConnectorException {
            this.callback = callback;
            ServerFacade.this.userDefinedAgreement = new Agreement();
            ServerFacade.this.userDefinedAgreement.from(ServerFacade.this.serverConfig.getAs2From()).to(ServerFacade.this.serverConfig.getAs2To()).setMDNSubject(ServerFacade.this.serverConfig.getReceiptSubject());
            if (ServerFacade.this.serverConfig.getPreferredMicAlgorithm().equals((Object)MicAlgorithmOptionEnum.sha1)) {
                ServerFacade.this.userDefinedAgreement.setMicAlgorithm("sha1");
                ServerFacade.this.userDefinedAgreement.setFallbackMicAlgorithm("md5");
            } else if (ServerFacade.this.serverConfig.getPreferredMicAlgorithm().equals((Object)MicAlgorithmOptionEnum.md5)) {
                ServerFacade.this.userDefinedAgreement.setMicAlgorithm("md5");
                ServerFacade.this.userDefinedAgreement.setFallbackMicAlgorithm("sha1");
            }
            if (ServerFacade.this.serverConfig.getRequireSenderEncrypts().booleanValue()) {
                ServerFacade.this.userDefinedAgreement.encrypted();
            }
            if (ServerFacade.this.serverConfig.getRequireSenderSigns().booleanValue()) {
                ServerFacade.this.userDefinedAgreement.signed();
            }
            if (ServerFacade.this.serverConfig.getRequireSenderCompress().booleanValue()) {
                ServerFacade.this.userDefinedAgreement.compressed();
            }
            if (StringUtils.isNotEmpty((String)ServerFacade.this.serverConfig.getSpecId())) {
                As2Spec as2Spec = ServerFacade.this.connectorContext.getTpmService().getAs2Spec(ServerFacade.this.serverConfig.getSpecId());
                if (StringUtils.equalsIgnoreCase((String)as2Spec.getMicAlgorithm(), (String)"sha1")) {
                    ServerFacade.this.userDefinedAgreement.setMicAlgorithm("sha1");
                } else if (StringUtils.equalsIgnoreCase((String)as2Spec.getMicAlgorithm(), (String)"md5")) {
                    ServerFacade.this.userDefinedAgreement.setMicAlgorithm("md5");
                }
                ServerFacade.this.userDefinedAgreement.from(as2Spec.getAs2From()).to(as2Spec.getAs2To()).setMDNSubject(as2Spec.getSubject());
            }
            ServerFacade.this.userDefinedAgreement.usingReceiverCertificate(ServerFacade.this.serverConfig.getKeyStorePath()).setReceiverPassword(ServerFacade.this.serverConfig.getKeyStorePassword()).usingSenderCertificate(ServerFacade.this.serverConfig.getKeyStorePath()).setSenderPassword(ServerFacade.this.serverConfig.getKeyStorePassword());
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            MuleMessage requestMuleMessage = event.getMessage();
            try {
                MuleMessage replyMuleMessage;
                MessageLogger.logIncomingMessage(requestMuleMessage, "Received request", logger);
                if (this.isAsyncReceipt(requestMuleMessage)) {
                    byte[] payload = requestMuleMessage.getPayloadAsBytes();
                    ServerFacade.this.muleContext.getWorkManager().scheduleWork((Work)new Worky(event, requestMuleMessage, payload));
                    replyMuleMessage = new DefaultMuleMessage((Object)"", ServerFacade.this.muleContext);
                } else {
                    AS2Result as2Result = this.processRequest(event, requestMuleMessage.getPayload(InputStream.class));
                    replyMuleMessage = this.messageMDNToMuleMessage(as2Result.getMDN());
                }
                MessageLogger.logOutgoingMessage(replyMuleMessage, "Sending AS2 reply", logger);
                return new DefaultMuleEvent(replyMuleMessage, event);
            }
            catch (Throwable e) {
                throw new MessagingException(event, e);
            }
        }

        private void recordAs2Transmission(AS2Result as2Result, MuleMessage muleMessage) throws Exception {
            String fileUrl = ServerFacade.this.connectorContext.getFileStorageService().store(muleMessage.getPayloadAsBytes());
            As2Transmission as2Transmission = this.muleMessageToAs2Transmission(muleMessage);
            as2Transmission.setFileUrl(fileUrl);
            if (as2Result.getMDN().getData() != null) {
                MdnContent mdnContent = new MdnContent();
                mdnContent.setContent(IOUtils.toByteArray((InputStream)as2Result.getMDN().getData().getInputStream()));
                mdnContent.setContentType(as2Result.getMDN().getHeader("Content-Type"));
                as2Transmission.setMdnContent(mdnContent);
            }
            ServerFacade.this.messageTracker.create(as2Transmission);
        }

        private As2Transmission muleMessageToAs2Transmission(MuleMessage muleMessage) throws Exception {
            As2Transmission as2Transmission = new As2Transmission();
            as2Transmission.setMdnStatus(1);
            if (muleMessage.getInboundProperty("Content-Type") != null) {
                as2Transmission.setContentType(muleMessage.getInboundProperty("Content-Type").toString());
            }
            if (muleMessage.getInboundProperty("AS2-From") != null) {
                as2Transmission.setAs2From(muleMessage.getInboundProperty("AS2-From").toString());
            }
            if (muleMessage.getInboundProperty("AS2-To") != null) {
                as2Transmission.setAs2To(muleMessage.getInboundProperty("AS2-To").toString());
            }
            as2Transmission.setTransmissionStatus(0);
            if (this.isAsyncReceipt(muleMessage)) {
                as2Transmission.setIsMDNAsync(true);
            }
            as2Transmission.setMessageDateTime(new Date().toString());
            if (muleMessage.getInboundProperty("Message-ID") != null) {
                as2Transmission.setAs2MessageId(muleMessage.getInboundProperty("Message-ID").toString());
            }
            return as2Transmission;
        }

        private boolean isAsyncReceipt(MuleMessage message) {
            return message.getInboundProperty("Receipt-Delivery-Option") != null;
        }

        private AS2Result processRequest(MuleEvent requestMuleEvent, Object payload) throws Exception {
            MuleMessage requestMuleMessage = requestMuleEvent.getMessage();
            CaseInsensitiveMap headers = new CaseInsensitiveMap();
            headers.putAll((Map)requestMuleMessage.getInboundProperty("http.headers", new HashMap()));
            AS2Result as2Result = this.doAs2Process((Map<String, Serializable>)headers, payload);
            Message as2Message = as2Result.getMDN().getMessage();
            if (as2Result.isSuccess()) {
                this.doMuleProcess(as2Result, as2Message, requestMuleEvent, requestMuleMessage);
            }
            return as2Result;
        }

        private void doMuleProcess(AS2Result as2Result, Message as2Message, MuleEvent requestMuleEvent, MuleMessage requestMuleMessage) throws Exception {
            DefaultMuleMessage inboundMuleMessage = new DefaultMuleMessage((Object)as2Message.getData().getInputStream(), requestMuleMessage, ServerFacade.this.muleContext);
            if (as2Message.getContentDisposition() != null) {
                inboundMuleMessage.setProperty("Content-Disposition", (Object)as2Message.getContentDisposition(), PropertyScope.INBOUND);
            }
            this.recordAs2Transmission(as2Result, (MuleMessage)inboundMuleMessage);
            this.callback.processEvent((MuleEvent)new DefaultMuleEvent((MuleMessage)inboundMuleMessage, requestMuleEvent, false));
        }

        private AS2Result doAs2Process(Map<String, Serializable> httpHeaders, Object payload) throws Exception {
            SecurityInfo info = new SecurityInfo(ServerFacade.this.serverConfig.getKeyStorePath(), ServerFacade.this.serverConfig.getKeyStorePassword(), ServerFacade.this.serverConfig.getKeyStorePath(), ServerFacade.this.serverConfig.getKeyStorePassword());
            AS2Result result = ServerFacade.this.connectorContext.getAs2Service().process(httpHeaders, payload, info, ServerFacade.this.userDefinedAgreement);
            return result;
        }

        private MuleMessage messageMDNToMuleMessage(MessageMDN mdnAs2Message) throws Exception {
            DefaultMuleMessage mdnMuleMessage = new DefaultMuleMessage((Object)mdnAs2Message.getText(), ServerFacade.this.muleContext);
            Enumeration headers = mdnAs2Message.getHeaders().getAllHeaders();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                mdnMuleMessage.setOutboundProperty(header.getName(), (Object)header.getValue());
            }
            if (mdnAs2Message.getData() != null) {
                byte[] data = IOUtils.toByteArray((InputStream)mdnAs2Message.getData().getInputStream());
                mdnMuleMessage.setOutboundProperty("Content-Length", (Object)Integer.toString(data.length));
                mdnMuleMessage.setPayload((Object)data);
            } else {
                mdnMuleMessage.setPayload((Object)"");
            }
            return mdnMuleMessage;
        }

        private final class Worky
        implements Work {
            private final MuleEvent event;
            private final MuleMessage requestMuleMessage;
            private final byte[] payload;

            private Worky(MuleEvent event, MuleMessage requestMuleMessage, byte[] payload) {
                this.event = event;
                this.requestMuleMessage = requestMuleMessage;
                this.payload = payload;
            }

            public void release() {
            }

            public void run() {
                try {
                    String asyncToUrl = (String)this.requestMuleMessage.getInboundProperty("Receipt-Delivery-Option");
                    AS2Result as2Result = Listener.this.processRequest(this.event, this.payload);
                    HttpPost httpPost = ServerFacade.this.messageMdnToHttpPost(asyncToUrl, as2Result.getMDN());
                    MessageLogger.logOutgoingMessage(httpPost, "Sending AS2 async receipt to " + asyncToUrl, logger);
                    if (asyncToUrl.startsWith("https")) {
                        ServerFacade.this.sendReceiptOverHttps(asyncToUrl, as2Result);
                    } else {
                        ServerFacade.this.httpAsyncClient.execute(ServerFacade.this.messageMdnToHttpPost(asyncToUrl, as2Result.getMDN()), ServerFacade.this.asyncReceiptReplyFutureCallback);
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)"An error occurred trying to process an AS2 request", e);
                }
            }
        }
    }
}

