/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.tpm;

import com.modus.mule.modules.as2.GlobalContext;
import com.modus.mule.modules.as2.common.AS2ConnectorException;
import com.modus.mule.modules.as2.tpm.As2Spec;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class TpmService {
    private CloseableHttpClient httpClient;
    private ObjectMapper objectMapper;
    private String tpmServiceAddress;
    private static final Logger logger = Logger.getLogger(TpmService.class);

    public TpmService(String tpmServiceAddress) {
        this.tpmServiceAddress = tpmServiceAddress;
        this.objectMapper = GlobalContext.getInstance().getObjectMapper();
        this.httpClient = GlobalContext.getInstance().getHttpClient();
    }

    public As2Spec getAs2Spec(String as2SpecId) throws AS2ConnectorException {
        As2Spec as2Spec;
        HttpResponse httpResponse = null;
        try {
            HttpGet httpGet = new HttpGet(this.tpmServiceAddress + "/as2Specs/" + as2SpecId);
            httpGet.addHeader("Content-Type", "application/json");
            httpResponse = this.httpClient.execute(httpGet);
            as2Spec = (As2Spec)this.objectMapper.readValue(httpResponse.getEntity().getContent(), As2Spec.class);
        }
        catch (IOException e) {
            throw new AS2ConnectorException(e);
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.getEntity().getContent().close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"An error occurred while closing HTTP stream", (Throwable)e);
            }
        }
        return as2Spec;
    }
}

