/*
 * Decompiled with CFR 0.152.
 */
package com.modus.openas2.lib.helper;

import com.modus.openas2.lib.helper.ICryptoHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.util.encoders.Base64;

public class BCCryptoHelper
implements ICryptoHelper {
    private static final String JKS_KEY_STORE_TYPE = "JKS";
    private static final String PKCS12_KEY_STORE_TYPE = "PKCS12";
    private static final String BC_PROVIDER = "BC";
    private Log logger = LogFactory.getLog(BCCryptoHelper.class);

    @Override
    public boolean isEncrypted(MimeBodyPart part) throws MessagingException {
        ContentType contentType = new ContentType(part.getContentType());
        String baseType = contentType.getBaseType().toLowerCase();
        if (baseType.equalsIgnoreCase("application/pkcs7-mime")) {
            String smimeType = contentType.getParameter("smime-type");
            return smimeType != null && smimeType.equalsIgnoreCase("enveloped-data");
        }
        return false;
    }

    @Override
    public boolean isSigned(MimeBodyPart part) throws MessagingException {
        ContentType contentType = new ContentType(part.getContentType());
        String baseType = contentType.getBaseType().toLowerCase();
        return baseType.equalsIgnoreCase("multipart/signed");
    }

    @Override
    public String calculateMIC(MimeBodyPart part, String digest, boolean includeHeaders) throws GeneralSecurityException, MessagingException, IOException {
        String micAlg = this.convertAlgorithm(digest, true);
        MessageDigest md = MessageDigest.getInstance(micAlg, BC_PROVIDER);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        if (includeHeaders) {
            part.writeTo((OutputStream)bOut);
        } else {
            IOUtils.copy((InputStream)part.getInputStream(), (OutputStream)bOut);
        }
        byte[] data = bOut.toByteArray();
        InputStream bIn = this.trimCRLFPrefix(data);
        DigestInputStream digIn = new DigestInputStream(bIn, md);
        byte[] buff = new byte[4096];
        while (digIn.read(buff) >= 0) {
        }
        bOut.close();
        byte[] mic = digIn.getMessageDigest().digest();
        String micString = new String(Base64.encode((byte[])mic));
        StringBuilder micResult = new StringBuilder(micString);
        micResult.append(", ").append(digest);
        return micResult.toString();
    }

    @Override
    public MimeBodyPart decrypt(MimeBodyPart part, Certificate cert, Key key) throws GeneralSecurityException, MessagingException, CMSException, IOException, SMIMEException {
        if (!this.isEncrypted(part)) {
            throw new GeneralSecurityException("Content-Type indicates data isn't encrypted");
        }
        X509Certificate x509Cert = this.castCertificate(cert);
        SMIMEEnveloped envelope = new SMIMEEnveloped(part);
        JceKeyTransRecipientId recId = new JceKeyTransRecipientId(x509Cert);
        RecipientInformation recipient = envelope.getRecipientInfos().get((RecipientId)recId);
        if (recipient == null) {
            throw new GeneralSecurityException("Certificate does not match part signature");
        }
        byte[] decryptedData = recipient.getContent((Recipient)new JceKeyTransEnvelopedRecipient((PrivateKey)key).setProvider(BC_PROVIDER));
        return SMIMEUtil.toMimeBodyPart((byte[])decryptedData);
    }

    @Override
    public MimeBodyPart encrypt(MimeBodyPart part, Certificate cert, String algorithm) throws GeneralSecurityException, SMIMEException, CMSException {
        X509Certificate x509Cert = this.castCertificate(cert);
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        gen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(x509Cert));
        MimeBodyPart encData = gen.generate(part, this.encryptorFromDigest(algorithm));
        return encData;
    }

    private OutputEncryptor encryptorFromDigest(String digest) throws CMSException {
        JceCMSContentEncryptorBuilder builder = new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC);
        switch (digest) {
            case "rc2_40": {
                builder = new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC, 40);
                break;
            }
            case "rc2_64": {
                builder = new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC, 64);
                break;
            }
            case "rc2_128": {
                builder = new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC, 128);
            }
        }
        return builder.setProvider(BC_PROVIDER).build();
    }

    @Override
    public void initialize() {
        if (Security.addProvider((Provider)new BouncyCastleProvider()) == -1) {
            this.logger.warn("Could not register BouncyCastle as a provider. BouncyCastle " + Security.getProvider(BC_PROVIDER).getVersion() + " is already installed as a provider.");
        }
    }

    @Override
    public MimeBodyPart sign(MimeBodyPart part, Certificate cert, Key key, String digest) throws GeneralSecurityException, SMIMEException, MessagingException {
        String signDigest = this.convertAlgorithm(digest, true);
        X509Certificate x509Cert = this.castCertificate(cert);
        PrivateKey privKey = this.castKey(key);
        SMIMESignedGenerator sGen = new SMIMESignedGenerator("binary");
        sGen.addSigner(privKey, x509Cert, signDigest);
        MimeMultipart signedData = sGen.generate(part, BC_PROVIDER);
        MimeBodyPart tmpBody = new MimeBodyPart();
        tmpBody.setContent((Multipart)signedData);
        tmpBody.setHeader("Content-Type", signedData.getContentType());
        tmpBody.setHeader("Content-Disposition", part.getHeader("Content-Disposition", null));
        return tmpBody;
    }

    @Override
    public MimeBodyPart verify(MimeBodyPart part, Certificate cert) throws GeneralSecurityException, IOException, MessagingException, CMSException {
        if (!this.isSigned(part)) {
            throw new GeneralSecurityException("Content-Type indicates data isn't signed");
        }
        X509Certificate x509Cert = this.castCertificate(cert);
        MimeMultipart mainParts = (MimeMultipart)part.getContent();
        SMIMESigned signedPart = new SMIMESigned(mainParts, "binary");
        for (SignerInformation signer : signedPart.getSignerInfos().getSigners()) {
            if (signer.verify(x509Cert, BC_PROVIDER)) continue;
            throw new SignatureException("Verification failed");
        }
        return signedPart.getContent();
    }

    private X509Certificate castCertificate(Certificate cert) throws GeneralSecurityException {
        if (cert == null) {
            throw new GeneralSecurityException("Certificate is null");
        }
        if (!(cert instanceof X509Certificate)) {
            throw new GeneralSecurityException("Certificate must be an instance of X509Certificate");
        }
        return (X509Certificate)cert;
    }

    private PrivateKey castKey(Key key) throws GeneralSecurityException {
        if (!(key instanceof PrivateKey)) {
            throw new GeneralSecurityException("Key must implement PrivateKey interface");
        }
        return (PrivateKey)key;
    }

    private String convertAlgorithm(String algorithm, boolean toBC) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm is null");
        }
        if (toBC) {
            if (algorithm.equalsIgnoreCase("md5")) {
                return SMIMESignedGenerator.DIGEST_MD5;
            }
            if (algorithm.equalsIgnoreCase("sha1")) {
                return SMIMESignedGenerator.DIGEST_SHA1;
            }
            if (algorithm.equalsIgnoreCase("3des")) {
                return SMIMEEnvelopedGenerator.DES_EDE3_CBC;
            }
            if (algorithm.equalsIgnoreCase("cast5")) {
                return "1.2.840.113533.7.66.10";
            }
            if (algorithm.equalsIgnoreCase("idea")) {
                return "1.3.6.1.4.1.188.7.1.1.2";
            }
            if (algorithm.equalsIgnoreCase("rc2")) {
                return SMIMEEnvelopedGenerator.RC2_CBC;
            }
            throw new NoSuchAlgorithmException("Unknown algorithm: " + algorithm);
        }
        if (algorithm.equalsIgnoreCase(SMIMESignedGenerator.DIGEST_MD5)) {
            return "md5";
        }
        if (algorithm.equalsIgnoreCase(SMIMESignedGenerator.DIGEST_SHA1)) {
            return "sha1";
        }
        if (algorithm.equalsIgnoreCase("1.2.840.113533.7.66.10")) {
            return "cast5";
        }
        if (algorithm.equalsIgnoreCase(SMIMEEnvelopedGenerator.DES_EDE3_CBC)) {
            return "3des";
        }
        if (algorithm.equalsIgnoreCase("1.3.6.1.4.1.188.7.1.1.2")) {
            return "idea";
        }
        if (algorithm.equalsIgnoreCase(SMIMEEnvelopedGenerator.RC2_CBC)) {
            return "rc2";
        }
        throw new NoSuchAlgorithmException("Unknown algorithm: " + algorithm);
    }

    private InputStream trimCRLFPrefix(byte[] data) {
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        int len = data.length;
        for (int scanPos = 0; scanPos < len - 1; scanPos += 2) {
            if (new String(data, scanPos, 2).equals("\r\n")) {
                bIn.read();
                bIn.read();
                continue;
            }
            return bIn;
        }
        return bIn;
    }

    @Override
    public KeyStore loadKeyStore(String certificatePath, String password) throws IOException, GeneralSecurityException {
        this.logger.debug("Looking for certificate at:" + certificatePath);
        KeyStore ks = null;
        if (StringUtils.isNotEmpty((String)certificatePath)) {
            InputStream ksStream = this.toInputStream(certificatePath);
            BufferedInputStream rereadableBuffer = new BufferedInputStream(ksStream);
            ((InputStream)rereadableBuffer).mark(0);
            try {
                ks = BCCryptoHelper.loadKeyStore(PKCS12_KEY_STORE_TYPE, rereadableBuffer, password);
            }
            catch (IOException e) {
                ((InputStream)rereadableBuffer).reset();
                ks = BCCryptoHelper.loadKeyStore(JKS_KEY_STORE_TYPE, rereadableBuffer, password);
            }
        }
        return ks;
    }

    public static KeyStore loadKeyStore(String type, InputStream in, String password) throws IOException, GeneralSecurityException {
        KeyStore ks;
        try {
            ks = KeyStore.getInstance(type, BC_PROVIDER);
        }
        catch (KeyStoreException e) {
            ks = KeyStore.getInstance(type);
        }
        ks.load(in, password.toCharArray());
        in.close();
        return ks;
    }

    private InputStream toInputStream(String keyStorePath) throws IOException {
        URL url = null;
        try {
            File file = new File(keyStorePath).getCanonicalFile();
            if (file.exists()) {
                url = file.getAbsoluteFile().toURI().toURL();
            } else {
                this.logger.debug("File doesn't exist: " + file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            this.logger.debug("Unable to load resource from the file system: " + e.getMessage());
        }
        if (url == null && (url = Thread.currentThread().getContextClassLoader().getResource(keyStorePath)) == null) {
            this.logger.debug("Unable to load resource " + keyStorePath + " from the classpath");
        }
        if (url != null) {
            return url.openStream();
        }
        throw new FileNotFoundException();
    }
}

