/*
 * Decompiled with CFR 0.152.
 */
package com.modus.openas2.lib.helper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlHelper {
    private final String URL_REGEX = "^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?";
    private final Pattern URL_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private final int PARSE_AUTHORITY_HOST_IP = 1;
    private final int PARSE_URL_SCHEME = 2;
    private final int PARSE_AUTHORITY_PORT = 2;
    private final String PORT_REGEX = "^:(\\d{1,5})$";
    private final Pattern PORT_PATTERN = Pattern.compile("^:(\\d{1,5})$");
    private final String AUTHORITY_CHARS_REGEX = "\\p{Alnum}\\-\\.";
    private final String AUTHORITY_REGEX = "^([\\p{Alnum}\\-\\.]*)(:\\d*)?(.*)?";
    private final Pattern AUTHORITY_PATTERN = Pattern.compile("^([\\p{Alnum}\\-\\.]*)(:\\d*)?(.*)?");
    private final int PARSE_AUTHORITY_EXTRA = 3;
    private final int PARSE_URL_AUTHORITY = 4;
    private final String DOMAIN_LABEL_REGEX = "\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*";
    private final String TOP_LABEL_REGEX = "\\p{Alpha}{2,}";
    private final String DOMAIN_NAME_REGEX = "^(?:\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*\\.)+(\\p{Alpha}{2,})$";
    private final RegexValidator hostnameRegex = new RegexValidator("\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*");
    private final RegexValidator domainRegex = new RegexValidator("^(?:\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*\\.)+(\\p{Alpha}{2,})$");
    private static UrlHelper urlHelper;
    private InetAddressValidator inetAddressValidator = new InetAddressValidator();

    private UrlHelper() {
    }

    public static UrlHelper getInstance() {
        if (urlHelper != null) {
            return urlHelper;
        }
        urlHelper = new UrlHelper();
        return urlHelper;
    }

    public boolean isValid(String url) {
        Matcher urlMatcher = this.URL_PATTERN.matcher(url);
        if (!urlMatcher.matches()) {
            return false;
        }
        String scheme = urlMatcher.group(2);
        if (scheme == null || !scheme.equals("http") && !scheme.equals("https")) {
            return false;
        }
        String authority = urlMatcher.group(4);
        return this.isValidAuthority(authority);
    }

    private boolean isValidAuthority(String authority) {
        if (authority == null) {
            return false;
        }
        Matcher authorityMatcher = this.AUTHORITY_PATTERN.matcher(authority);
        if (!authorityMatcher.matches()) {
            return false;
        }
        String hostLocation = authorityMatcher.group(1);
        if (!(this.domainRegex.isValid(hostLocation) || this.hostnameRegex.isValid(hostLocation) || this.inetAddressValidator.isValid(hostLocation))) {
            return false;
        }
        String port = authorityMatcher.group(2);
        if (port != null && !this.PORT_PATTERN.matcher(port).matches()) {
            return false;
        }
        String extra = authorityMatcher.group(3);
        return extra == null || extra.trim().length() <= 0;
    }

    private class RegexValidator {
        private final Pattern[] patterns;

        public RegexValidator(String regex) {
            this(regex, true);
        }

        public RegexValidator(String regex, boolean caseSensitive) {
            this(new String[]{regex}, caseSensitive);
        }

        public RegexValidator(String[] regexs, boolean caseSensitive) {
            if (regexs == null || regexs.length == 0) {
                throw new IllegalArgumentException("Regular expressions are missing");
            }
            this.patterns = new Pattern[regexs.length];
            int flags = caseSensitive ? 0 : 2;
            for (int i = 0; i < regexs.length; ++i) {
                if (regexs[i] == null || regexs[i].length() == 0) {
                    throw new IllegalArgumentException("Regular expression[" + i + "] is missing");
                }
                this.patterns[i] = Pattern.compile(regexs[i], flags);
            }
        }

        public boolean isValid(String value) {
            if (value == null) {
                return false;
            }
            for (int i = 0; i < this.patterns.length; ++i) {
                if (!this.patterns[i].matcher(value).matches()) continue;
                return true;
            }
            return false;
        }

        public String[] match(String value) {
            if (value == null) {
                return null;
            }
            for (int i = 0; i < this.patterns.length; ++i) {
                Matcher matcher = this.patterns[i].matcher(value);
                if (!matcher.matches()) continue;
                int count = matcher.groupCount();
                String[] groups = new String[count];
                for (int j = 0; j < count; ++j) {
                    groups[j] = matcher.group(j + 1);
                }
                return groups;
            }
            return null;
        }

        public String validate(String value) {
            if (value == null) {
                return null;
            }
            for (int i = 0; i < this.patterns.length; ++i) {
                Matcher matcher = this.patterns[i].matcher(value);
                if (!matcher.matches()) continue;
                int count = matcher.groupCount();
                if (count == 1) {
                    return matcher.group(1);
                }
                StringBuilder buffer = new StringBuilder();
                for (int j = 0; j < count; ++j) {
                    String component = matcher.group(j + 1);
                    if (component == null) continue;
                    buffer.append(component);
                }
                return buffer.toString();
            }
            return null;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RegexValidator{");
            for (int i = 0; i < this.patterns.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(this.patterns[i].pattern());
            }
            buffer.append("}");
            return buffer.toString();
        }
    }

    private class InetAddressValidator {
        private static final String IPV4_REGEX = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$";
        private final RegexValidator ipv4Validator;

        private InetAddressValidator() {
            this.ipv4Validator = new RegexValidator(IPV4_REGEX);
        }

        public boolean isValid(String inetAddress) {
            return this.isValidInet4Address(inetAddress);
        }

        public boolean isValidInet4Address(String inet4Address) {
            String[] groups = this.ipv4Validator.match(inet4Address);
            if (groups == null) {
                return false;
            }
            for (int i = 0; i <= 3; ++i) {
                String ipSegment = groups[i];
                if (ipSegment == null || ipSegment.length() <= 0) {
                    return false;
                }
                int iIpSegment = 0;
                try {
                    iIpSegment = Integer.parseInt(ipSegment);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (iIpSegment <= 255) continue;
                return false;
            }
            return true;
        }
    }
}

