/*
 * Decompiled with CFR 0.152.
 */
package com.modus.openas2.params;

import com.modus.common.message.Message;
import com.modus.openas2.params.InvalidParameterException;
import com.modus.openas2.params.ParameterParser;
import java.io.File;
import java.util.StringTokenizer;
import javax.mail.internet.ContentDisposition;

public class MessageParameters
extends ParameterParser {
    public static final String KEY_SENDER = "sender";
    public static final String KEY_RECEIVER = "receiver";
    public static final String KEY_HEADERS = "headers";
    private static final String KEY_CONTENT_FILENAME = "content-disposition";
    public static final String PID_AS2 = "as2_id";
    private Message target;

    public MessageParameters(Message target) {
        this.target = target;
    }

    @Override
    public void setParameter(String key, String value) throws InvalidParameterException {
        StringTokenizer keyParts = new StringTokenizer(key, ".", false);
        if (keyParts.countTokens() != 2) {
            throw new InvalidParameterException("Invalid key format", this, key, null);
        }
        String area = keyParts.nextToken();
        String areaID = keyParts.nextToken();
        if (!area.equals(KEY_HEADERS)) {
            throw new InvalidParameterException("Invalid area in key", this, key, null);
        }
        this.getTarget().setHeader(areaID, value);
    }

    @Override
    public String getParameter(String key) throws InvalidParameterException {
        StringTokenizer keyParts = new StringTokenizer(key, ".", false);
        if (keyParts.countTokens() != 2) {
            throw new InvalidParameterException("Invalid key format", this, key, null);
        }
        String area = keyParts.nextToken();
        String areaID = keyParts.nextToken();
        if (area.equals(KEY_SENDER)) {
            return this.getTarget().getHeader("AS2-From");
        }
        if (area.equals(KEY_RECEIVER)) {
            return this.getTarget().getHeader("AS2-To");
        }
        if (area.equals(KEY_HEADERS)) {
            return this.getTarget().getHeader(areaID);
        }
        if (area.equals(KEY_CONTENT_FILENAME) && areaID.equals("filename")) {
            String returnFilename = "noContentDispositionFilename";
            String filename = this.target.getContentDisposition();
            if (filename == null || filename.length() < 1) {
                return returnFilename;
            }
            try {
                int pos = filename.lastIndexOf(File.separator);
                if (pos >= 0) {
                    returnFilename = filename.substring(0, pos + 1);
                }
                ContentDisposition cd = new ContentDisposition(filename);
                returnFilename = cd.getParameter("filename");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return returnFilename;
        }
        throw new InvalidParameterException("Invalid area in key", this, key, null);
    }

    public void setTarget(Message message) {
        this.target = message;
    }

    public Message getTarget() {
        return this.target;
    }
}

