/*
 * Decompiled with CFR 0.152.
 */
package com.modus.openas2.params;

import com.modus.openas2.params.InvalidParameterException;
import java.util.StringTokenizer;

public abstract class ParameterParser {
    public abstract void setParameter(String var1, String var2) throws InvalidParameterException;

    public abstract String getParameter(String var1) throws InvalidParameterException;

    public void setParameters(String encodedParams) throws InvalidParameterException {
        StringTokenizer params = new StringTokenizer(encodedParams, "=,", false);
        while (params.hasMoreTokens()) {
            String key = params.nextToken().trim();
            if (!params.hasMoreTokens()) {
                throw new InvalidParameterException("Invalid value", this, key, null);
            }
            String value = params.nextToken();
            this.setParameter(key, value);
        }
    }

    public static String parse(String format, ParameterParser parser) throws InvalidParameterException {
        return parser.format(format);
    }

    private String format(String format) throws InvalidParameterException {
        StringBuilder result = new StringBuilder();
        for (int next = 0; next < format.length(); ++next) {
            int prev = next;
            if ((next = format.indexOf(36, prev)) == -1) {
                result.append(format.substring(prev, format.length()));
                break;
            }
            if (next > prev) {
                result.append(format.substring(prev, next));
            }
            if ((next = format.indexOf(36, prev = next + 1)) == -1) {
                throw new InvalidParameterException("Invalid key (missing closing $)");
            }
            if (next == prev) {
                result.append("$");
                continue;
            }
            result.append(this.getParameter(format.substring(prev, next)));
        }
        return result.toString();
    }
}

