/*
 * Decompiled with CFR 0.152.
 */
package com.modus.openas2.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class DateUtil {
    public static final String RFC2616_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final Map formatters = new HashMap();

    private static synchronized String formatDate(String format, Date value) {
        SimpleDateFormat df = DateUtil.getDateFormat(format);
        return df.format(value);
    }

    public static synchronized String formatDate(String format) {
        return DateUtil.formatDate(format, new Date());
    }

    private static SimpleDateFormat getDateFormat(String format) {
        SimpleDateFormat df = (SimpleDateFormat)formatters.get(format);
        if (df == null) {
            df = new SimpleDateFormat(format);
            if (format.equals(RFC2616_DATE_FORMAT)) {
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
            }
            formatters.put(format, df);
        }
        return df;
    }
}

