/*
 * Decompiled with CFR 0.152.
 */
package com.modus.service;

import com.modus.common.exception.AS2AgreementIncompatibilityException;
import com.modus.common.exception.AS2CertNotFoundSigningServiceException;
import com.modus.common.exception.AS2CompressionServiceException;
import com.modus.common.exception.AS2DecryptionServiceException;
import com.modus.common.exception.AS2IntegrityServiceException;
import com.modus.common.exception.AS2ServiceException;
import com.modus.common.exception.AS2SignatureFailedSigningServiceException;
import com.modus.common.exception.AS2SigningServiceException;
import com.modus.common.message.AS2MessageFactory;
import com.modus.common.message.Message;
import com.modus.common.message.MessageMDN;
import com.modus.common.service.AS2Service;
import com.modus.common.service.agreement.Agreement;
import com.modus.common.service.agreement.SecurityInfo;
import com.modus.common.service.result.AS2Result;
import com.modus.common.service.util.AS2ServiceUtil;
import com.modus.openas2.DispositionException;
import com.modus.openas2.lib.helper.ICryptoHelper;
import com.modus.openas2.message.DataHistoryItem;
import com.modus.openas2.util.AS2UtilOld;
import com.modus.openas2.util.DispositionType;
import com.modus.service.message.AS2MessageFactoryImpl;
import java.io.InputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.cms.jcajce.ZlibExpanderProvider;
import org.bouncycastle.mail.smime.SMIMECompressed;
import org.bouncycastle.mail.smime.SMIMECompressedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.operator.InputExpanderProvider;

public class AS2ServiceImpl
implements AS2Service {
    private static final Log logger = LogFactory.getLog(AS2ServiceImpl.class);
    private ICryptoHelper cryptoHelper;

    @Override
    public AS2Result process(Map<String, Serializable> headers, Object payload, SecurityInfo info, Agreement agreement) throws AS2ServiceException {
        Message msg = this.getMessageFactory().create(headers, payload, true);
        MessageMDN mdn = new MessageMDN(msg);
        AS2Result result = AS2Result.success(mdn);
        String mdnMIC = null;
        logger.info("Processing " + msg.getLoggingText());
        try {
            this.validateAgreementRequiredValues(agreement, msg);
            if (info != null) {
                this.validateAgreementEncryption(agreement, msg);
                this.decrypt(msg, info);
                if (this.isSigned(msg)) {
                    this.validateAgreementSignature(agreement, msg);
                    this.verify(msg, info);
                    mdnMIC = this.calculateMIC(msg);
                    this.validateAgreementCompression(agreement, msg);
                    this.decompress(msg);
                } else {
                    this.validateAgreementCompression(agreement, msg);
                    this.decompress(msg);
                    this.validateAgreementSignature(agreement, msg);
                    if (this.isSigned(msg)) {
                        this.verify(msg, info);
                        mdnMIC = this.calculateMIC(msg);
                    } else {
                        mdnMIC = this.calculateMIC(msg);
                    }
                }
            }
            if (msg.isRequestingMDN()) {
                result = AS2Result.success(this.notifySuccess(msg, info, mdnMIC));
            }
        }
        catch (AS2AgreementIncompatibilityException e) {
            DispositionException de = new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "unexpected-processing-error"), e.getMessage(), e);
            result = AS2Result.error(this.notifyFailure(msg, de, info), e);
        }
        catch (AS2SigningServiceException e) {
            result = AS2Result.error(this.notifyFailure(msg, (DispositionException)e.getCause(), info), e);
        }
        catch (AS2DecryptionServiceException e) {
            result = AS2Result.error(this.notifyFailure(msg, (DispositionException)e.getCause(), info), e);
        }
        catch (Exception e) {
            DispositionException de = new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "unexpected-processing-error"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured while parsing the MIME content.", e);
            result = AS2Result.error(this.notifyFailure(msg, de, info), new AS2ServiceException(e));
        }
        this.cleanUpHeaders(msg);
        return result;
    }

    private void validateAgreementEncryption(Agreement agreement, Message msg) throws AS2AgreementIncompatibilityException, AS2ServiceException, Exception {
        if (agreement != null) {
            boolean isMsgEncrypted = this.loadCryptoHelper().isEncrypted(msg.getData());
            if (agreement.isEncrypted() != null && agreement.isEncrypted() != isMsgEncrypted) {
                throw new AS2AgreementIncompatibilityException(new AS2ServiceException("The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but encryption of message is not set as stated by the Agreement."));
            }
        }
    }

    private void validateAgreementCompression(Agreement agreement, Message msg) throws AS2AgreementIncompatibilityException, AS2ServiceException {
        if (agreement != null) {
            boolean isMsgCompressed = false;
            if (msg.getHeader("Content-Type") != null && msg.getHeader("Content-Type").contains("smime-type=compressed-data")) {
                isMsgCompressed = true;
            }
            if (agreement.isCompressed() != null && agreement.isCompressed() != isMsgCompressed) {
                throw new AS2AgreementIncompatibilityException(new AS2ServiceException("The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but compression of message is not set as stated by the Agreement."));
            }
        }
    }

    private void validateAgreementSignature(Agreement agreement, Message msg) throws AS2AgreementIncompatibilityException, AS2ServiceException, Exception {
        if (agreement != null && agreement.isSigned() != null && agreement.isSigned().booleanValue() != this.isSigned(msg)) {
            throw new AS2AgreementIncompatibilityException(new AS2ServiceException("The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but signature of message is not set as stated by the Agreement."));
        }
    }

    private void validateAgreementRequiredValues(Agreement agreement, Message msg) throws AS2AgreementIncompatibilityException {
        if (agreement != null) {
            if (agreement.getSenderID() != null && !agreement.getSenderID().equalsIgnoreCase(msg.getHeader("AS2-From"))) {
                throw new AS2AgreementIncompatibilityException(new AS2ServiceException("The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but sender of message is not set as stated by the Agreement."));
            }
            if (agreement.getReceiverID() != null && !agreement.getReceiverID().equalsIgnoreCase(msg.getHeader("AS2-To"))) {
                throw new AS2AgreementIncompatibilityException(new AS2ServiceException("The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but receiver of message is not set as stated by the Agreement."));
            }
            if (agreement.getAsyncMDNToUrl() != null && !agreement.getAsyncMDNToUrl().equalsIgnoreCase(msg.getAsyncMDNurl())) {
                throw new AS2AgreementIncompatibilityException(new AS2ServiceException("The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but MDN asynchronous URL of message is not set as stated by the Agreement."));
            }
        }
    }

    Message prepare(Map<String, Serializable> headers, InputStream payload, SecurityInfo info, boolean compress, boolean sign, boolean encrypt) throws AS2ServiceException {
        Message msg = this.getMessageFactory().create(headers, payload, false);
        if (compress && sign) {
            this.compress(msg);
        }
        Message raw = msg.clone();
        if (compress && !sign) {
            this.compress(msg);
        }
        if (sign) {
            this.sign(msg, info);
        }
        if (encrypt) {
            this.encrypt(msg, info);
        }
        this.setOriginalMIC(msg, raw);
        this.cleanUpHeaders(msg);
        return msg;
    }

    @Override
    public Message prepare(Agreement agreement, InputStream payload, SecurityInfo info, boolean compress, Boolean sign, Boolean encrypt) throws AS2ServiceException {
        Message msg = this.prepare(AS2ServiceUtil.buildHeadersFromAgreement(agreement), payload, info, compress, (boolean)sign, (boolean)encrypt);
        this.checkOrSetDefaultContentDispositionFilename(msg);
        agreement.makeMDNOptions(msg);
        this.cleanUpHeaders(msg);
        return msg;
    }

    private void checkOrSetDefaultContentDispositionFilename(Message msg) {
        String contentDisp = msg.getHeader("Content-Disposition");
        if ("Attachment; filename=\"null\"".contains(contentDisp)) {
            contentDisp = msg.getMessageID().substring(1, msg.getMessageID().length() - 1) + ".dat";
            msg.setContentDisposition(contentDisp);
        }
    }

    @Override
    public void verify(String original, Map<String, Serializable> mdnHeaders, byte[] mdnPayload, SecurityInfo info) throws AS2ServiceException {
        MessageMDN notification = null;
        try {
            notification = this.getMessageFactory().toMessageMDN(mdnHeaders, mdnPayload);
        }
        catch (Exception e) {
            throw new AS2ServiceException(e);
        }
        this.verifySignature(notification, info);
        this.verifyMIC(original, notification);
    }

    @Override
    public MessageMDN createMDN(Map<String, Serializable> headers, byte[] payload) throws AS2ServiceException {
        try {
            return this.getMessageFactory().toMessageMDN(headers, payload);
        }
        catch (Exception e) {
            throw new AS2ServiceException(e);
        }
    }

    private void sign(Message msg, SecurityInfo info) throws AS2ServiceException {
        logger.info("Signing: " + msg.getLoggingText());
        try {
            KeyStore ks = this.loadCryptoHelper().loadKeyStore(info.getSenderKeyStorePath(), info.getSenderKeyStorePassword());
            X509Certificate senderCert = this.loadCertificate(msg, ks, "AS2-From");
            String alias = ks.getCertificateAlias(senderCert);
            PrivateKey senderKey = (PrivateKey)ks.getKey(alias, info.getSenderKeyStorePassword().toCharArray());
            String micHashAlgorithmHeader = msg.getHeader("custom-mic-algorithm");
            String digest = StringUtils.isNotEmpty((String)micHashAlgorithmHeader) ? micHashAlgorithmHeader : "sha1";
            msg.setData(this.loadCryptoHelper().sign(msg.getData(), senderCert, senderKey, digest));
            DataHistoryItem historyItem = new DataHistoryItem(msg.getData().getContentType());
            msg.getHistory().getItems().add(historyItem);
            logger.info("Signed: " + msg.getLoggingText());
        }
        catch (Exception e) {
            throw new AS2ServiceException(e);
        }
    }

    private void compress(Message msg) throws AS2ServiceException {
        try {
            logger.info("Compressing: " + msg.getLoggingText());
            logger.debug("Decompressed payload size in bytes: " + msg.getData().getSize());
            SMIMECompressedGenerator compressor = new SMIMECompressedGenerator();
            compressor.setContentTransferEncoding("binary");
            msg.setData(compressor.generate(msg.getData(), "1.2.840.113549.1.9.16.3.8"));
            msg.setContentType(msg.getData().getContentType());
            logger.debug("Compressed payload size in bytes: " + msg.getData().getSize());
        }
        catch (Exception e) {
            throw new AS2CompressionServiceException(e);
        }
    }

    private void decompress(Message msg) throws AS2CompressionServiceException {
        try {
            String msgContentType = msg.getHeader("Content-Type");
            if (msgContentType.contains("smime-type=compressed-data")) {
                logger.info("Decompressing " + msg.getLoggingText());
                logger.debug("Compressed payload size in bytes: " + msg.getData().getSize());
                SMIMECompressed compressed = new SMIMECompressed(msg.getData());
                msg.setData(SMIMEUtil.toMimeBodyPart((byte[])compressed.getContent((InputExpanderProvider)new ZlibExpanderProvider())));
                msg.setContentType(msg.getData().getContentType());
                logger.debug("Decompressed payload size in bytes: " + msg.getData().getSize());
            }
        }
        catch (Exception ex) {
            logger.error("exception" + ex.getMessage());
            DispositionException e = new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "decompression-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decompressing the content.", ex);
            throw new AS2CompressionServiceException(e);
        }
    }

    private boolean decrypt(Message msg, SecurityInfo info) throws AS2DecryptionServiceException {
        boolean isDecrypted = false;
        try {
            ICryptoHelper ch = this.loadCryptoHelper();
            KeyStore receiverKs = this.loadCryptoHelper().loadKeyStore(info.getReceiverKeyStorePath(), info.getReceiverKeyStorePassword());
            if (ch.isEncrypted(msg.getData())) {
                logger.info("Decrypting:" + msg.getLoggingText());
                X509Certificate receiverCert = this.loadCertificate(msg, receiverKs, "AS2-To");
                PrivateKey receiverKey = this.loadPrivateKey(msg, receiverKs, "AS2-To", info.getReceiverKeyStorePassword());
                msg.setData(this.loadCryptoHelper().decrypt(msg.getData(), receiverCert, receiverKey));
                isDecrypted = true;
            } else {
                isDecrypted = false;
            }
        }
        catch (Exception e) {
            logger.error("AS2Service ERROR. See below:", e);
            DispositionException dispositionException = new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "decryption-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decrypting the content.", e);
            throw new AS2DecryptionServiceException(dispositionException);
        }
        logger.debug("Decrypted: " + isDecrypted);
        return isDecrypted;
    }

    private void verify(Message msg, SecurityInfo info) throws AS2SigningServiceException {
        try {
            ICryptoHelper ch = this.loadCryptoHelper();
            KeyStore reveiverKs = ch.loadKeyStore(info.getReceiverKeyStorePath(), info.getReceiverKeyStorePassword());
            logger.info("Verifying signature.");
            X509Certificate senderCert = this.loadCertificate(msg, reveiverKs, "AS2-From");
            msg.setData(this.loadCryptoHelper().verify(msg.getData(), senderCert));
            logger.info("Verifying signature: Done");
        }
        catch (Exception e) {
            logger.error("Verification failed. ", e);
            DispositionException dispositionException = new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "integrity-check-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. Authentication of the originator of the message failed.", e);
            throw new AS2SigningServiceException(dispositionException);
        }
    }

    private boolean isSigned(Message msg) throws Exception {
        ICryptoHelper ch = this.loadCryptoHelper();
        boolean signed = ch.isSigned(msg.getData());
        return signed;
    }

    private void verifyMIC(String original, MessageMDN mdn) throws AS2IntegrityServiceException {
        ContentType mdnContentType;
        try {
            mdnContentType = new ContentType(mdn.getHeader("Content-Type"));
            logger.info("Verifying MIC for content type:" + mdnContentType);
        }
        catch (ParseException e) {
            throw new AS2IntegrityServiceException((Exception)((Object)e));
        }
        if (mdnContentType.getBaseType().equals("multipart/signed")) {
            String returnedMIC = mdn.getHeader("Received-Content-MIC");
            String returnedHash = "";
            String returnedAlgorithm = "";
            if (returnedMIC != null && returnedMIC.lastIndexOf(",") != -1) {
                returnedHash = returnedMIC.substring(0, returnedMIC.lastIndexOf(","));
                returnedAlgorithm = returnedMIC.substring(returnedMIC.lastIndexOf(",") + 1, returnedMIC.length()).trim();
            }
            String originalHash = original.substring(0, original.lastIndexOf(","));
            String originalAlgorithm = original.substring(original.lastIndexOf(",") + 1, original.length()).trim();
            logger.debug("Comparing original MIC:" + original);
            if (!originalHash.equals(returnedHash) && originalAlgorithm.equals(returnedAlgorithm)) {
                logger.error("MIC mismatch {original = " + original + ", MDNs = " + returnedMIC + "}");
                throw new AS2IntegrityServiceException();
            }
        }
    }

    private void verifySignature(MessageMDN mdn, SecurityInfo info) throws AS2SigningServiceException {
        try {
            ICryptoHelper ch = this.loadCryptoHelper();
            KeyStore senderKS = this.loadCryptoHelper().loadKeyStore(info.getSenderKeyStorePath(), info.getSenderKeyStorePassword());
            if (ch.isSigned(mdn.getData())) {
                String optionalVerificationAlias = info.getOptionalVerificationAlias();
                String as2IdAlias = mdn.getHeader("AS2-From");
                String alias = StringUtils.isNotEmpty((String)optionalVerificationAlias) ? optionalVerificationAlias : as2IdAlias;
                logger.debug("Verifying signature for" + mdn.getMessageID() + " using alias " + alias);
                X509Certificate senderCert = this.loadCertificate(mdn, senderKS, alias);
                mdn.setData(this.loadCryptoHelper().verify(mdn.getData(), senderCert));
            }
        }
        catch (SignatureException e) {
            DispositionException dispositionException = new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "authentication-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. Authentication of the originator of the message failed.", e);
            throw new AS2SignatureFailedSigningServiceException(dispositionException);
        }
        catch (GeneralSecurityException e) {
            DispositionException dispositionException = new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "authentication-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. Authentication of the originator of the message failed.", e);
            throw new AS2CertNotFoundSigningServiceException(dispositionException);
        }
        catch (Exception e) {
            DispositionException dispositionException = new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "authentication-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. Authentication of the originator of the message failed.", e);
            throw new AS2SigningServiceException(dispositionException);
        }
    }

    private PrivateKey loadPrivateKey(Message msg, KeyStore ks, String role, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        PrivateKey receiverKey = (PrivateKey)ks.getKey(msg.getHeader(role), password.toCharArray());
        logger.info("Found Private Key for " + msg.getHeader(role));
        return receiverKey;
    }

    private X509Certificate loadCertificate(Message msg, KeyStore ks, String role) throws KeyStoreException {
        X509Certificate cert = (X509Certificate)ks.getCertificate(msg.getHeader(role));
        return cert;
    }

    private X509Certificate loadCertificate(MessageMDN msg, KeyStore ks, String alias) throws KeyStoreException {
        X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
        return cert;
    }

    private ICryptoHelper loadCryptoHelper() throws AS2ServiceException {
        if (this.cryptoHelper == null) {
            try {
                this.cryptoHelper = AS2UtilOld.getCryptoHelper();
            }
            catch (Exception e) {
                throw new AS2ServiceException(e);
            }
        }
        return this.cryptoHelper;
    }

    private void encrypt(Message msg, SecurityInfo info) throws AS2ServiceException {
        logger.info("Encrypting: " + msg.getLoggingText());
        try {
            KeyStore ks = this.loadCryptoHelper().loadKeyStore(info.getSenderKeyStorePath(), info.getSenderKeyStorePassword());
            X509Certificate receiverCert = this.loadCertificate(msg, ks, "AS2-To");
            msg.setData(this.loadCryptoHelper().encrypt(msg.getData(), receiverCert, info.getEncryptionAlgorithm()));
            DataHistoryItem historyItem = new DataHistoryItem(msg.getData().getContentType());
            msg.getHistory().getItems().add(historyItem);
            logger.info("Encrypted: " + msg.getLoggingText());
        }
        catch (Exception e) {
            throw new AS2ServiceException(e);
        }
    }

    private MessageMDN createMDN(Message msg, DispositionType disposition, String text, SecurityInfo info, String mdnMIC) {
        MessageMDN mdn = null;
        try {
            mdn = this.getMessageFactory().createMDN(msg, disposition, text, mdnMIC);
            this.setupMDNPayload(mdn, info);
            mdn.setHeader("Content-Type", MimeUtility.unfold((String)mdn.getData().getContentType()));
        }
        catch (Exception e) {
            logger.error("Error creating MDN. Silently failing. ", e);
        }
        msg.setMDN(mdn);
        return mdn;
    }

    private void setupMDNPayload(MessageMDN mdn, SecurityInfo info) throws Exception {
        String micAlg;
        Agreement agreement = new Agreement().setMDNOptions(mdn.getMessage().getHeader("Disposition-Notification-Options"));
        String micHashAlgorithmHeader = mdn.getMessage().getHeader("custom-mic-algorithm");
        String string = micAlg = micHashAlgorithmHeader != null ? micHashAlgorithmHeader : "sha1";
        if (!agreement.isRequestUnsignedReceipt()) {
            this.signMDNPayload(mdn, micAlg, info);
        } else {
            mdn.setData(this.getMessageFactory().createMDNPayload(mdn));
        }
    }

    private void signMDNPayload(MessageMDN mdn, String micAlg, SecurityInfo info) throws AS2ServiceException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, Exception, MessagingException {
        KeyStore receiverKs = this.loadCryptoHelper().loadKeyStore(info.getReceiverKeyStorePath(), info.getReceiverKeyStorePassword());
        X509Certificate senderCert = this.loadCertificate(mdn.getMessage(), receiverKs, "AS2-To");
        String alias = receiverKs.getCertificateAlias(senderCert);
        PrivateKey senderKey = (PrivateKey)receiverKs.getKey(alias, info.getReceiverKeyStorePassword().toCharArray());
        mdn.setData(this.loadCryptoHelper().sign(this.getMessageFactory().createMDNPayload(mdn), senderCert, senderKey, micAlg));
    }

    private String calculateMIC(Message msg) throws AS2IntegrityServiceException {
        String mic;
        String micHashAlgorithmHeader = msg.getHeader("custom-mic-algorithm");
        String digest = micHashAlgorithmHeader != null ? micHashAlgorithmHeader : "sha1";
        try {
            int historySize = msg.getHistory().getItems().size();
            mic = this.loadCryptoHelper().calculateMIC(msg.getData(), digest, historySize > 2);
        }
        catch (Exception e) {
            throw new AS2IntegrityServiceException(e);
        }
        return mic;
    }

    private AS2MessageFactory getMessageFactory() {
        return AS2MessageFactoryImpl.getInstance();
    }

    private MessageMDN notifyFailure(Message msg, DispositionException e, SecurityInfo info) {
        DispositionType failure = e.getDisposition();
        String dispositionText = e.getText();
        return this.createMDN(msg, failure, dispositionText, info, null);
    }

    private MessageMDN notifySuccess(Message msg, SecurityInfo info, String mdnMIC) throws Exception {
        DispositionType processed = new DispositionType("automatic-action", "MDN-sent-automatically", "processed");
        String dispositionText = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $headers.source_ip$ was authenticated as the originator of the message. There is no guarantee however that the EDI Interchange was syntactically correct, or was received by the EDI application/translator.";
        return this.createMDN(msg, processed, dispositionText, info, mdnMIC);
    }

    private void setOriginalMIC(Message msg, Message copy) {
        try {
            msg.setOriginalMIC(this.calculateMIC(copy));
        }
        catch (AS2IntegrityServiceException e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void cleanUpHeaders(Message msg) {
        msg.getHeaders().removeHeader("disposition-notification-subject");
        msg.getHeaders().removeHeader("custom-payload-filename");
        msg.getHeaders().removeHeader("custom-content-type");
        msg.getHeaders().removeHeader("custom-content-transfer-encoding");
        msg.getHeaders().removeHeader("custom-mic-algorithm");
        msg.getHeaders().removeHeader("custom-mic-fallback-algorithm");
        try {
            msg.getData().removeHeader("disposition-notification-subject");
            msg.getData().removeHeader("custom-payload-filename");
            msg.getData().removeHeader("custom-content-type");
            msg.getData().removeHeader("custom-content-transfer-encoding");
            msg.getData().removeHeader("custom-mic-algorithm");
            msg.getData().removeHeader("custom-mic-fallback-algorithm");
        }
        catch (MessagingException e) {
            logger.error("Error occurred cleaning up headers", e);
        }
    }
}

