/*
 * Decompiled with CFR 0.152.
 */
package com.modus.service.message;

import com.modus.common.exception.AS2ServiceException;
import com.modus.common.message.AS2MessageFactory;
import com.modus.common.message.Message;
import com.modus.common.message.MessageMDN;
import com.modus.openas2.OpenAS2Exception;
import com.modus.openas2.lib.helper.UrlHelper;
import com.modus.openas2.params.InvalidParameterException;
import com.modus.openas2.params.MessageParameters;
import com.modus.openas2.params.ParameterParser;
import com.modus.openas2.util.ByteArrayDataSource;
import com.modus.openas2.util.DateUtil;
import com.modus.openas2.util.DispositionType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AS2MessageFactoryImpl
implements AS2MessageFactory {
    private static final String DEFAULT_SUBJECT = "Message Disposition Notification";
    private static final String EDIFACT = "application/EDIFACT";
    private static final Log logger = LogFactory.getLog(AS2MessageFactoryImpl.class);
    private static AS2MessageFactoryImpl instance;

    protected AS2MessageFactoryImpl() {
    }

    public static AS2MessageFactory getInstance() {
        if (null == instance) {
            instance = new AS2MessageFactoryImpl();
        }
        return instance;
    }

    private void setData(Message msg, Object payload, boolean wrapPayload) throws AS2ServiceException {
        try {
            if (payload instanceof byte[]) {
                msg.setData(new MimeBodyPart(this.getDataHeaders(msg), (byte[])payload));
            } else if (payload instanceof InputStream) {
                msg.setData(new MimeBodyPart(this.getDataHeaders(msg), IOUtils.toByteArray((InputStream)((InputStream)payload))));
            } else {
                throw new AS2ServiceException("Payload must be of type byte[] or java.io.InputStream.");
            }
            String clientSetContentType = msg.getHeader("custom-content-type");
            String clientSetContentTransferEncoding = msg.getHeader("custom-content-transfer-encoding");
            msg.getData().setHeader("Content-Type", clientSetContentType != null ? clientSetContentType : EDIFACT);
            if (clientSetContentTransferEncoding != null) {
                msg.getData().setHeader("Content-Transfer-Encoding", clientSetContentTransferEncoding);
            }
            if (wrapPayload) {
                this.wrapPayload(msg);
            }
        }
        catch (OpenAS2Exception e) {
            logger.error("Object creation  error", e);
        }
        catch (MessagingException e) {
            logger.error("Object creation Messaging error", e);
        }
        catch (IOException e) {
            logger.error("Object creation IO error", e);
        }
    }

    private void wrapPayload(Message msg) throws IOException, MessagingException, OpenAS2Exception {
        if (msg.getData() != null) {
            byte[] data = IOUtils.toByteArray((InputStream)msg.getData().getInputStream());
            ContentType receivedContentType = new ContentType(msg.getHeader("Content-Type"));
            MimeBodyPart receivedPart = new MimeBodyPart();
            receivedPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, receivedContentType.toString(), null)));
            receivedPart.setHeader("Content-Type", receivedContentType.toString());
            receivedPart.setHeader("Content-Disposition", msg.getContentDisposition());
            msg.setData(receivedPart);
        }
    }

    @Override
    public Message create(Map<String, Serializable> headers, Object payload, boolean wrapPayload) throws AS2ServiceException {
        Message msg = new Message();
        this.addHeaders(msg, headers);
        this.setData(msg, payload, wrapPayload);
        return msg;
    }

    private void addHeaders(Message msg, Map<String, Serializable> headers) {
        for (String key : headers.keySet()) {
            Serializable serializable = headers.get(key);
            String value = serializable != null ? serializable.toString() : null;
            msg.addHeader(key, value);
        }
        this.headerSetOrDefault(msg, "Message-ID", msg.generateMessageID());
        this.validateOrRemoveAsyncMDNHeader(msg);
    }

    private void validateOrRemoveAsyncMDNHeader(Message msg) {
        String asyncURL = msg.getHeader("Receipt-Delivery-Option");
        if (StringUtils.isNotEmpty((String)asyncURL) && !UrlHelper.getInstance().isValid(asyncURL)) {
            logger.warn("Invalid address in Receipt-Delivery-Option. The async receipt will NOT be delivered to " + asyncURL);
            msg.getHeaders().removeHeader("Receipt-Delivery-Option");
        }
    }

    private void headerSetOrDefault(Message msg, String headerKey, String defaultValue) {
        String original = msg.getHeader(headerKey);
        String headerValue = StringUtils.isEmpty((String)original) ? defaultValue : original;
        msg.setHeader(headerKey, headerValue);
    }

    private InternetHeaders getDataHeaders(Message msg) {
        InternetHeaders internetHeaders = new InternetHeaders();
        String customContentType = msg.getHeader("custom-content-type");
        String contentType = customContentType != null ? customContentType : msg.getContentType();
        internetHeaders.addHeader("Content-Type", contentType);
        String originalContentDisposition = msg.getHeader("Content-Disposition");
        if (StringUtils.isNotEmpty((String)originalContentDisposition)) {
            internetHeaders.setHeader("Content-Disposition", originalContentDisposition);
        } else {
            String customFileName = msg.getHeader("custom-payload-filename");
            String defaultFileName = msg.getMessageID().substring(1, msg.getMessageID().length() - 1) + ".dat";
            String filename = StringUtils.isNotEmpty((String)customFileName) ? customFileName : defaultFileName;
            internetHeaders.setHeader("Content-Disposition", "Attachment; filename=\"" + filename + "\"");
            msg.setHeader("Content-Disposition", "Attachment; filename=\"" + filename + "\"");
        }
        if (logger.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder("Data Headers:{");
            Enumeration headerEn = internetHeaders.getAllHeaders();
            while (headerEn.hasMoreElements()) {
                buf.append("\n\t");
                Header header = (Header)headerEn.nextElement();
                buf.append(header.getName()).append("=").append(header.getValue());
                if (!headerEn.hasMoreElements()) continue;
                buf.append(", ");
            }
            buf.append("} \n");
            logger.debug(buf.toString());
        }
        return internetHeaders;
    }

    @Override
    public MessageMDN toMessageMDN(Map<String, Serializable> headers, byte[] payload) throws Exception {
        MessageMDN mdn = new MessageMDN();
        for (Map.Entry<String, Serializable> header : headers.entrySet()) {
            Serializable serializable = header.getValue();
            String value = serializable != null ? serializable.toString() : null;
            mdn.addHeader(header.getKey(), value);
        }
        mdn.setData(new MimeBodyPart(mdn.getHeaders(), payload));
        MimeMultipart reportParts = new MimeMultipart(mdn.getData().getDataHandler().getDataSource());
        if (reportParts != null) {
            ContentType reportType = new ContentType(reportParts.getBodyPart(0).getContentType());
            MimeMultipart report = new MimeMultipart(reportParts.getBodyPart(0).getDataHandler().getDataSource());
            if (reportType.getBaseType().equalsIgnoreCase("multipart/report")) {
                int reportCount = report.getCount();
                for (int j = 0; j < reportCount; ++j) {
                    MimeBodyPart reportPart = (MimeBodyPart)report.getBodyPart(j);
                    if (reportPart.isMimeType("text/plain")) {
                        mdn.setText(reportPart.getContent().toString());
                        continue;
                    }
                    if (!reportPart.isMimeType("message/disposition-notification")) continue;
                    InternetHeaders disposition = new InternetHeaders(reportPart.getInputStream());
                    mdn.setHeader("Reporting-UA", disposition.getHeader("Reporting-UA", ", "));
                    mdn.setHeader("Original-Recipient", disposition.getHeader("Original-Recipient", ", "));
                    mdn.setHeader("Final-Recipient", disposition.getHeader("Final-Recipient", ", "));
                    mdn.setHeader("Original-Message-ID", disposition.getHeader("Original-Message-ID", ", "));
                    mdn.setHeader("Disposition", disposition.getHeader("Disposition", ", "));
                    mdn.setHeader("Received-Content-MIC", disposition.getHeader("Received-Content-MIC", ", "));
                }
            }
        }
        return mdn;
    }

    @Override
    public MessageMDN createMDN(Message msg, DispositionType disposition, String text, String mdnMIC) throws AS2ServiceException {
        MessageMDN mdn;
        try {
            mdn = new MessageMDN(msg);
            mdn.setHeader("AS2-Version", "1.1");
            mdn.setHeader("Date", DateUtil.formatDate("EEE, dd MMM yyyy HH:mm:ss 'GMT'"));
            mdn.setHeader("Mime-Version", "1.0");
            mdn.setHeader("AS2-To", msg.getHeader("AS2-From"));
            mdn.setHeader("AS2-From", msg.getHeader("AS2-To"));
            this.headerSetIfNotNull(mdn, "From", msg.getHeader("custom-from-address"));
            mdn.setText(ParameterParser.parse(text, new MessageParameters(msg)));
            mdn.setHeader("Original-Recipient", "rfc822; " + msg.getHeader("AS2-To"));
            mdn.setHeader("Final-Recipient", "rfc822; " + msg.getHeader("AS2-To"));
            mdn.setHeader("Original-Message-ID", msg.getHeader("Message-ID"));
            mdn.setHeader("Disposition", disposition.toString());
            this.headerSetIfNotNull(mdn, "Received-Content-MIC", mdnMIC);
            this.setupMDNSubject(msg, mdn);
            mdn.updateMessageID();
        }
        catch (InvalidParameterException e) {
            throw new AS2ServiceException(e);
        }
        return mdn;
    }

    private void headerSetIfNotNull(MessageMDN mdn, String header, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            mdn.setHeader(header, value);
        }
    }

    private void setupMDNSubject(Message msg, MessageMDN mdn) throws InvalidParameterException {
        String mdnSubjectSet = msg.getHeader("disposition-notification-subject");
        String defaulSubject = DEFAULT_SUBJECT;
        MessageParameters msgParams = new MessageParameters(msg);
        String subject = mdnSubjectSet != null ? ParameterParser.parse(mdnSubjectSet, msgParams) : defaulSubject;
        mdn.setHeader("Subject", subject);
    }

    @Override
    public MimeBodyPart createMDNPayload(MessageMDN mdn) throws MessagingException {
        MimeMultipart reportParts = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        String text = mdn.getText() + "\r\n";
        textPart.setContent((Object)text, "text/plain");
        textPart.setHeader("Content-Type", "text/plain");
        reportParts.addBodyPart((BodyPart)textPart);
        MimeBodyPart reportPart = new MimeBodyPart();
        InternetHeaders reportValues = new InternetHeaders();
        reportValues.setHeader("Original-Recipient", mdn.getHeader("Original-Recipient"));
        reportValues.setHeader("Final-Recipient", mdn.getHeader("Final-Recipient"));
        reportValues.setHeader("Original-Message-ID", mdn.getHeader("Original-Message-ID"));
        reportValues.setHeader("Disposition", mdn.getHeader("Disposition"));
        reportValues.setHeader("Received-Content-MIC", mdn.getHeader("Received-Content-MIC"));
        Enumeration reportEn = reportValues.getAllHeaderLines();
        StringBuilder reportData = new StringBuilder();
        while (reportEn.hasMoreElements()) {
            reportData.append((String)reportEn.nextElement()).append("\r\n");
        }
        reportData.append("\r\n");
        String reportText = reportData.toString();
        reportPart.setContent((Object)reportText, "message/disposition-notification");
        reportPart.setHeader("Content-Type", "message/disposition-notification");
        reportParts.addBodyPart((BodyPart)reportPart);
        MimeBodyPart report = new MimeBodyPart();
        reportParts.setSubType("report; report-type=disposition-notification");
        report.setContent((Multipart)reportParts);
        report.setHeader("Content-Type", MimeUtility.unfold((String)reportParts.getContentType()));
        return report;
    }
}

