/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.RestrictTo;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.cards.MoECardHelper;
import com.moengage.cards.internal.CardController;
import com.moengage.cards.internal.Injection;
import com.moengage.cards.internal.model.CardModel;
import com.moengage.cards.internal.repository.CardParser;
import com.moengage.cards.internal.repository.tasks.UpdateStateTask;
import com.moengage.cards.listener.CardListener;
import com.moengage.cards.model.CampaignState;
import com.moengage.cards.model.Card;
import com.moengage.cards.ui.adapter.CardAdapter;
import com.moengage.cards.ui.adapter.sdkdefault.DefaultCardAdapter;
import com.moengage.core.Properties;
import com.moengage.core.internal.MoEConstants;
import com.moengage.core.internal.executor.ITask;
import com.moengage.core.internal.executor.TaskManager;
import com.moengage.core.internal.executor.TaskResult;
import com.moengage.core.internal.executor.Work;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.utils.MoEUtils;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 92\u00020\u0001:\u00019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0007J\u0016\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bJ\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010!\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0005J\b\u0010#\u001a\u00020\tH\u0007J\u000e\u0010$\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010%\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0016\u0010)\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010*\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010+\u001a\u00020\u00112\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0007J\u000e\u0010/\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tJ\u000e\u00100\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u00101\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00102\u001a\u000203J\u0018\u00104\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u00105\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u00106\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u00107\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u00108\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/moengage/cards/MoECardHelper;", "", "()V", "appSessionCards", "", "", "cardAdapter", "Lcom/moengage/cards/ui/adapter/CardAdapter;", "cardListener", "Lcom/moengage/cards/listener/CardListener;", "deletedCards", "getDeletedCards$cards_release", "()Ljava/util/Set;", "inboxSessionCards", "getInboxSessionCards$cards_release", "tag", "addMetaToEventProperties", "", "card", "Lcom/moengage/cards/model/Card;", "properties", "Lcom/moengage/core/Properties;", "clearAppSessionCards", "deleteCard", "context", "Landroid/content/Context;", "getAppSessionCards", "", "getCardAdapter", "activity", "Landroid/app/Activity;", "getCardCategories", "Ljava/util/LinkedList;", "getCardForCategory", "category", "getCardListener", "getNewCardCount", "getUnClickedCardCount", "hasShownCardInSession", "", "cardId", "onCardShown", "onInboxGoingToBackground", "onNewCardsAvailable", "newCards", "", "Lcom/moengage/cards/internal/model/CardModel;", "registerListener", "setCardAdapter", "trackCardClicked", "widgetId", "", "trackCardDeleted", "trackCardDelivered", "trackCardImpression", "trackInboxOpen", "updateFirstSeen", "Companion", "cards_release"})
public final class MoECardHelper {
    private final String tag;
    private CardListener cardListener = new CardListener();
    private CardAdapter cardAdapter;
    private final Set<String> appSessionCards;
    @NotNull
    private final Set<String> inboxSessionCards;
    @NotNull
    private final Set<String> deletedCards;
    private static MoECardHelper instance;
    @NotNull
    public static final String CATEGORY = "moe_card_category";
    @NotNull
    public static final String WIDGET_ID = "moe_widget_id";
    @NotNull
    public static final String CATEGORY_ALL = "All";
    @NotNull
    public static final Companion Companion;

    public final void registerListener(@NotNull CardListener cardListener) {
        Intrinsics.checkNotNullParameter((Object)cardListener, (String)"cardListener");
        this.cardListener = cardListener;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final CardListener getCardListener() {
        return this.cardListener;
    }

    public final void getUnClickedCardCount(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger.v((String)(this.tag + " getUnReadCardCount() : Will get un-clicked card count and provide callback."));
        TaskManager.Companion.getInstance().execute(new Work(this, context){
            final /* synthetic */ MoECardHelper this$0;
            final /* synthetic */ Context $context;

            public final void doWork() {
                long count = CardController.Companion.getInstance().getUnClickedCount(this.$context);
                CardController.Companion.getInstance().getMainThread().post(new Runnable(this, count){
                    final /* synthetic */ getUnClickedCardCount.1 this$0;
                    final /* synthetic */ long $count;

                    public final void run() {
                        MoECardHelper.access$getCardListener$p(this.this$0.this$0).onUnClickedCountAvailable(this.$count);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$count = l;
                    }
                });
            }
            {
                this.this$0 = moECardHelper;
                this.$context = context;
            }
        });
    }

    public final void getNewCardCount(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Logger.v((String)(this.tag + " getNewCardCount() : Will get new card count and provide callback."));
            TaskManager.Companion.getInstance().execute(new Work(this, context){
                final /* synthetic */ MoECardHelper this$0;
                final /* synthetic */ Context $context;

                public final void doWork() {
                    long count = CardController.Companion.getInstance().getNewCardCount(this.$context);
                    CardController.Companion.getInstance().getMainThread().post(new Runnable(this, count){
                        final /* synthetic */ getNewCardCount.1 this$0;
                        final /* synthetic */ long $count;

                        public final void run() {
                            MoECardHelper.access$getCardListener$p(this.this$0.this$0).onNewCardCountAvailable(this.$count);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$count = l;
                        }
                    });
                }
                {
                    this.this$0 = moECardHelper;
                    this.$context = context;
                }
            });
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getNewCardCount() : "), (Throwable)e);
        }
    }

    public final void deleteCard(@NotNull Context context, @NotNull Card card) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        try {
            TaskManager.Companion.getInstance().execute(new Work(this, context, card){
                final /* synthetic */ MoECardHelper this$0;
                final /* synthetic */ Context $context;
                final /* synthetic */ Card $card;

                public final void doWork() {
                    Injection.INSTANCE.getRepository(this.$context).deleteCard(this.$card.getCardId());
                    this.this$0.getDeletedCards$cards_release().add(this.$card.getCardId());
                }
                {
                    this.this$0 = moECardHelper;
                    this.$context = context;
                    this.$card = card;
                }
            });
            this.trackCardDeleted(context, card);
            CardController.Companion.getInstance().getMainThread().post(new Runnable(this, card){
                final /* synthetic */ MoECardHelper this$0;
                final /* synthetic */ Card $card;

                public final void run() {
                    MoECardHelper.access$getCardListener$p(this.this$0).onCardDelete(this.$card);
                }
                {
                    this.this$0 = moECardHelper;
                    this.$card = card;
                }
            });
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " deleteCard() : "), (Throwable)e);
        }
    }

    public final void getCardForCategory(@NotNull Context context, @NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        if (MoEUtils.isEmptyString((String)category)) {
            return;
        }
        TaskManager.Companion.getInstance().execute(new Work(this, context, category){
            final /* synthetic */ MoECardHelper this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $category;

            public final void doWork() {
                List<Card> cards = new CardParser().cardTemplateFromMeta(Injection.INSTANCE.getRepository(this.$context).cardsByCategory(this.$category));
                CardController.Companion.getInstance().getMainThread().post(new Runnable(this, cards){
                    final /* synthetic */ getCardForCategory.1 this$0;
                    final /* synthetic */ List $cards;

                    public final void run() {
                        MoECardHelper.access$getCardListener$p(this.this$0.this$0).onCardAvailable(this.$cards, this.this$0.$category);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$cards = list;
                    }
                });
            }
            {
                this.this$0 = moECardHelper;
                this.$context = context;
                this.$category = string;
            }
        });
    }

    private final void trackCardImpression(Context context, Card card) {
        Properties properties = new Properties();
        this.addMetaToEventProperties(card, properties);
        properties.setNonInteractive();
        MoEHelper.getInstance((Context)context).trackEvent(MoEConstants.MOE_CARD_IMPRESSION, properties);
    }

    private final void trackCardDeleted(Context context, Card card) {
        Properties properties = new Properties();
        this.addMetaToEventProperties(card, properties);
        MoEHelper.getInstance((Context)context).trackEvent(MoEConstants.MOE_CARD_DISMISSED, properties);
    }

    public final void trackCardClicked(@NotNull Context context, @NotNull Card card, int widgetId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        try {
            Properties properties = new Properties();
            this.addMetaToEventProperties(card, properties);
            if (widgetId != -1) {
                properties.addAttribute(WIDGET_ID, (Object)widgetId);
            }
            MoEHelper.getInstance((Context)context).trackEvent(MoEConstants.MOE_CARD_CLICKED, properties);
            card.getMetaData().getCampaignState().setClicked(true);
            card.getMetaData().setPinned(false);
            TaskManager.Companion.getInstance().submit((ITask)new UpdateStateTask(context, card));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " trackCardClicked() : "), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addMetaToEventProperties(Card card, Properties properties) {
        properties.addAttribute(CATEGORY, (Object)card.getCategory());
        Object object = card.getMetaData().getMetaData();
        boolean bl = false;
        Iterator<Map.Entry<String, Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Object value = entry2.getValue();
            properties.addAttribute((String)key, value);
        }
    }

    public final void trackInboxOpen(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MoEHelper.getInstance((Context)context).trackEvent(MoEConstants.MOE_INBOX_OPEN, new Properties());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void trackCardDelivered(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ITask task2 = new ITask(context){
                final /* synthetic */ Context $context;

                @NotNull
                public String getTaskTag() {
                    return "CARD_DELIVERY_TASK";
                }

                public boolean isSynchronous() {
                    return true;
                }

                @NotNull
                public TaskResult execute() {
                    CardController.Companion.getInstance().trackCardDelivered(this.$context);
                    return new TaskResult(true, null);
                }
                {
                    this.$context = $captured_local_variable$0;
                }
            };
            TaskManager.Companion.getInstance().submit(task2);
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " trackCardDelivered() : "), (Throwable)e);
        }
    }

    public final void setCardAdapter(@NotNull CardAdapter cardAdapter) {
        Intrinsics.checkNotNullParameter((Object)cardAdapter, (String)"cardAdapter");
        this.cardAdapter = cardAdapter;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final CardAdapter getCardAdapter(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.cardAdapter != null) {
            CardAdapter cardAdapter = this.cardAdapter;
            if (cardAdapter == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.moengage.cards.ui.adapter.CardAdapter");
            }
            return cardAdapter;
        }
        return new DefaultCardAdapter(activity);
    }

    @NotNull
    public final Set<String> getInboxSessionCards$cards_release() {
        return this.inboxSessionCards;
    }

    @NotNull
    public final Set<String> getDeletedCards$cards_release() {
        return this.deletedCards;
    }

    public final void onCardShown(@NotNull Context context, @NotNull Card card) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        try {
            Logger.v((String)(this.tag + " onCardShown() : Will update card shown if required. " + card.getCardId()));
            if (this.hasShownCardInSession(card.getCardId())) {
                return;
            }
            Logger.v((String)(this.tag + " onCardShown() : Will update card shown. " + card.getCardId()));
            CampaignState campaignState = card.getMetaData().getCampaignState();
            long l = campaignState.getLocalShowCount();
            campaignState.setLocalShowCount(l + 1L);
            CampaignState campaignState2 = card.getMetaData().getCampaignState();
            l = campaignState2.getTotalShowCount();
            campaignState2.setTotalShowCount(l + 1L);
            if (card.getMetaData().getCampaignState().getFirstSeen() == -1L) {
                this.updateFirstSeen(card, context);
            }
            this.inboxSessionCards.add(card.getCardId());
            this.appSessionCards.add(card.getCardId());
            TaskManager.Companion.getInstance().submit((ITask)new UpdateStateTask(context, card));
            this.trackCardImpression(context, card);
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " onCardShown() : "), (Throwable)e);
        }
    }

    private final void updateFirstSeen(Card card, Context context) {
        card.getMetaData().getCampaignState().setFirstSeen(MoEUtils.currentSeconds());
        if (card.getMetaData().getDisplayControl().getExpireAfterSeen() != -1L) {
            card.getMetaData().setDeletionTime(card.getMetaData().getCampaignState().getFirstSeen() + card.getMetaData().getDisplayControl().getExpireAfterSeen());
        }
    }

    private final boolean hasShownCardInSession(String cardId) {
        return this.inboxSessionCards.contains(cardId);
    }

    public final void onInboxGoingToBackground(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger.v((String)(this.tag + " onInboxGoingToBackground() : Clearing cards for session."));
        this.inboxSessionCards.clear();
    }

    @NotNull
    public final Set<String> getAppSessionCards() {
        return this.appSessionCards;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void clearAppSessionCards() {
        this.appSessionCards.clear();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onNewCardsAvailable(@NotNull List<CardModel> newCards) {
        Intrinsics.checkNotNullParameter(newCards, (String)"newCards");
        try {
            for (CardModel card : newCards) {
                this.appSessionCards.add(card.getCardId());
            }
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " onNewCardsAvailable() : "), (Throwable)e);
        }
    }

    @NotNull
    public final LinkedList<String> getCardCategories(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LinkedList<String> categoryNames = Injection.INSTANCE.getRepository(context).getCategories();
        boolean shouldShowAllTab = Injection.INSTANCE.getRepository(context).isShowAllTabEnabled();
        if (!shouldShowAllTab) {
            return categoryNames;
        }
        categoryNames.addFirst(CATEGORY_ALL);
        return categoryNames;
    }

    private MoECardHelper() {
        this.tag = "Cards_2.1.00_MoECardHelper";
        boolean bl = false;
        this.appSessionCards = new LinkedHashSet();
        bl = false;
        this.inboxSessionCards = new LinkedHashSet();
        bl = false;
        this.deletedCards = new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ CardListener access$getCardListener$p(MoECardHelper $this) {
        return $this.cardListener;
    }

    public static final /* synthetic */ void access$setCardListener$p(MoECardHelper $this, CardListener cardListener) {
        $this.cardListener = cardListener;
    }

    public /* synthetic */ MoECardHelper(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final MoECardHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/moengage/cards/MoECardHelper$Companion;", "", "()V", "CATEGORY", "", "CATEGORY_ALL", "WIDGET_ID", "instance", "Lcom/moengage/cards/MoECardHelper;", "getInstance", "cards_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final MoECardHelper getInstance() {
            if (instance == null) {
                Class<MoECardHelper> clazz = MoECardHelper.class;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (clazz) {
                    boolean bl3 = false;
                    if (instance == null) {
                        instance = new MoECardHelper(null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            MoECardHelper moECardHelper = instance;
            if (moECardHelper == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.moengage.cards.MoECardHelper");
            }
            return moECardHelper;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

