/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.moe.pushlibrary.activities.MoEActivity;
import com.moengage.cards.MoECardHelper;
import com.moengage.cards.internal.ActionManager$WhenMappings;
import com.moengage.cards.model.Card;
import com.moengage.cards.model.action.Action;
import com.moengage.cards.model.action.NavigationAction;
import com.moengage.core.internal.logger.Logger;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J.\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/moengage/cards/internal/ActionManager;", "", "()V", "tag", "", "buildUriFromString", "Landroid/net/Uri;", "action", "Lcom/moengage/cards/model/action/NavigationAction;", "executeAction", "", "activity", "Landroid/app/Activity;", "Lcom/moengage/cards/model/action/Action;", "card", "Lcom/moengage/cards/model/Card;", "navigationAction", "onActionPerformed", "actionList", "", "widgetId", "", "cards_release"})
public final class ActionManager {
    private final String tag;

    public final void onActionPerformed(@NotNull Activity activity, @NotNull List<? extends Action> actionList, @NotNull Card card, int widgetId) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(actionList, (String)"actionList");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        try {
            MoECardHelper.Companion.getInstance().trackCardClicked((Context)activity, card, widgetId);
            for (Action action : actionList) {
                this.executeAction(activity, action, card);
            }
        }
        catch (Exception exception) {
            Logger.e((String)(this.tag + " onActionPerformed() : "), (Throwable)exception);
        }
    }

    public static /* synthetic */ void onActionPerformed$default(ActionManager actionManager, Activity activity, List list, Card card, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = -1;
        }
        actionManager.onActionPerformed(activity, list, card, n);
    }

    private final void executeAction(Activity activity, Action action, Card card) {
        switch (ActionManager$WhenMappings.$EnumSwitchMapping$0[action.getActionType().ordinal()]) {
            case 1: {
                this.navigationAction(activity, action, card);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void navigationAction(Activity activity, Action action, Card card) {
        if (!(action instanceof NavigationAction)) {
            Logger.v((String)(this.tag + " navigationAction() : Action is not of type navigation. Aborting."));
            return;
        }
        NavigationAction navigateAction = (NavigationAction)action;
        Logger.v((String)(this.tag + " navigationAction() : Navigation " + navigateAction));
        CharSequence charSequence = navigateAction.getValue();
        boolean bl = false;
        if (charSequence.length() == 0) {
            Logger.v((String)(this.tag + " navigationAction() : Navigation url cannot be empty. Aborting"));
            return;
        }
        if (MoECardHelper.Companion.getInstance().getCardListener().onCardClick(card, navigateAction)) {
            Logger.v((String)(this.tag + " navigationAction() : Navigation action handled by the client app, " + "Will not execute the action."));
            return;
        }
        Intent redirectIntent = null;
        switch (ActionManager$WhenMappings.$EnumSwitchMapping$1[((NavigationAction)action).getNavigationType().ordinal()]) {
            case 1: {
                redirectIntent = new Intent((Context)activity, Class.forName(navigateAction.getValue()));
                Bundle extras = new Bundle();
                Object object = navigateAction.getKvPair();
                boolean bl2 = false;
                if (!(!object.isEmpty())) break;
                Object object2 = navigateAction.getKvPair();
                boolean bl3 = false;
                Iterator<Map.Entry<String, Object>> iterator = object2.entrySet().iterator();
                while (iterator.hasNext()) {
                    void key;
                    Object object3 = object = iterator.next();
                    boolean bl4 = false;
                    object2 = (String)object3.getKey();
                    object3 = object;
                    bl4 = false;
                    Object value = object3.getValue();
                    extras.putString((String)key, value.toString());
                }
                if (extras.isEmpty()) break;
                redirectIntent.putExtras(extras);
                break;
            }
            case 2: {
                redirectIntent = new Intent("android.intent.action.VIEW", this.buildUriFromString(navigateAction));
                break;
            }
            case 3: {
                redirectIntent = new Intent((Context)activity, MoEActivity.class);
                Intrinsics.checkNotNullExpressionValue((Object)redirectIntent.putExtra("gcm_webUrl", this.buildUriFromString(navigateAction).toString()), (String)"redirectIntent.putExtra(\u2026tring()\n                )");
                break;
            }
        }
        activity.startActivity(redirectIntent);
    }

    /*
     * WARNING - void declaration
     */
    private final Uri buildUriFromString(NavigationAction action) {
        Uri uri = Uri.parse((String)action.getValue());
        Map<String, Object> map = action.getKvPair();
        boolean bl = false;
        boolean bl2 = false;
        if (map == null || map.isEmpty()) {
            Uri uri2 = uri;
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"uri");
            return uri2;
        }
        Uri.Builder builder = uri.buildUpon();
        Iterator<Map.Entry<String, Object>> iterator = action.getKvPair().entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator.next();
            boolean bl3 = false;
            String string2 = entry2.getKey();
            entry2 = entry;
            bl3 = false;
            Object value = entry2.getValue();
            builder.appendQueryParameter((String)key, value.toString());
        }
        Uri uri3 = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"builder.build()");
        return uri3;
    }

    public ActionManager() {
        this.tag = "Cards_2.1.00_ActionManager";
    }
}

