/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.WorkerThread;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.cards.internal.CardController;
import com.moengage.cards.internal.Injection;
import com.moengage.cards.internal.listener.SyncCompleteListener;
import com.moengage.cards.internal.model.CardMeta;
import com.moengage.cards.internal.model.CardModel;
import com.moengage.cards.internal.model.SyncType;
import com.moengage.cards.internal.repository.CardParser;
import com.moengage.cards.internal.repository.CardRepository;
import com.moengage.cards.internal.repository.Evaluator;
import com.moengage.cards.internal.repository.tasks.CardLogoutTask;
import com.moengage.cards.internal.repository.tasks.SyncCardsTask;
import com.moengage.cards.internal.repository.tasks.SyncDeletedCardsTask;
import com.moengage.cards.internal.repository.tasks.SyncStatsTask;
import com.moengage.core.MoECallbacks;
import com.moengage.core.Properties;
import com.moengage.core.internal.MoEConstants;
import com.moengage.core.internal.executor.ITask;
import com.moengage.core.internal.executor.TaskManager;
import com.moengage.core.internal.executor.Work;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.utils.MoEUtils;
import com.moengage.core.listeners.AppBackgroundListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\f\b\u0000\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0016J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0002J\u001d\u0010 \u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/moengage/cards/internal/CardController;", "Lcom/moengage/core/listeners/AppBackgroundListener;", "Lcom/moengage/cards/internal/listener/SyncCompleteListener;", "()V", "mainThread", "Landroid/os/Handler;", "getMainThread", "()Landroid/os/Handler;", "syncCompleteListeners", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "tag", "", "getNewCardCount", "", "context", "Landroid/content/Context;", "getUnClickedCount", "notifySyncCompleteListener", "", "syncType", "Lcom/moengage/cards/internal/model/SyncType;", "hasUpdatedCards", "", "affectedCategories", "", "onAppBackground", "onAppOpen", "onLogout", "onSyncComplete", "registerSyncCompleteListener", "syncCompleteListener", "syncCards", "syncCards$cards_release", "trackCardDelivered", "unregisterSyncCompleteListener", "Companion", "cards_release"})
public final class CardController
implements AppBackgroundListener,
SyncCompleteListener {
    private final String tag;
    private ArrayList<SyncCompleteListener> syncCompleteListeners;
    @NotNull
    private final Handler mainThread;
    private static boolean hasCardSynced;
    private static boolean isSyncInProgress;
    private static CardController cardController;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Handler getMainThread() {
        return this.mainThread;
    }

    public final void onLogout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TaskManager.Companion.getInstance().execute((ITask)new CardLogoutTask(context));
    }

    public final void onAppOpen(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger.v((String)(this.tag + " onAppOpen() : "));
        TaskManager.Companion.getInstance().execute((ITask)new SyncCardsTask(context, SyncType.APP_OPEN));
    }

    @WorkerThread
    public final long getUnClickedCount(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Injection.INSTANCE.getRepository(context).getUnClickedCount();
    }

    @WorkerThread
    public final long getNewCardCount(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Injection.INSTANCE.getRepository(context).getNewCardCount();
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public final void trackCardDelivered(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            CardRepository repository = Injection.INSTANCE.getRepository(context);
            List<CardModel> allCards = repository.getCards();
            if (allCards.isEmpty()) {
                return;
            }
            List<CardMeta> cardMetas = new CardParser().cardMetaFromCardModel(allCards);
            Evaluator evaluator = new Evaluator();
            long currentTime = MoEUtils.currentMillis();
            for (CardMeta card : cardMetas) {
                if (!card.isNewCard() || !evaluator.canShowCard(card, currentTime)) continue;
                Properties properties = new Properties();
                properties.addAttribute("moe_card_category", (Object)card.getCategory());
                Object object = card.getMetaData();
                boolean bl = false;
                Iterator<Map.Entry<String, Object>> iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    void key;
                    Map.Entry<String, Object> entry;
                    Map.Entry<String, Object> entry2 = entry = iterator.next();
                    boolean bl2 = false;
                    object = entry2.getKey();
                    entry2 = entry;
                    bl2 = false;
                    Object value = entry2.getValue();
                    properties.addAttribute((String)key, value);
                }
                properties.setNonInteractive();
                MoEHelper.getInstance((Context)context).trackEvent(MoEConstants.MOE_CARD_DELIVERED, properties);
                repository.updateNewCardState(card.getCardId(), false);
            }
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " trackCardDelivered() : "), (Throwable)e);
        }
    }

    @Override
    public void onSyncComplete(@NotNull SyncType syncType, boolean hasUpdatedCards, @NotNull Set<String> affectedCategories) {
        Intrinsics.checkNotNullParameter((Object)((Object)syncType), (String)"syncType");
        Intrinsics.checkNotNullParameter(affectedCategories, (String)"affectedCategories");
        if (syncType == SyncType.APP_OPEN) {
            this.mainThread.post((Runnable)onSyncComplete.1.INSTANCE);
        }
    }

    public final void registerSyncCompleteListener(@NotNull SyncCompleteListener syncCompleteListener) {
        Intrinsics.checkNotNullParameter((Object)syncCompleteListener, (String)"syncCompleteListener");
        this.syncCompleteListeners.add(syncCompleteListener);
    }

    public final void unregisterSyncCompleteListener(@NotNull SyncCompleteListener syncCompleteListener) {
        Intrinsics.checkNotNullParameter((Object)syncCompleteListener, (String)"syncCompleteListener");
        this.syncCompleteListeners.remove(syncCompleteListener);
    }

    public final void notifySyncCompleteListener(@NotNull SyncType syncType, boolean hasUpdatedCards, @NotNull Set<String> affectedCategories) {
        Intrinsics.checkNotNullParameter((Object)((Object)syncType), (String)"syncType");
        Intrinsics.checkNotNullParameter(affectedCategories, (String)"affectedCategories");
        for (SyncCompleteListener syncCompleteLister : this.syncCompleteListeners) {
            try {
                syncCompleteLister.onSyncComplete(syncType, hasUpdatedCards, affectedCategories);
            }
            catch (Exception e) {
                Logger.e((String)(this.tag + " notifySyncCompleteListener() : "), (Throwable)e);
            }
        }
    }

    public void onAppBackground(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            if (!Injection.INSTANCE.getRepository(context).getFeatureStatus().isSdkEnabled()) {
                Logger.v((String)(this.tag + " onAppBackground() : SDK Disabled."));
                return;
            }
            TaskManager.Companion.getInstance().execute((ITask)new SyncDeletedCardsTask(context));
            TaskManager.Companion.getInstance().execute((ITask)new SyncStatsTask(context));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " goingToBackground() : "), (Throwable)e);
        }
    }

    public final void syncCards$cards_release(@NotNull Context context, @NotNull SyncType syncType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)syncType), (String)"syncType");
        Logger.v((String)(this.tag + " syncCards() : Will attempt to sync cards. Sync Type: " + (Object)((Object)syncType)));
        TaskManager.Companion.getInstance().execute(new Work(context, syncType){
            final /* synthetic */ Context $context;
            final /* synthetic */ SyncType $syncType;

            public final void doWork() {
                Injection.INSTANCE.getRepository(this.$context).syncCards(this.$syncType);
            }
            {
                this.$context = context;
                this.$syncType = syncType;
            }
        });
    }

    private CardController() {
        this.tag = "Cards_2.1.00_CardController";
        boolean bl = false;
        this.syncCompleteListeners = new ArrayList();
        this.mainThread = new Handler(Looper.getMainLooper());
        MoECallbacks.Companion.getInstance().addAppBackgroundListener((AppBackgroundListener)this);
        this.registerSyncCompleteListener(this);
    }

    static {
        Companion = new Companion(null);
    }

    public /* synthetic */ CardController(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/moengage/cards/internal/CardController$Companion;", "", "()V", "cardController", "Lcom/moengage/cards/internal/CardController;", "hasCardSynced", "", "getHasCardSynced", "()Z", "setHasCardSynced", "(Z)V", "isSyncInProgress", "setSyncInProgress", "getInstance", "cards_release"})
    public static final class Companion {
        public final boolean getHasCardSynced() {
            return hasCardSynced;
        }

        public final void setHasCardSynced(boolean bl) {
            hasCardSynced = bl;
        }

        public final boolean isSyncInProgress() {
            return isSyncInProgress;
        }

        public final void setSyncInProgress(boolean bl) {
            isSyncInProgress = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final CardController getInstance() {
            if (cardController == null) {
                Class<CardController> clazz = CardController.class;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (clazz) {
                    boolean bl3 = false;
                    if (cardController == null) {
                        CardController.cardController = new CardController(null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            CardController cardController = cardController;
            if (cardController == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.moengage.cards.internal.CardController");
            }
            return cardController;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

