/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal;

import com.moengage.core.internal.logger.Logger;

public class ImageUtils {
    private static final String TAG = "Cards_2.1.00_ImageUtils";
    private static final String[] USED_GLIDE_CLASSES = new String[]{"com.bumptech.glide.load.resource.gif.GifDrawable", "com.bumptech.glide.Glide"};

    public static boolean hasGifSupport() {
        try {
            ClassLoader staticClassLoader = ImageUtils.class.getClassLoader();
            boolean isGlideOnPath = true;
            for (String classPath : USED_GLIDE_CLASSES) {
                if (Class.forName(classPath, false, staticClassLoader) != null) continue;
                isGlideOnPath = false;
                break;
            }
            return isGlideOnPath;
        }
        catch (Exception e) {
            Logger.v((String)"Cards_2.1.00_ImageUtils hasGifSupport() Glide library not found");
        }
        catch (NoClassDefFoundError ncd) {
            Logger.v((String)"Cards_2.1.00_ImageUtils hasGifSupport() Glide library not found");
        }
        catch (Throwable t) {
            Logger.v((String)"Cards_2.1.00_ImageUtils hasGifSupport() Glide library not found");
        }
        return false;
    }
}

