/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal.repository;

import com.moengage.cards.internal.model.CardData;
import com.moengage.cards.internal.model.CardMeta;
import com.moengage.cards.internal.model.CardModel;
import com.moengage.cards.internal.model.GlobalCampaignState;
import com.moengage.cards.internal.repository.TemplateParser;
import com.moengage.cards.model.CampaignState;
import com.moengage.cards.model.Card;
import com.moengage.cards.model.DisplayControl;
import com.moengage.cards.model.MetaData;
import com.moengage.cards.model.Showtime;
import com.moengage.cards.model.Template;
import com.moengage.cards.model.enums.VisibilityStatus;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.utils.MoEUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0004J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0012\u001a\u00020\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0012\u0010(\u001a\u00020#2\b\u0010)\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020 0+2\b\u0010,\u001a\u0004\u0018\u00010\bH\u0002J\u001c\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010+2\u0006\u0010.\u001a\u00020\bH\u0002J\u0012\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u00102\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/moengage/cards/internal/repository/CardParser;", "", "()V", "tag", "", "cardDataFromJson", "Lcom/moengage/cards/internal/model/CardData;", "cardJson", "Lorg/json/JSONObject;", "cardDataFromJson$cards_release", "cardDataListFromResponse", "", "cardsArray", "Lorg/json/JSONArray;", "cardDataListFromResponse$cards_release", "cardDataToCardModel", "Lcom/moengage/cards/internal/model/CardModel;", "cardData", "uniqueId", "cardDataList", "cardMetaFromCardModel", "Lcom/moengage/cards/internal/model/CardMeta;", "cardModel", "cardModelList", "cardTemplateFromMeta", "Lcom/moengage/cards/model/Card;", "cardMeta", "cardMetaList", "displayControlFromJson", "Lcom/moengage/cards/model/DisplayControl;", "displayJson", "getDeletionTime", "", "displayControl", "globalCampaignState", "Lcom/moengage/cards/internal/model/GlobalCampaignState;", "campaignState", "Lcom/moengage/cards/model/CampaignState;", "getTotalShowCount", "localCount", "globalStateFromJson", "activityJson", "jsonToMap", "", "payloadJson", "metaDataFromCampaignPayload", "campaignPayload", "showTimeFromJson", "Lcom/moengage/cards/model/Showtime;", "showTimeJson", "updateExistingCard", "savedCard", "cards_release"})
public final class CardParser {
    private final String tag;

    @NotNull
    public final List<CardModel> cardDataToCardModel(@NotNull List<CardData> cardDataList, @NotNull String uniqueId) {
        Intrinsics.checkNotNullParameter(cardDataList, (String)"cardDataList");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        boolean bl = false;
        List cardModelList = new ArrayList();
        for (CardData cardData : cardDataList) {
            CardModel cardModel = this.cardDataToCardModel(cardData, uniqueId);
            if (cardModel == null) continue;
            cardModelList.add(cardModel);
        }
        return cardModelList;
    }

    @Nullable
    public final CardModel cardDataToCardModel(@NotNull CardData cardData, @NotNull String uniqueId) {
        Intrinsics.checkNotNullParameter((Object)cardData, (String)"cardData");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        try {
            CampaignState campaignState = new CampaignState(0L, cardData.getGlobalCampaignState().isClicked(), cardData.getGlobalCampaignState().getFirstReceived(), cardData.getGlobalCampaignState().getFirstShown(), this.getTotalShowCount(0L, cardData, uniqueId));
            String string2 = cardData.getCardId();
            String string3 = cardData.getCampaignPayload().getString("status");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cardData.campaignPayload\u2026      (VISIBILITY_STATUS)");
            String string4 = string3;
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
            VisibilityStatus visibilityStatus = VisibilityStatus.valueOf(string6);
            String string7 = cardData.getCampaignPayload().optString("category", "");
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"cardData.campaignPayload.optString(CATEGORY, \"\")");
            return new CardModel(-1L, string2, visibilityStatus, string7, cardData.getCampaignPayload().getLong("updated_at"), cardData.getCampaignPayload(), cardData.getDisplayControl().isPinned(), campaignState, this.getDeletionTime(cardData.getDisplayControl(), cardData.getGlobalCampaignState(), campaignState), true, false, cardData.getCampaignPayload().optInt("priority", 0));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " cardDataToCardModel() : "), (Throwable)e);
            return null;
        }
    }

    private final long getDeletionTime(DisplayControl displayControl, GlobalCampaignState globalCampaignState, CampaignState campaignState) {
        if (displayControl.getExpireAt() == -1L && displayControl.getExpireAfterDelivered() == -1L && displayControl.getExpireAfterSeen() == -1L) {
            return -1L;
        }
        if (displayControl.getExpireAt() != -1L) {
            return displayControl.getExpireAt();
        }
        if (displayControl.getExpireAfterDelivered() != -1L) {
            return globalCampaignState.getFirstReceived() != -1L ? globalCampaignState.getFirstReceived() + displayControl.getExpireAfterDelivered() : campaignState.getFirstReceived() + displayControl.getExpireAfterDelivered();
        }
        if (displayControl.getExpireAfterSeen() != -1L) {
            return globalCampaignState.getFirstShown() != -1L ? globalCampaignState.getFirstShown() + displayControl.getExpireAfterSeen() : (campaignState.getFirstSeen() != -1L ? campaignState.getFirstSeen() + displayControl.getExpireAfterSeen() : -1L);
        }
        return -1L;
    }

    @NotNull
    public final CardModel updateExistingCard(@NotNull CardData cardData, @NotNull CardModel savedCard, @NotNull String uniqueId) {
        Intrinsics.checkNotNullParameter((Object)cardData, (String)"cardData");
        Intrinsics.checkNotNullParameter((Object)savedCard, (String)"savedCard");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        long totalShowCount = this.getTotalShowCount(savedCard.getCampaignState().getLocalShowCount(), cardData, uniqueId);
        CampaignState campaignState = new CampaignState(savedCard.getCampaignState().getLocalShowCount(), cardData.getGlobalCampaignState().isClicked() || savedCard.getCampaignState().isClicked(), savedCard.getCampaignState().getFirstReceived() < cardData.getGlobalCampaignState().getFirstReceived() ? savedCard.getCampaignState().getFirstReceived() : cardData.getGlobalCampaignState().getFirstReceived(), cardData.getGlobalCampaignState().getFirstShown() < savedCard.getCampaignState().getFirstSeen() ? cardData.getGlobalCampaignState().getFirstShown() : savedCard.getCampaignState().getFirstSeen(), totalShowCount);
        long l = savedCard.getId();
        String string2 = cardData.getCardId();
        String string3 = cardData.getCampaignPayload().getString("status");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cardData.campaignPayload\u2026      (VISIBILITY_STATUS)");
        String string4 = string3;
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
        VisibilityStatus visibilityStatus = VisibilityStatus.valueOf(string6);
        String string7 = cardData.getCampaignPayload().getString("category");
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"cardData.campaignPayload.getString(CATEGORY)");
        return new CardModel(l, string2, visibilityStatus, string7, cardData.getCampaignPayload().getLong("updated_at"), cardData.getCampaignPayload(), campaignState.isClicked() ? false : cardData.getDisplayControl().isPinned(), campaignState, this.getDeletionTime(cardData.getDisplayControl(), cardData.getGlobalCampaignState(), campaignState), savedCard.isNewCard(), savedCard.isDeleted(), cardData.getCampaignPayload().optInt("priority", 0));
    }

    private final long getTotalShowCount(long localCount, CardData cardData, String uniqueId) {
        long totalShowCount = localCount;
        for (Map.Entry<String, Long> entry : cardData.getGlobalCampaignState().getShowCounts().entrySet()) {
            if (!(Intrinsics.areEqual((Object)entry.getKey(), (Object)uniqueId) ^ true)) continue;
            totalShowCount += ((Number)entry.getValue()).longValue();
        }
        return totalShowCount;
    }

    @NotNull
    public final List<Card> cardTemplateFromMeta(@NotNull List<CardMeta> cardMetaList) {
        Intrinsics.checkNotNullParameter(cardMetaList, (String)"cardMetaList");
        boolean bl = false;
        List templateList = new ArrayList();
        for (CardMeta cardMeta : cardMetaList) {
            Card cardTemplate = this.cardTemplateFromMeta(cardMeta);
            if (cardTemplate == null) continue;
            templateList.add(cardTemplate);
        }
        return templateList;
    }

    private final Card cardTemplateFromMeta(CardMeta cardMeta) {
        try {
            JSONObject jSONObject = cardMeta.getCampaignPayload().getJSONObject("template_data");
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"cardMeta.campaignPayload\u2026JSONObject(TEMPLATE_DATA)");
            Template template = new TemplateParser(jSONObject).parse();
            if (template == null) {
                return null;
            }
            Template template2 = template;
            return new Card(cardMeta.getId(), cardMeta.getCardId(), cardMeta.getCategory(), template2, new MetaData(cardMeta.isPinned(), cardMeta.getCampaignState(), cardMeta.getDeletionTime(), cardMeta.getDisplayControl(), cardMeta.getMetaData(), cardMeta.isNewCard(), cardMeta.getUpdatedTime(), cardMeta.getCampaignPayload()));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " cardTemplateFromMeta() : "), (Throwable)e);
            return null;
        }
    }

    private final Map<String, Object> metaDataFromCampaignPayload(JSONObject campaignPayload) {
        if (!campaignPayload.has("meta_data")) {
            return MapsKt.emptyMap();
        }
        Map map = MoEUtils.jsonToMap((JSONObject)campaignPayload.getJSONObject("meta_data"));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"MoEUtils.jsonToMap(campa\u2026getJSONObject(META_DATA))");
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CardData> cardDataListFromResponse$cards_release(@NotNull JSONArray cardsArray) {
        Intrinsics.checkNotNullParameter((Object)cardsArray, (String)"cardsArray");
        int n = 0;
        List cardDataList = new ArrayList();
        n = 0;
        int n2 = cardsArray.length();
        while (n < n2) {
            void i;
            JSONObject cardJson;
            JSONObject jSONObject = cardJson = cardsArray.getJSONObject((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"cardJson");
            CardData cardData = this.cardDataFromJson$cards_release(jSONObject);
            if (cardData != null) {
                cardDataList.add(cardData);
            }
            ++i;
        }
        return cardDataList;
    }

    @NotNull
    public final List<CardMeta> cardMetaFromCardModel(@NotNull List<CardModel> cardModelList) {
        Intrinsics.checkNotNullParameter(cardModelList, (String)"cardModelList");
        boolean bl = false;
        List metaList = new ArrayList();
        for (CardModel cardModel : cardModelList) {
            CardMeta cardMeta = this.cardMetaFromCardModel(cardModel);
            if (cardMeta == null) continue;
            metaList.add(cardMeta);
        }
        return metaList;
    }

    private final CardMeta cardMetaFromCardModel(CardModel cardModel) {
        try {
            long l = cardModel.getId();
            String string2 = cardModel.getCardId();
            String string3 = cardModel.getCategory();
            boolean bl = cardModel.isPinned();
            CampaignState campaignState = cardModel.getCampaignState();
            long l2 = cardModel.getDeletionTime();
            JSONObject jSONObject = cardModel.getCampaignPayload().getJSONObject("display_controls");
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"cardModel.campaignPayloa\u2026         DISPLAY_CONTROL)");
            return new CardMeta(l, string2, string3, bl, campaignState, l2, this.displayControlFromJson(jSONObject), this.metaDataFromCampaignPayload(cardModel.getCampaignPayload()), cardModel.isNewCard(), cardModel.getLastUpdatedTime(), cardModel.getCampaignPayload());
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " cardMetaFromCardModel() : "), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final CardData cardDataFromJson$cards_release(@NotNull JSONObject cardJson) {
        Intrinsics.checkNotNullParameter((Object)cardJson, (String)"cardJson");
        try {
            String string2 = cardJson.getString("id");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cardJson.getString(ID)");
            GlobalCampaignState globalCampaignState = this.globalStateFromJson(cardJson.optJSONObject("user_activity"));
            JSONObject jSONObject = cardJson.getJSONObject("display_controls");
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"cardJson.getJSONObject(DISPLAY_CONTROL)");
            return new CardData(string2, globalCampaignState, this.displayControlFromJson(jSONObject), cardJson);
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " cardFromJson() : "), (Throwable)e);
            return null;
        }
    }

    private final DisplayControl displayControlFromJson(JSONObject displayJson) {
        return new DisplayControl(displayJson.optLong("expire_at", -1L), displayJson.optLong("expire_after_seen", -1L), displayJson.optLong("expire_after_delivered", -1L), displayJson.optLong("max_times_to_show", -1L), displayJson.optBoolean("is_pin", false), this.showTimeFromJson(displayJson.optJSONObject("show_time")));
    }

    private final Showtime showTimeFromJson(JSONObject showTimeJson) {
        if (showTimeJson == null) {
            return new Showtime("", "");
        }
        String string2 = showTimeJson.getString("start_time");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"showTimeJson.getString(START_TIME)");
        String string3 = showTimeJson.getString("end_time");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"showTimeJson.getString(END_TIME)");
        return new Showtime(string2, string3);
    }

    private final GlobalCampaignState globalStateFromJson(JSONObject activityJson) {
        if (activityJson == null) {
            boolean bl = false;
            return new GlobalCampaignState(MapsKt.emptyMap(), false, -1L, -1L);
        }
        return new GlobalCampaignState(this.jsonToMap(activityJson.optJSONObject("show_count")), activityJson.optBoolean("is_clicked", false), activityJson.optLong("first_seen", -1L), activityJson.optLong("first_delivered", MoEUtils.currentSeconds()));
    }

    private final Map<String, Long> jsonToMap(JSONObject payloadJson) {
        if (payloadJson == null || payloadJson.length() == 0) {
            return new HashMap();
        }
        Map map = new HashMap(payloadJson.length());
        Iterator iterator = payloadJson.keys();
        try {
            while (iterator.hasNext()) {
                String key;
                String string2 = key = (String)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key");
                map.put(string2, payloadJson.getLong(key));
            }
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " jsonToMap() : "), (Throwable)e);
        }
        return map;
    }

    public CardParser() {
        this.tag = "Cards_2.1.00_CardParser";
    }
}

