/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal.repository;

import androidx.annotation.Nullable;
import com.moengage.cards.MoECardHelper;
import com.moengage.cards.internal.CardController;
import com.moengage.cards.internal.model.CardData;
import com.moengage.cards.internal.model.CardMeta;
import com.moengage.cards.internal.model.CardModel;
import com.moengage.cards.internal.model.SyncInterval;
import com.moengage.cards.internal.model.SyncType;
import com.moengage.cards.internal.model.network.DeleteRequest;
import com.moengage.cards.internal.model.network.DeleteResponse;
import com.moengage.cards.internal.model.network.StatsRequest;
import com.moengage.cards.internal.model.network.StatsResponse;
import com.moengage.cards.internal.model.network.SyncRequest;
import com.moengage.cards.internal.model.network.SyncResponse;
import com.moengage.cards.internal.repository.CardParser;
import com.moengage.cards.internal.repository.CardRepository$WhenMappings;
import com.moengage.cards.internal.repository.Evaluator;
import com.moengage.cards.internal.repository.local.LocalRepository;
import com.moengage.cards.internal.repository.remote.RemoteRepository;
import com.moengage.cards.model.CampaignState;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.BaseRequest;
import com.moengage.core.internal.remoteconfig.RConfigManager;
import com.moengage.core.internal.utils.JsonBuilder;
import com.moengage.core.internal.utils.MoEUtils;
import com.moengage.core.model.FeatureStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J%\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0096\u0001J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0007J\t\u0010\u0011\u001a\u00020\tH\u0096\u0001J\t\u0010\u0012\u001a\u00020\tH\u0096\u0001J\t\u0010\u0013\u001a\u00020\tH\u0096\u0001J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0096\u0001J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u001bH\u0096\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u0096\u0001J\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\u0013\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0007H\u0097\u0001J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0096\u0001J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0096\u0001J\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0096\u0001J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070%H\u0096\u0001J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0096\u0001J\t\u0010'\u001a\u00020(H\u0096\u0001J\t\u0010)\u001a\u00020\u0019H\u0096\u0001J\t\u0010*\u001a\u00020\u0019H\u0096\u0001J\u0006\u0010+\u001a\u00020\u0019J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0096\u0001J\u0012\u0010-\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0096\u0001J\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0096\u0001J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0096\u0001J\t\u00101\u001a\u000202H\u0096\u0001J\u0006\u00103\u001a\u00020\u0019J\u000f\u00104\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0096\u0001J\u0011\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\fH\u0096\u0001J\u0006\u00107\u001a\u000208J\t\u00109\u001a\u000208H\u0096\u0001J\u0006\u0010:\u001a\u00020\tJ\u0006\u0010;\u001a\u00020\tJ\u0011\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u0019H\u0096\u0001J2\u0010>\u001a\u00020\t2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u000b2\u0006\u0010C\u001a\u00020DH\u0002J\u0017\u0010E\u001a\u00020\t2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0096\u0001J\u0011\u0010G\u001a\u00020\t2\u0006\u0010=\u001a\u00020\u0019H\u0096\u0001J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\fH\u0002J\u0011\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020MH\u0096\u0001J\u0011\u0010N\u001a\u00020\t2\u0006\u0010=\u001a\u00020\u0019H\u0096\u0001J\u0011\u0010O\u001a\u00020\t2\u0006\u0010P\u001a\u000208H\u0096\u0001J\u0017\u0010Q\u001a\u00020\t2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0096\u0001J\u0011\u0010R\u001a\u00020\t2\u0006\u0010S\u001a\u000202H\u0096\u0001J\u0006\u0010T\u001a\u00020\tJ\u000e\u0010U\u001a\u0002082\u0006\u0010V\u001a\u00020WJ\u0011\u0010U\u001a\u00020X2\u0006\u0010C\u001a\u00020DH\u0096\u0001J\u0006\u0010Y\u001a\u00020\tJ\u0011\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\H\u0096\u0001J\u0018\u0010]\u001a\u00020\u00192\u0006\u0010V\u001a\u00020W2\u0006\u0010S\u001a\u000202H\u0002J\u0011\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020aH\u0096\u0001J)\u0010b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u0002082\u0006\u0010f\u001a\u00020\u0019H\u0096\u0001J\u0019\u0010g\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010P\u001a\u000208H\u0096\u0001R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lcom/moengage/cards/internal/repository/CardRepository;", "Lcom/moengage/cards/internal/repository/remote/RemoteRepository;", "Lcom/moengage/cards/internal/repository/local/LocalRepository;", "remoteRepository", "localRepository", "(Lcom/moengage/cards/internal/repository/remote/RemoteRepository;Lcom/moengage/cards/internal/repository/local/LocalRepository;)V", "tag", "", "addOrUpdateCards", "", "newCardList", "", "Lcom/moengage/cards/internal/model/CardModel;", "updateCardList", "cardsByCategory", "Lcom/moengage/cards/internal/model/CardMeta;", "category", "clearData", "clearDeletedIds", "clearShownCards", "deleteCard", "", "cardId", "deleteExpiredCampaigns", "currentTime", "", "getAllCards", "", "getBaseRequest", "Lcom/moengage/core/internal/model/BaseRequest;", "getCampaignsEligibleForDeletion", "", "getCardById", "getCardIds", "getCards", "getCardsForCategory", "getCategories", "Ljava/util/LinkedList;", "getDeletedCardIds", "getFeatureStatus", "Lcom/moengage/core/model/FeatureStatus;", "getLastCardSyncTime", "getLastStatsSyncTime", "getNewCardCount", "getNewCards", "getPinnedCardForCategory", "getPinnedCards", "getPinnedCardsForCategory", "getShownCards", "getSyncInterval", "Lcom/moengage/cards/internal/model/SyncInterval;", "getUnClickedCount", "getVisibleCards", "insertCard", "cardModel", "isModuleEnabled", "", "isShowAllTabEnabled", "persistAndSyncCardStats", "persistAndSyncDeletedCards", "removeExpiredCards", "time", "saveCards", "storedCards", "", "currentCards", "Lcom/moengage/cards/internal/model/CardData;", "syncRequest", "Lcom/moengage/cards/internal/model/network/SyncRequest;", "saveDeletedCardId", "cardIds", "saveLastCardSyncTime", "statJsonFromCard", "Lorg/json/JSONObject;", "card", "storeCategories", "categories", "Lorg/json/JSONArray;", "storeLastStatsSyncTime", "storeShowAllTabState", "state", "storeShownCards", "storeSyncInterval", "syncInterval", "syncCardStats", "syncCards", "syncType", "Lcom/moengage/cards/internal/model/SyncType;", "Lcom/moengage/cards/internal/model/network/SyncResponse;", "syncDeletedCards", "Lcom/moengage/cards/internal/model/network/DeleteResponse;", "deleteRequest", "Lcom/moengage/cards/internal/model/network/DeleteRequest;", "syncIntervalForType", "syncStats", "Lcom/moengage/cards/internal/model/network/StatsResponse;", "statsRequest", "Lcom/moengage/cards/internal/model/network/StatsRequest;", "updateCardState", "campaignState", "Lcom/moengage/cards/model/CampaignState;", "isPinned", "deletionTime", "updateNewCardState", "cards_release"})
public final class CardRepository
implements RemoteRepository,
LocalRepository {
    private final String tag;
    private final RemoteRepository remoteRepository;
    private final LocalRepository localRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean syncCards(@NotNull SyncType syncType) {
        Intrinsics.checkNotNullParameter((Object)((Object)syncType), (String)"syncType");
        Class<CardRepository> clazz = CardRepository.class;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (clazz) {
            long currentTime;
            boolean hasUpdatedCards;
            block19: {
                boolean bl3 = false;
                if (!this.isModuleEnabled()) {
                    boolean bl4 = false;
                    return bl4;
                }
                hasUpdatedCards = false;
                try {
                    Logger.v((String)(this.tag + " syncCards() : Will try to sync cards. Sync type: " + (Object)((Object)syncType)));
                    currentTime = MoEUtils.currentSeconds();
                    if (!CardController.Companion.isSyncInProgress()) break block19;
                    boolean bl5 = false;
                    return bl5;
                }
                catch (Exception e) {
                    Logger.e((String)(this.tag + " syncCards() : "), (Throwable)e);
                    CardController.Companion.getInstance().notifySyncCompleteListener(syncType, false, SetsKt.emptySet());
                    CardController.Companion.setSyncInProgress(false);
                    boolean bl6 = false;
                    return bl6;
                }
            }
            Logger.v((String)(this.tag + " syncCards() : Last Sync Time: " + this.getLastCardSyncTime()));
            Logger.v((String)(this.tag + " syncCards() : Sync Interval: " + this.getSyncInterval()));
            Evaluator evaluator = new Evaluator();
            if (!evaluator.isCardSyncRequired(CardController.Companion.getHasCardSynced(), this.syncIntervalForType(syncType, this.getSyncInterval()), this.getLastCardSyncTime(), currentTime)) {
                Logger.v((String)(this.tag + " syncCards() : Sync not required. returning."));
                CardController.Companion.getInstance().notifySyncCompleteListener(syncType, hasUpdatedCards, SetsKt.emptySet());
                CardController.Companion.setSyncInProgress(false);
                boolean bl7 = false;
                return bl7;
            }
            Logger.v((String)(this.tag + " syncCards() : Syncing cards."));
            CardController.Companion.setSyncInProgress(true);
            BaseRequest baseRequest = this.localRepository.getBaseRequest();
            String string2 = MoEUtils.getRequestId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MoEUtils.getRequestId()");
            SyncRequest syncRequest = new SyncRequest(baseRequest, string2, this.getLastCardSyncTime(), this.localRepository.getCardIds());
            SyncResponse syncResponse = this.remoteRepository.syncCards(syncRequest);
            if (!syncResponse.isSuccess() || syncResponse.getSyncData() == null) {
                CardController.Companion.getInstance().notifySyncCompleteListener(syncType, hasUpdatedCards, SetsKt.emptySet());
                CardController.Companion.setSyncInProgress(false);
                boolean bl8 = false;
                return bl8;
            }
            this.saveLastCardSyncTime(currentTime);
            if (syncResponse.getSyncData().getSyncInterval() != null) {
                this.storeSyncInterval(syncResponse.getSyncData().getSyncInterval());
            }
            this.storeShowAllTabState(syncResponse.getSyncData().getShouldShowAllTab());
            CardController.Companion.setHasCardSynced(true);
            Collection collection = syncResponse.getSyncData().getDeletedCampaigns();
            boolean bl9 = false;
            if (!collection.isEmpty()) {
                hasUpdatedCards = true;
                for (String cardId : syncResponse.getSyncData().getDeletedCampaigns()) {
                    this.deleteCard(cardId);
                }
            }
            this.storeCategories(syncResponse.getSyncData().getCategoriesList());
            this.deleteExpiredCampaigns(currentTime);
            Map storedCards = MapsKt.toMutableMap(this.localRepository.getAllCards());
            if (syncResponse.getSyncData().getCardList().isEmpty()) {
                CardController.Companion.getInstance().notifySyncCompleteListener(syncType, hasUpdatedCards, SetsKt.emptySet());
                CardController.Companion.setSyncInProgress(false);
                boolean bl10 = false;
                return bl10;
            }
            hasUpdatedCards = true;
            this.saveCards(storedCards, syncResponse.getSyncData().getCardList(), syncRequest);
            CardController.Companion.setSyncInProgress(false);
            CardController.Companion.getInstance().notifySyncCompleteListener(syncType, hasUpdatedCards, SetsKt.emptySet());
            boolean bl11 = true;
            return bl11;
        }
    }

    private final void deleteExpiredCampaigns(long currentTime) {
        Set<String> campaignsEligibleForDeletion = this.getCampaignsEligibleForDeletion(currentTime);
        Collection collection = campaignsEligibleForDeletion;
        boolean bl = false;
        if (!collection.isEmpty()) {
            MoECardHelper.Companion.getInstance().getDeletedCards$cards_release().addAll((Collection<String>)campaignsEligibleForDeletion);
        }
        this.removeExpiredCards(currentTime);
    }

    private final void saveCards(Map<String, CardModel> storedCards, List<CardData> currentCards, SyncRequest syncRequest) {
        CardParser cardParser = new CardParser();
        if (storedCards.isEmpty()) {
            String string2 = syncRequest.uniqueId;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"syncRequest.uniqueId");
            this.addOrUpdateCards(cardParser.cardDataToCardModel(currentCards, string2), CollectionsKt.emptyList());
        } else {
            boolean bl = false;
            List newCards = new ArrayList();
            boolean bl2 = false;
            List updatedCards = new ArrayList();
            for (CardData cardData : currentCards) {
                CardModel storedCard = storedCards.get(cardData.getCardId());
                if (storedCard != null) {
                    String string3 = syncRequest.uniqueId;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"syncRequest.uniqueId");
                    CardModel updateCardModel = cardParser.updateExistingCard(cardData, storedCard, string3);
                    storedCards.remove(cardData.getCardId());
                    updatedCards.add(updateCardModel);
                    continue;
                }
                String string4 = syncRequest.uniqueId;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"syncRequest.uniqueId");
                CardModel cardModel = cardParser.cardDataToCardModel(cardData, string4);
                if (cardModel == null) continue;
                newCards.add(cardModel);
            }
            MoECardHelper.Companion.getInstance().onNewCardsAvailable(newCards);
            this.addOrUpdateCards(newCards, updatedCards);
        }
    }

    private final long syncIntervalForType(SyncType syncType, SyncInterval syncInterval) {
        long l;
        switch (CardRepository$WhenMappings.$EnumSwitchMapping$0[syncType.ordinal()]) {
            case 1: {
                l = syncInterval.getAppOpen();
                break;
            }
            case 2: {
                l = syncInterval.getAppInbox();
                break;
            }
            case 3: {
                l = syncInterval.getPullToRefresh();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    public final void syncDeletedCards() {
        try {
            Logger.v((String)(this.tag + " syncDeletedCards() : Will sync deleted cards"));
            if (!this.isModuleEnabled()) {
                return;
            }
            Set<String> deletedCards = this.getDeletedCardIds();
            if (deletedCards.isEmpty()) {
                Logger.v((String)(this.tag + " syncDeletedCards() : No cards to delete."));
                return;
            }
            Logger.v((String)(this.tag + " syncDeletedCards() : Deleting cards: " + deletedCards));
            BaseRequest baseRequest = this.getBaseRequest();
            String string2 = MoEUtils.getRequestId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MoEUtils.getRequestId()");
            DeleteResponse deleteResponse = this.remoteRepository.syncDeletedCards(new DeleteRequest(baseRequest, deletedCards, string2));
            if (deleteResponse.isSuccess()) {
                this.clearDeletedIds();
            }
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " syncDeletedCards() : "), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CardMeta> cardsByCategory(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        try {
            void $this$filterTo$iv$iv;
            Logger.v((String)(this.tag + " cardsByCategory() : Fetching cards for category: " + category));
            if (!this.isModuleEnabled()) {
                return CollectionsKt.emptyList();
            }
            boolean bl = false;
            List eligibleCards = new ArrayList();
            CardMeta pinned = this.getPinnedCardForCategory(category);
            if (pinned != null) {
                eligibleCards.add(pinned);
            }
            List<CardModel> cardsForCategory2 = Intrinsics.areEqual((Object)category, (Object)"All") ? this.localRepository.getCards() : this.localRepository.getCardsForCategory(category);
            Logger.v((String)(this.tag + " cardsByCategory() : Cards for category: " + cardsForCategory2));
            Iterable $this$filter$iv = cardsForCategory2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CardModel it = (CardModel)element$iv$iv;
                boolean bl2 = false;
                CardMeta cardMeta = pinned;
                if (!(Intrinsics.areEqual((Object)it.getCardId(), (Object)(cardMeta != null ? cardMeta.getCardId() : null)) ^ true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List cards = (List)destination$iv$iv;
            Logger.v((String)(this.tag + " cardsByCategory() : Filtered Cards: " + cards));
            List<CardMeta> cardMeta = new CardParser().cardMetaFromCardModel(cards);
            eligibleCards.addAll((Collection)new Evaluator().getCardsEligibleForDisplay(cardMeta, MoEUtils.currentMillis()));
            return eligibleCards;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " cardsByCategory() : "), (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    private final CardMeta getPinnedCardForCategory(String category) {
        CardMeta pinned = null;
        try {
            List<CardModel> pinnedCards;
            List<CardModel> list = pinnedCards = Intrinsics.areEqual((Object)category, (Object)"All") ? this.localRepository.getPinnedCards() : this.localRepository.getPinnedCardsForCategory(category);
            if (pinnedCards.isEmpty()) {
                return null;
            }
            List<CardMeta> pinnedCardsMeta = new CardParser().cardMetaFromCardModel(pinnedCards);
            long currentTime = MoEUtils.currentMillis();
            Evaluator evaluator = new Evaluator();
            for (CardMeta pinnedCard : pinnedCardsMeta) {
                if (!evaluator.canShowCard(pinnedCard, currentTime)) continue;
                pinned = pinnedCard;
                break;
            }
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getPinnedCardForCategory() : "), (Throwable)e);
        }
        return pinned;
    }

    /*
     * WARNING - void declaration
     */
    public final long getUnClickedCount() {
        try {
            void $this$filterTo$iv$iv;
            Logger.v((String)(this.tag + " getUnClickedCount() : Will fetch un-clicked card count."));
            if (!this.isModuleEnabled()) {
                return 0L;
            }
            List<CardModel> cardModelList = this.localRepository.getVisibleCards();
            if (cardModelList.isEmpty()) {
                return 0L;
            }
            List<CardMeta> cardMetaList = new CardParser().cardMetaFromCardModel(cardModelList);
            Evaluator evaluator = new Evaluator();
            long currentTime = MoEUtils.currentMillis();
            Iterable $this$filter$iv = cardMetaList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CardMeta cardMeta = (CardMeta)element$iv$iv;
                boolean bl = false;
                if (!(!cardMeta.getCampaignState().isClicked() && evaluator.canShowCard(cardMeta, currentTime))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List unclickedCards = (List)destination$iv$iv;
            return unclickedCards.size();
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getUnReadCardCount() : "), (Throwable)e);
            return 0L;
        }
    }

    public final long getNewCardCount() {
        try {
            Logger.v((String)(this.tag + " getNewCardCount() : Will fetch new cards. "));
            if (!this.isModuleEnabled()) {
                return 0L;
            }
            List<CardModel> cardModelList = this.localRepository.getNewCards();
            if (cardModelList.isEmpty()) {
                return 0L;
            }
            List<CardMeta> cardMeta = new CardParser().cardMetaFromCardModel(cardModelList);
            long newCardCount = 0L;
            Evaluator evaluator = new Evaluator();
            long currentTime = MoEUtils.currentMillis();
            for (CardMeta card : cardMeta) {
                if (!evaluator.canShowCard(card, currentTime)) continue;
                long l = newCardCount;
                newCardCount = l + 1L;
            }
            return newCardCount;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getNewCardCount() : "), (Throwable)e);
            return 0L;
        }
    }

    public final void syncCardStats() {
        Logger.v((String)(this.tag + " syncCardStats() : Will sync stats now"));
        if (!this.isModuleEnabled()) {
            return;
        }
        Set<String> cardIds = this.getShownCards();
        Logger.v((String)(this.tag + " syncCardStats() : Card Stats will for given Ids: " + cardIds));
        if (cardIds.isEmpty()) {
            return;
        }
        JSONArray cards = new JSONArray();
        for (String cardId : cardIds) {
            CardModel card;
            if (this.getCardById(cardId) == null) {
                continue;
            }
            cards.put((Object)this.statJsonFromCard(card));
        }
        if (cards.length() == 0) {
            Logger.v((String)(this.tag + " syncCardStats() : No status to sync."));
            return;
        }
        BaseRequest baseRequest = this.getBaseRequest();
        String string2 = MoEUtils.getRequestId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MoEUtils.getRequestId()");
        StatsRequest request = new StatsRequest(baseRequest, string2, cards);
        StatsResponse response = this.remoteRepository.syncStats(request);
        if (response.isSuccess()) {
            this.clearShownCards();
            this.storeLastStatsSyncTime(MoEUtils.currentSeconds());
        }
    }

    private final JSONObject statJsonFromCard(CardModel card) {
        JsonBuilder statJson = new JsonBuilder();
        statJson.putString("card_id", card.getCardId());
        if (card.getCampaignState().getLocalShowCount() > 0L) {
            statJson.putLong("show_count", card.getCampaignState().getLocalShowCount());
        }
        if (card.getCampaignState().isClicked()) {
            statJson.putBoolean("is_clicked", true);
        }
        if (card.getCampaignState().getFirstReceived() > 0L) {
            statJson.putLong("first_delivered", card.getCampaignState().getFirstReceived());
        }
        if (card.getCampaignState().getFirstSeen() > 0L) {
            statJson.putLong("first_seen", card.getCampaignState().getFirstSeen());
        }
        JSONObject jSONObject = statJson.build();
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"statJson.build()");
        return jSONObject;
    }

    public final void persistAndSyncDeletedCards() {
        this.saveDeletedCardId(MoECardHelper.Companion.getInstance().getDeletedCards$cards_release());
        MoECardHelper.Companion.getInstance().getDeletedCards$cards_release().clear();
        this.syncDeletedCards();
    }

    public final void persistAndSyncCardStats() {
        Set<String> userActivity = MoECardHelper.Companion.getInstance().getAppSessionCards();
        Collection collection = userActivity;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.storeShownCards(userActivity);
        }
        MoECardHelper.Companion.getInstance().clearAppSessionCards();
        this.syncCardStats();
    }

    public final boolean isModuleEnabled() {
        boolean isModuleEnabled = this.getFeatureStatus().isSdkEnabled() && RConfigManager.INSTANCE.getConfig().isAppEnabled() && RConfigManager.INSTANCE.getConfig().isCardsEnabled();
        Logger.v((String)(this.tag + " isModuleEnabled() : isEnabled? " + isModuleEnabled));
        return isModuleEnabled;
    }

    public CardRepository(@NotNull RemoteRepository remoteRepository, @NotNull LocalRepository localRepository) {
        Intrinsics.checkNotNullParameter((Object)remoteRepository, (String)"remoteRepository");
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        this.remoteRepository = remoteRepository;
        this.localRepository = localRepository;
        this.tag = "Cards_2.1.00_CardRepository";
    }

    @Override
    @NotNull
    public SyncResponse syncCards(@NotNull SyncRequest syncRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)syncRequest), (String)"syncRequest");
        return this.remoteRepository.syncCards(syncRequest);
    }

    @Override
    @NotNull
    public DeleteResponse syncDeletedCards(@NotNull DeleteRequest deleteRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)deleteRequest), (String)"deleteRequest");
        return this.remoteRepository.syncDeletedCards(deleteRequest);
    }

    @Override
    @NotNull
    public StatsResponse syncStats(@NotNull StatsRequest statsRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)statsRequest), (String)"statsRequest");
        return this.remoteRepository.syncStats(statsRequest);
    }

    @Override
    public void addOrUpdateCards(@NotNull List<CardModel> newCardList, @NotNull List<CardModel> updateCardList) {
        Intrinsics.checkNotNullParameter(newCardList, (String)"newCardList");
        Intrinsics.checkNotNullParameter(updateCardList, (String)"updateCardList");
        this.localRepository.addOrUpdateCards(newCardList, updateCardList);
    }

    @Override
    public void clearData() {
        this.localRepository.clearData();
    }

    @Override
    public void clearDeletedIds() {
        this.localRepository.clearDeletedIds();
    }

    @Override
    public void clearShownCards() {
        this.localRepository.clearShownCards();
    }

    @Override
    public int deleteCard(@NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        return this.localRepository.deleteCard(cardId);
    }

    @Override
    @NotNull
    public Map<String, CardModel> getAllCards() {
        return this.localRepository.getAllCards();
    }

    @Override
    @NotNull
    public BaseRequest getBaseRequest() {
        return this.localRepository.getBaseRequest();
    }

    @Override
    @NotNull
    public Set<String> getCampaignsEligibleForDeletion(long currentTime) {
        return this.localRepository.getCampaignsEligibleForDeletion(currentTime);
    }

    @Override
    @Nullable
    @org.jetbrains.annotations.Nullable
    public CardModel getCardById(@NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        return this.localRepository.getCardById(cardId);
    }

    @Override
    @NotNull
    public List<String> getCardIds() {
        return this.localRepository.getCardIds();
    }

    @Override
    @NotNull
    public List<CardModel> getCards() {
        return this.localRepository.getCards();
    }

    @Override
    @NotNull
    public List<CardModel> getCardsForCategory(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return this.localRepository.getCardsForCategory(category);
    }

    @Override
    @NotNull
    public LinkedList<String> getCategories() {
        return this.localRepository.getCategories();
    }

    @Override
    @NotNull
    public Set<String> getDeletedCardIds() {
        return this.localRepository.getDeletedCardIds();
    }

    @Override
    @NotNull
    public FeatureStatus getFeatureStatus() {
        return this.localRepository.getFeatureStatus();
    }

    @Override
    public long getLastCardSyncTime() {
        return this.localRepository.getLastCardSyncTime();
    }

    @Override
    public long getLastStatsSyncTime() {
        return this.localRepository.getLastStatsSyncTime();
    }

    @Override
    @NotNull
    public List<CardModel> getNewCards() {
        return this.localRepository.getNewCards();
    }

    @Override
    @NotNull
    public List<CardModel> getPinnedCards() {
        return this.localRepository.getPinnedCards();
    }

    @Override
    @NotNull
    public List<CardModel> getPinnedCardsForCategory(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return this.localRepository.getPinnedCardsForCategory(category);
    }

    @Override
    @NotNull
    public Set<String> getShownCards() {
        return this.localRepository.getShownCards();
    }

    @Override
    @NotNull
    public SyncInterval getSyncInterval() {
        return this.localRepository.getSyncInterval();
    }

    @Override
    @NotNull
    public List<CardModel> getVisibleCards() {
        return this.localRepository.getVisibleCards();
    }

    @Override
    public long insertCard(@NotNull CardModel cardModel) {
        Intrinsics.checkNotNullParameter((Object)cardModel, (String)"cardModel");
        return this.localRepository.insertCard(cardModel);
    }

    @Override
    public boolean isShowAllTabEnabled() {
        return this.localRepository.isShowAllTabEnabled();
    }

    @Override
    public int removeExpiredCards(long time) {
        return this.localRepository.removeExpiredCards(time);
    }

    @Override
    public void saveDeletedCardId(@NotNull Set<String> cardIds) {
        Intrinsics.checkNotNullParameter(cardIds, (String)"cardIds");
        this.localRepository.saveDeletedCardId(cardIds);
    }

    @Override
    public void saveLastCardSyncTime(long time) {
        this.localRepository.saveLastCardSyncTime(time);
    }

    @Override
    public void storeCategories(@NotNull JSONArray categories) {
        Intrinsics.checkNotNullParameter((Object)categories, (String)"categories");
        this.localRepository.storeCategories(categories);
    }

    @Override
    public void storeLastStatsSyncTime(long time) {
        this.localRepository.storeLastStatsSyncTime(time);
    }

    @Override
    public void storeShowAllTabState(boolean state) {
        this.localRepository.storeShowAllTabState(state);
    }

    @Override
    public void storeShownCards(@NotNull Set<String> cardIds) {
        Intrinsics.checkNotNullParameter(cardIds, (String)"cardIds");
        this.localRepository.storeShownCards(cardIds);
    }

    @Override
    public void storeSyncInterval(@NotNull SyncInterval syncInterval) {
        Intrinsics.checkNotNullParameter((Object)syncInterval, (String)"syncInterval");
        this.localRepository.storeSyncInterval(syncInterval);
    }

    @Override
    public int updateCardState(@NotNull String cardId, @NotNull CampaignState campaignState, boolean isPinned, long deletionTime) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)campaignState, (String)"campaignState");
        return this.localRepository.updateCardState(cardId, campaignState, isPinned, deletionTime);
    }

    @Override
    public int updateNewCardState(@NotNull String cardId, boolean state) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        return this.localRepository.updateNewCardState(cardId, state);
    }
}

