/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal.repository;

import com.moengage.cards.internal.model.CardMeta;
import com.moengage.cards.model.Showtime;
import com.moengage.core.internal.MoECoreEvaluator;
import com.moengage.core.internal.logger.Logger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/moengage/cards/internal/repository/Evaluator;", "", "()V", "tag", "", "canShowCard", "", "card", "Lcom/moengage/cards/internal/model/CardMeta;", "currentTime", "", "canShowCardNow", "showtime", "Lcom/moengage/cards/model/Showtime;", "getCardsEligibleForDisplay", "", "cardList", "isCardSyncRequired", "hasCardsSynced", "syncInterval", "lastSyncTime", "isStatSyncRequired", "cards_release"})
public final class Evaluator {
    private final String tag;

    public final boolean canShowCardNow(@NotNull Showtime showtime) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)showtime, (String)"showtime");
                CharSequence charSequence = showtime.getEndTime();
                boolean bl = false;
                if (charSequence.length() == 0) break block2;
                charSequence = showtime.getStartTime();
                bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            return true;
        }
        List list = StringsKt.split$default((CharSequence)showtime.getStartTime(), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        String string2 = (String)list.get(0);
        boolean bl = false;
        int hour = Integer.parseInt(string2);
        String string3 = (String)list.get(1);
        boolean bl2 = false;
        int minutes = Integer.parseInt(string3);
        long startTime = hour * 100 + minutes;
        list = StringsKt.split$default((CharSequence)showtime.getEndTime(), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        String string4 = (String)list.get(0);
        boolean bl3 = false;
        hour = Integer.parseInt(string4);
        string4 = (String)list.get(1);
        bl3 = false;
        minutes = Integer.parseInt(string4);
        long endTime = hour * 100 + minutes;
        Calendar rightNow = Calendar.getInstance();
        return new MoECoreEvaluator().canShowCampaignNow(startTime, endTime, rightNow.get(11), rightNow.get(12));
    }

    public final boolean canShowCard(@NotNull CardMeta card, long currentTime) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        if (card.getDisplayControl().getMaxCount() != -1L && card.getCampaignState().getTotalShowCount() >= card.getDisplayControl().getMaxCount()) {
            Logger.i((String)(this.tag + " canShowCard() : Cannot show card, already shown max times. Card-id: " + card.getCardId()));
            return false;
        }
        if (!this.canShowCardNow(card.getDisplayControl().getShowtime())) {
            Logger.i((String)(this.tag + " canShowCard() : Cannot show card, not in the time slot. Card-id: " + card.getCardId()));
            return false;
        }
        if (card.getDeletionTime() != -1L && card.getDeletionTime() < currentTime / (long)1000) {
            Logger.i((String)(this.tag + " canShowCard() : Card has expired. Card-id: " + card.getCardId()));
            return false;
        }
        return true;
    }

    public final boolean isCardSyncRequired(boolean hasCardsSynced, long syncInterval, long lastSyncTime, long currentTime) {
        return !hasCardsSynced || lastSyncTime + syncInterval < currentTime;
    }

    @NotNull
    public final List<CardMeta> getCardsEligibleForDisplay(@NotNull List<CardMeta> cardList, long currentTime) {
        Intrinsics.checkNotNullParameter(cardList, (String)"cardList");
        boolean bl = false;
        List eligibleCards = new ArrayList();
        for (CardMeta card : cardList) {
            if (!this.canShowCard(card, currentTime)) continue;
            eligibleCards.add(card);
        }
        return eligibleCards;
    }

    public final boolean isStatSyncRequired(long lastSyncTime, long syncInterval, long currentTime) {
        return lastSyncTime + syncInterval < currentTime;
    }

    public Evaluator() {
        this.tag = "Cards_2.1.00_Evaluator";
    }
}

