/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal.repository;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.collection.LruCache;
import com.moengage.cards.internal.repository.ImageCache;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.storage.MoEFileManager;
import com.moengage.core.internal.utils.MoEUtils;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/moengage/cards/internal/repository/ImageCache;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "fileManager", "Lcom/moengage/core/internal/storage/MoEFileManager;", "memoryCache", "com/moengage/cards/internal/repository/ImageCache$memoryCache$1", "Lcom/moengage/cards/internal/repository/ImageCache$memoryCache$1;", "tag", "", "cacheImage", "", "imageUrl", "bitmap", "Landroid/graphics/Bitmap;", "cardId", "getImageFromFileCache", "getImageFromInMemoryCache", "getMd5FromString", "Companion", "cards_release"})
public final class ImageCache {
    private final String tag;
    private final MoEFileManager fileManager;
    private final memoryCache.1 memoryCache;
    private final Context context;
    private static ImageCache instance;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final Bitmap getImageFromInMemoryCache(@NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        return (Bitmap)this.memoryCache.get(imageUrl);
    }

    @Nullable
    public final Bitmap getImageFromFileCache(@NotNull String cardId, @NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        try {
            String fileName = this.getMd5FromString(imageUrl);
            if (this.fileManager.fileExistsInDirectory(cardId, fileName)) {
                return BitmapFactory.decodeFile((String)this.fileManager.getPathForFile(cardId, fileName));
            }
            return null;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getImageFromFileCache() : "), (Throwable)e);
            return null;
        }
    }

    public final void cacheImage(@NotNull String imageUrl, @NotNull Bitmap bitmap, @NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        try {
            this.memoryCache.put(imageUrl, bitmap);
            this.fileManager.saveImageFile(cardId, this.getMd5FromString(imageUrl), bitmap);
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " cacheImage() : "), (Throwable)e);
        }
    }

    private final String getMd5FromString(String imageUrl) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string2 = imageUrl;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        messageDigest.update(byArray);
        String string4 = MoEUtils.bytesToHex((byte[])messageDigest.digest());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"MoEUtils.bytesToHex(messageDigest.digest())");
        return string4;
    }

    private ImageCache(Context context) {
        this.context = context;
        this.tag = "Cards_2.1.00_ImageCache";
        this.fileManager = new MoEFileManager(this.context);
        this.memoryCache = new LruCache<String, Bitmap>((int)(Runtime.getRuntime().maxMemory() / (long)1024)){

            protected int sizeOf(@NotNull String key, @NotNull Bitmap bitmap) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                return bitmap.getByteCount() / 1024;
            }
        };
    }

    static {
        Companion = new Companion(null);
    }

    public /* synthetic */ ImageCache(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/moengage/cards/internal/repository/ImageCache$Companion;", "", "()V", "instance", "Lcom/moengage/cards/internal/repository/ImageCache;", "getInstance", "context", "Landroid/content/Context;", "cards_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ImageCache getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (instance == null) {
                Class<ImageCache> clazz = ImageCache.class;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (clazz) {
                    boolean bl3 = false;
                    if (instance == null) {
                        instance = new ImageCache(context, null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            ImageCache imageCache = instance;
            if (imageCache == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.moengage.cards.internal.repository.ImageCache");
            }
            return imageCache;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

