/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal.repository;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.ImageView;
import com.moengage.cards.internal.repository.ImageCache;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.ViewDimension;
import com.moengage.core.internal.utils.MoEUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J{\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072K\u0010\u0012\u001aG\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\t0\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/moengage/cards/internal/repository/ImageLoader;", "", "()V", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "tag", "", "loadImage", "", "context", "Landroid/content/Context;", "imageUrl", "imageView", "Landroid/widget/ImageView;", "viewDimension", "Lcom/moengage/core/internal/model/ViewDimension;", "cardId", "scaler", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Landroid/graphics/Bitmap;", "bitmap", "AsyncImageLoader", "cards_release"})
public final class ImageLoader {
    private final String tag;
    private final ExecutorService executorService = Executors.newFixedThreadPool(5);

    public final void loadImage(@NotNull Context context, @NotNull String imageUrl, @NotNull ImageView imageView, @NotNull ViewDimension viewDimension, @NotNull String cardId, @NotNull Function3<? super ImageView, ? super Bitmap, ? super ViewDimension, Unit> scaler) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)viewDimension, (String)"viewDimension");
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter(scaler, (String)"scaler");
        this.executorService.execute(new AsyncImageLoader(context, imageUrl, imageView, viewDimension, cardId, scaler));
    }

    public ImageLoader() {
        this.tag = "Cards_2.1.00_ImageLoader";
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001Bz\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012K\u0010\u000b\u001aG\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0006\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RS\u0010\u000b\u001aG\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0006\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/moengage/cards/internal/repository/ImageLoader$AsyncImageLoader;", "Ljava/lang/Runnable;", "context", "Landroid/content/Context;", "imageUrl", "", "imageView", "Landroid/widget/ImageView;", "viewDimension", "Lcom/moengage/core/internal/model/ViewDimension;", "cardId", "scaler", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Landroid/graphics/Bitmap;", "bitmap", "", "(Lcom/moengage/cards/internal/repository/ImageLoader;Landroid/content/Context;Ljava/lang/String;Landroid/widget/ImageView;Lcom/moengage/core/internal/model/ViewDimension;Ljava/lang/String;Lkotlin/jvm/functions/Function3;)V", "tag", "run", "cards_release"})
    public final class AsyncImageLoader
    implements Runnable {
        private final String tag;
        private final Context context;
        private final String imageUrl;
        private final ImageView imageView;
        private final ViewDimension viewDimension;
        private final String cardId;
        private final Function3<ImageView, Bitmap, ViewDimension, Unit> scaler;

        @Override
        public void run() {
            try {
                ImageCache imageCache = ImageCache.Companion.getInstance(this.context);
                Bitmap bitmap = imageCache.getImageFromInMemoryCache(this.imageUrl);
                if (bitmap != null) {
                    this.scaler.invoke((Object)this.imageView, (Object)bitmap, (Object)this.viewDimension);
                }
                if ((bitmap = imageCache.getImageFromFileCache(this.cardId, this.imageUrl)) != null) {
                    this.scaler.invoke((Object)this.imageView, (Object)bitmap, (Object)this.viewDimension);
                }
                if ((bitmap = MoEUtils.downloadImageBitmap((String)this.imageUrl)) == null) {
                    return;
                }
                imageCache.cacheImage(this.imageUrl, bitmap, this.cardId);
                this.scaler.invoke((Object)this.imageView, (Object)bitmap, (Object)this.viewDimension);
            }
            catch (Exception e) {
                Logger.e((String)(this.tag + " run() : "), (Throwable)e);
            }
        }

        public AsyncImageLoader(@NotNull Context context, @NotNull String imageUrl, @NotNull ImageView imageView, @NotNull ViewDimension viewDimension, @NotNull String cardId, Function3<? super ImageView, ? super Bitmap, ? super ViewDimension, Unit> scaler) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
            Intrinsics.checkNotNullParameter((Object)viewDimension, (String)"viewDimension");
            Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
            Intrinsics.checkNotNullParameter(scaler, (String)"scaler");
            this.context = context;
            this.imageUrl = imageUrl;
            this.imageView = imageView;
            this.viewDimension = viewDimension;
            this.cardId = cardId;
            this.scaler = scaler;
            this.tag = "Cards_2.1.00_AsyncImageLoader";
        }
    }
}

