/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal.repository;

import com.moengage.cards.internal.repository.TemplateParser$WhenMappings;
import com.moengage.cards.model.Container;
import com.moengage.cards.model.Template;
import com.moengage.cards.model.Widget;
import com.moengage.cards.model.action.Action;
import com.moengage.cards.model.action.NavigationAction;
import com.moengage.cards.model.enums.ActionType;
import com.moengage.cards.model.enums.NavigationType;
import com.moengage.cards.model.enums.TemplateType;
import com.moengage.cards.model.enums.WidgetType;
import com.moengage.cards.model.styles.ButtonStyle;
import com.moengage.cards.model.styles.ContainerStyle;
import com.moengage.cards.model.styles.ImageStyle;
import com.moengage.cards.model.styles.TextStyle;
import com.moengage.cards.model.styles.WidgetStyle;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.utils.MoEUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\u0006\u0010\u001e\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/moengage/cards/internal/repository/TemplateParser;", "", "templateJson", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "tag", "", "actionFromJson", "Lcom/moengage/cards/model/action/Action;", "actionJson", "actionListFromJson", "", "Lorg/json/JSONArray;", "containerFromJson", "Lcom/moengage/cards/model/Container;", "containerJson", "getContainerList", "parse", "Lcom/moengage/cards/model/Template;", "styleFromJson", "Lcom/moengage/cards/model/styles/ContainerStyle;", "styleJson", "widgetFromJson", "Lcom/moengage/cards/model/Widget;", "widgetJson", "widgetStyleFromJson", "Lcom/moengage/cards/model/styles/WidgetStyle;", "widgetType", "Lcom/moengage/cards/model/enums/WidgetType;", "widgetsListFromJson", "widgetsArray", "cards_release"})
public final class TemplateParser {
    private final String tag;
    private final JSONObject templateJson;

    @Nullable
    public final Template parse() {
        try {
            String string2 = this.templateJson.getString("type");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"templateJson.getString(TYPE)");
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
            TemplateType templateType = TemplateType.valueOf(string5);
            JSONArray jSONArray = this.templateJson.getJSONArray("containers");
            Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"templateJson.getJSONArray(CONTAINERS)");
            List<Container> list = this.getContainerList(jSONArray);
            Map map = MoEUtils.jsonToMap((JSONObject)this.templateJson.optJSONObject("kvPairs"));
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"MoEUtils.jsonToMap(templ\u2026n.optJSONObject(KV_PAIR))");
            return new Template(templateType, list, MapsKt.toMap((Map)map));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " parse() : "), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Container> getContainerList(JSONArray containerJson) {
        int n = 0;
        List containerList = new ArrayList();
        n = 0;
        int n2 = containerJson.length();
        while (n < n2) {
            void i;
            JSONObject jSONObject = containerJson.getJSONObject((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"containerJson.getJSONObject(i)");
            containerList.add(this.containerFromJson(jSONObject));
            ++i;
        }
        return containerList;
    }

    private final Container containerFromJson(JSONObject containerJson) {
        long l = containerJson.getLong("id");
        String string2 = containerJson.getString("type");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"containerJson.getString(TYPE)");
        ContainerStyle containerStyle = this.styleFromJson(containerJson.optJSONObject("style"));
        JSONArray jSONArray = containerJson.getJSONArray("widgets");
        Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"containerJson.getJSONArray(WIDGETS)");
        return new Container(l, string2, containerStyle, this.widgetsListFromJson(jSONArray), this.actionListFromJson(containerJson.optJSONArray("actions")));
    }

    private final ContainerStyle styleFromJson(JSONObject styleJson) {
        if (styleJson == null) {
            return null;
        }
        String string2 = styleJson.optString("bgColor", "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"styleJson.optString(\n   \u2026         \"\"\n            )");
        return new ContainerStyle(string2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Widget> widgetsListFromJson(JSONArray widgetsArray) {
        int n = 0;
        List widgetList = new ArrayList();
        n = 0;
        int n2 = widgetsArray.length();
        while (n < n2) {
            void i;
            JSONObject jSONObject = widgetsArray.getJSONObject((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"widgetsArray.getJSONObject(i)");
            widgetList.add(this.widgetFromJson(jSONObject));
            ++i;
        }
        return widgetList;
    }

    private final Widget widgetFromJson(JSONObject widgetJson) {
        String string2 = widgetJson.getString("type");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"widgetJson.getString(TYPE)");
        String string3 = string2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
        WidgetType widgetType = WidgetType.valueOf(string5);
        int n = widgetJson.getInt("id");
        String string6 = widgetJson.getString("content");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"widgetJson.getString(CONTENT)");
        return new Widget(n, widgetType, string6, this.widgetStyleFromJson(widgetJson.optJSONObject("style"), widgetType), this.actionListFromJson(widgetJson.optJSONArray("actions")));
    }

    private final WidgetStyle widgetStyleFromJson(JSONObject styleJson, WidgetType widgetType) {
        if (styleJson == null) {
            return null;
        }
        switch (TemplateParser$WhenMappings.$EnumSwitchMapping$0[widgetType.ordinal()]) {
            case 1: {
                String string2 = styleJson.optString("bgColor", "");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"styleJson.optString(BACKGROUND_COLOR, \"\")");
                return new ButtonStyle(string2, styleJson.optInt("fontSize", -1));
            }
            case 2: {
                String string3 = styleJson.optString("bgColor", "");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"styleJson.optString(BACKGROUND_COLOR, \"\")");
                return new ImageStyle(string3);
            }
            case 3: {
                String string4 = styleJson.optString("bgColor", "");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"styleJson.optString(BACKGROUND_COLOR, \"\")");
                return new TextStyle(string4, styleJson.optInt("fontSize", -1));
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Action> actionListFromJson(JSONArray actionJson) {
        if (actionJson == null) {
            return CollectionsKt.emptyList();
        }
        int n = 0;
        List actionList = new ArrayList();
        n = 0;
        int n2 = actionJson.length();
        while (n < n2) {
            void i;
            JSONObject jSONObject = actionJson.getJSONObject((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"actionJson.getJSONObject(i)");
            Action action = this.actionFromJson(jSONObject);
            if (action != null) {
                actionList.add(action);
            }
            ++i;
        }
        return actionList;
    }

    /*
     * WARNING - void declaration
     */
    private final Action actionFromJson(JSONObject actionJson) {
        try {
            String string2 = actionJson.getString("name");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"actionJson.getString(NAME)");
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
            ActionType actionType = ActionType.valueOf(string5);
            switch (TemplateParser$WhenMappings.$EnumSwitchMapping$1[actionType.ordinal()]) {
                case 1: {
                    void actionType2;
                    String string6 = actionJson.getString("value");
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"actionJson.getString(VALUE)");
                    String string7 = actionJson.getString("type");
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"actionJson.getString(TYPE)");
                    string3 = string7;
                    bl = false;
                    String string8 = string3;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toUpperCase()");
                    NavigationType navigationType = NavigationType.valueOf(string9);
                    Map map = MoEUtils.jsonToMap((JSONObject)actionJson.optJSONObject("kvPairs"));
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"MoEUtils.jsonToMap(actio\u2026n.optJSONObject(KV_PAIR))");
                    return new NavigationAction((ActionType)actionType2, string6, navigationType, MapsKt.toMap((Map)map));
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " actionFromJson() : "), (Throwable)e);
            return null;
        }
    }

    public TemplateParser(@NotNull JSONObject templateJson) {
        Intrinsics.checkNotNullParameter((Object)templateJson, (String)"templateJson");
        this.templateJson = templateJson;
        this.tag = "Cards_2.1.00_TemplateParser";
    }
}

