/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal.repository.local;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import com.moengage.cards.internal.model.CardModel;
import com.moengage.cards.internal.model.SyncInterval;
import com.moengage.cards.internal.repository.ParsingUtilsKt;
import com.moengage.cards.internal.repository.local.LocalRepository;
import com.moengage.cards.internal.repository.local.MarshallingHelper;
import com.moengage.cards.model.CampaignState;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.BaseRequest;
import com.moengage.core.internal.model.database.QueryParams;
import com.moengage.core.internal.model.database.WhereClause;
import com.moengage.core.internal.storage.StorageProvider;
import com.moengage.core.internal.storage.database.DbAdapter;
import com.moengage.core.internal.storage.database.contract.CardsDataContract;
import com.moengage.core.internal.storage.preference.SharedPrefHelper;
import com.moengage.core.internal.utils.MoEUtils;
import com.moengage.core.internal.utils.RestUtils;
import com.moengage.core.model.FeatureStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010%\u001a\u00020\fH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0'H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\u001eH\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020 H\u0016J\b\u0010,\u001a\u00020 H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010%\u001a\u00020\fH\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\f0\u001eH\u0016J\b\u00101\u001a\u000202H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u00104\u001a\u00020 2\u0006\u00105\u001a\u00020\u0011H\u0016J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00172\u0006\u00109\u001a\u00020 H\u0016J\u0016\u0010:\u001a\u00020\u000e2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\f0\u001eH\u0016J\u0010\u0010<\u001a\u00020\u000e2\u0006\u00109\u001a\u00020 H\u0016J\u0010\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u000e2\u0006\u00109\u001a\u00020 H\u0016J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u000207H\u0016J\u0016\u0010C\u001a\u00020\u000e2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\f0\u001eH\u0016J\u0010\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u000202H\u0016J(\u0010F\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u0002072\u0006\u0010J\u001a\u00020 H\u0016J\u0018\u0010K\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010B\u001a\u000207H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/moengage/cards/internal/repository/local/LocalRepositoryImpl;", "Lcom/moengage/cards/internal/repository/local/LocalRepository;", "context", "Landroid/content/Context;", "config", "Lcom/moengage/core/SdkConfig;", "(Landroid/content/Context;Lcom/moengage/core/SdkConfig;)V", "dbAdapter", "Lcom/moengage/core/internal/storage/database/DbAdapter;", "marshallingHelper", "Lcom/moengage/cards/internal/repository/local/MarshallingHelper;", "tag", "", "addOrUpdateCards", "", "newCardList", "", "Lcom/moengage/cards/internal/model/CardModel;", "updateCardList", "clearData", "clearDeletedIds", "clearShownCards", "deleteCard", "", "cardId", "getAllCards", "", "getBaseRequest", "Lcom/moengage/core/internal/model/BaseRequest;", "getCampaignsEligibleForDeletion", "", "currentTime", "", "getCardById", "getCardIds", "getCards", "getCardsForCategory", "category", "getCategories", "Ljava/util/LinkedList;", "getDeletedCardIds", "getFeatureStatus", "Lcom/moengage/core/model/FeatureStatus;", "getLastCardSyncTime", "getLastStatsSyncTime", "getNewCards", "getPinnedCards", "getPinnedCardsForCategory", "getShownCards", "getSyncInterval", "Lcom/moengage/cards/internal/model/SyncInterval;", "getVisibleCards", "insertCard", "cardModel", "isShowAllTabEnabled", "", "removeExpiredCards", "time", "saveDeletedCardId", "cardIds", "saveLastCardSyncTime", "storeCategories", "categories", "Lorg/json/JSONArray;", "storeLastStatsSyncTime", "storeShowAllTabState", "state", "storeShownCards", "storeSyncInterval", "syncInterval", "updateCardState", "campaignState", "Lcom/moengage/cards/model/CampaignState;", "isPinned", "deletionTime", "updateNewCardState", "cards_release"})
public final class LocalRepositoryImpl
implements LocalRepository {
    private final String tag;
    private final DbAdapter dbAdapter;
    private final MarshallingHelper marshallingHelper;
    private final Context context;
    private final SdkConfig config;

    @Override
    public long getLastCardSyncTime() {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        return StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).getLong("card_last_sync_time", 0L);
    }

    @Override
    public void saveLastCardSyncTime(long time) {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).putLong("card_last_sync_time", time);
    }

    @Override
    public void storeCategories(@NotNull JSONArray categories) {
        Intrinsics.checkNotNullParameter((Object)categories, (String)"categories");
        Logger.v((String)(this.tag + " saveCategories() : " + categories));
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        SharedPrefHelper sharedPrefHelper = StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig);
        String string2 = categories.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"categories.toString()");
        sharedPrefHelper.putString("card_categories", string2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LinkedList<String> getCategories() {
        LinkedList<String> categories = new LinkedList<String>();
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        JSONArray categoryArray = new JSONArray(StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).getString("card_categories", "[]"));
        int n = 0;
        int n2 = categoryArray.length();
        while (n < n2) {
            void i;
            categories.add(categoryArray.getString((int)i));
            ++i;
        }
        return categories;
    }

    @Override
    public void storeSyncInterval(@NotNull SyncInterval syncInterval) {
        Intrinsics.checkNotNullParameter((Object)syncInterval, (String)"syncInterval");
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        SharedPrefHelper sharedPrefHelper = StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig);
        String string2 = ParsingUtilsKt.syncIntervalToJson(syncInterval).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"syncIntervalToJson(\n    \u2026\n            ).toString()");
        sharedPrefHelper.putString("card_sync_interval", string2);
    }

    @Override
    @NotNull
    public SyncInterval getSyncInterval() {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        String syncString = StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).getString("card_sync_interval", "");
        if (syncString == null || MoEUtils.isEmptyString((String)syncString)) {
            return ParsingUtilsKt.defaultSyncInterval();
        }
        try {
            SyncInterval syncInterval = ParsingUtilsKt.syncIntervalFromJson(new JSONObject(syncString));
            if (syncInterval == null) {
                syncInterval = ParsingUtilsKt.defaultSyncInterval();
            }
            return syncInterval;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getSyncInterval() : "), (Throwable)e);
            return ParsingUtilsKt.defaultSyncInterval();
        }
    }

    @Override
    public int deleteCard(@NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("is_deleted", Integer.valueOf(1));
            return this.dbAdapter.update("CARDS", contentValues, new WhereClause("card_id = ? ", new String[]{cardId}));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " deleteCardsById() : "), (Throwable)e);
            return -1;
        }
    }

    @Override
    @NotNull
    public BaseRequest getBaseRequest() {
        BaseRequest baseRequest = RestUtils.getBaseRequest((Context)this.context);
        Intrinsics.checkNotNullExpressionValue((Object)baseRequest, (String)"RestUtils.getBaseRequest(context)");
        return baseRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CardModel> getCardsForCategory(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Cursor cursor = null;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)CardsDataContract.CardsEntity.PROJECTION, (String)"CardsEntity.PROJECTION");
            cursor = this.dbAdapter.query("CARDS", new QueryParams(CardsDataContract.CardsEntity.PROJECTION, new WhereClause("category = ? AND visibility_status = \"SHOW\"  AND is_deleted = 0 ", new String[]{category}), null, null, "last_updated_time DESC", 0, 44, null));
            List<CardModel> list = this.marshallingHelper.cardListFromCursor(cursor);
            return list;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getCardsForCategory() : "), (Throwable)e);
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CardModel> getPinnedCardsForCategory(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Cursor cursor = null;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)CardsDataContract.CardsEntity.PROJECTION, (String)"CardsEntity.PROJECTION");
            cursor = this.dbAdapter.query("CARDS", new QueryParams(CardsDataContract.CardsEntity.PROJECTION, new WhereClause("is_pinned = ?  AND category = ?  AND visibility_status = \"SHOW\"  AND is_deleted = 0 ", new String[]{"1", category}), null, null, "last_updated_time DESC", 0, 44, null));
            List<CardModel> list = this.marshallingHelper.cardListFromCursor(cursor);
            return list;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getPinnedCards() : "), (Throwable)e);
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> getCardIds() {
        Cursor cursor = null;
        try {
            cursor = this.dbAdapter.query("CARDS", new QueryParams(new String[]{"card_id"}, new WhereClause("is_deleted = 0 ", null), null, null, null, 0, 60, null));
            List<String> list = this.marshallingHelper.cardIdListFromCursor(cursor);
            return list;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getCardIds() : "), (Throwable)e);
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public int removeExpiredCards(long time) {
        try {
            return this.dbAdapter.delete("CARDS", new WhereClause("deletion_time < ? AND deletion_time > 0", new String[]{String.valueOf(time)}));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " removeExpiredCampaigns() : "), (Throwable)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<String, CardModel> getAllCards() {
        Cursor cursor = null;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)CardsDataContract.CardsEntity.PROJECTION, (String)"CardsEntity.PROJECTION");
            cursor = this.dbAdapter.query("CARDS", new QueryParams(CardsDataContract.CardsEntity.PROJECTION, null, null, null, "last_updated_time DESC", 0, 44, null));
            Map<String, CardModel> map = this.marshallingHelper.cardMapFromCursor(cursor);
            return map;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getAllCards() : "), (Throwable)e);
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return MapsKt.emptyMap();
    }

    @Override
    public void addOrUpdateCards(@NotNull List<CardModel> newCardList, @NotNull List<CardModel> updateCardList) {
        Intrinsics.checkNotNullParameter(newCardList, (String)"newCardList");
        Intrinsics.checkNotNullParameter(updateCardList, (String)"updateCardList");
        try {
            ArrayList<ContentValues> contentValues = new ArrayList<ContentValues>(newCardList.size());
            for (CardModel card : newCardList) {
                contentValues.add(this.marshallingHelper.cardModelToContentValues(card));
            }
            this.dbAdapter.bulkInsert("CARDS", (List)contentValues);
            for (CardModel card : updateCardList) {
                this.dbAdapter.update("CARDS", this.marshallingHelper.cardModelToContentValues(card), new WhereClause("_id = ? ", new String[]{String.valueOf(card.getId())}));
            }
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " addOrUpdateCards() : "), (Throwable)e);
        }
    }

    @Override
    public long insertCard(@NotNull CardModel cardModel) {
        Intrinsics.checkNotNullParameter((Object)cardModel, (String)"cardModel");
        try {
            return this.dbAdapter.insert("CARDS", this.marshallingHelper.cardModelToContentValues(cardModel));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " insertCard() : "), (Throwable)e);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CardModel getCardById(@NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Cursor cursor = null;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)CardsDataContract.CardsEntity.PROJECTION, (String)"CardsEntity.PROJECTION");
            cursor = this.dbAdapter.query("CARDS", new QueryParams(CardsDataContract.CardsEntity.PROJECTION, new WhereClause("card_id = ? ", new String[]{cardId}), null, null, null, 0, 60, null));
            if (cursor == null || !cursor.moveToFirst()) {
                CardModel cardModel = null;
                return cardModel;
            }
            CardModel cardModel = this.marshallingHelper.cardModelFromCursor(cursor);
            cursor.close();
            return cardModel;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getCardById() : "), (Throwable)e);
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return null;
    }

    @Override
    public void clearData() {
        try {
            this.dbAdapter.delete("CARDS", null);
            SdkConfig sdkConfig = SdkConfig.getConfig();
            Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
            SharedPrefHelper sharedPrefHelper = StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig);
            boolean bl = false;
            boolean bl2 = false;
            SharedPrefHelper $this$apply = sharedPrefHelper;
            boolean bl3 = false;
            $this$apply.removeKey("card_last_sync_time");
            $this$apply.removeKey("card_categories");
            $this$apply.removeKey("card_sync_interval");
            $this$apply.removeKey("card_shown_ids");
            $this$apply.removeKey("card_stats_last_sync_time");
            $this$apply.removeKey("card_deleted_ids");
            $this$apply.removeKey("card_show_all_tab");
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " clearData() : "), (Throwable)e);
        }
    }

    @Override
    public void saveDeletedCardId(@NotNull Set<String> cardIds) {
        Intrinsics.checkNotNullParameter(cardIds, (String)"cardIds");
        if (cardIds.isEmpty()) {
            return;
        }
        Set<String> deletedCards = this.getDeletedCardIds();
        Set updatedSet = CollectionsKt.toMutableSet((Iterable)deletedCards);
        updatedSet.addAll((Collection)cardIds);
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).putStringSet("card_deleted_ids", updatedSet);
    }

    @Override
    @NotNull
    public Set<String> getDeletedCardIds() {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        Set set = StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).getStringSet("card_deleted_ids", SetsKt.emptySet());
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Override
    public void clearDeletedIds() {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).removeKey("card_deleted_ids");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CardModel> getVisibleCards() {
        Cursor cursor = null;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)CardsDataContract.CardsEntity.PROJECTION, (String)"CardsEntity.PROJECTION");
            cursor = this.dbAdapter.query("CARDS", new QueryParams(CardsDataContract.CardsEntity.PROJECTION, new WhereClause("visibility_status = \"SHOW\"  AND is_deleted = 0 ", null), null, null, "last_updated_time DESC", 0, 44, null));
            List<CardModel> list = this.marshallingHelper.cardListFromCursor(cursor);
            return list;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getVisibleCards() : "), (Throwable)e);
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public int updateCardState(@NotNull String cardId, @NotNull CampaignState campaignState, boolean isPinned, long deletionTime) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)campaignState, (String)"campaignState");
        try {
            ContentValues contentValues = this.marshallingHelper.campaignStateToContentValues(campaignState);
            contentValues.put("is_pinned", Integer.valueOf(isPinned ? 1 : 0));
            if (deletionTime != -1L) {
                contentValues.put("deletion_time", Long.valueOf(deletionTime));
            }
            return this.dbAdapter.update("CARDS", contentValues, new WhereClause("card_id = ? ", new String[]{cardId}));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " updateCardState() : "), (Throwable)e);
            return -1;
        }
    }

    @Override
    public void storeLastStatsSyncTime(long time) {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).putLong("card_stats_last_sync_time", time);
    }

    @Override
    public long getLastStatsSyncTime() {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        return StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).getLong("card_stats_last_sync_time", 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CardModel> getNewCards() {
        Cursor cursor = null;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)CardsDataContract.CardsEntity.PROJECTION, (String)"CardsEntity.PROJECTION");
            cursor = this.dbAdapter.query("CARDS", new QueryParams(CardsDataContract.CardsEntity.PROJECTION, new WhereClause("visibility_status = \"SHOW\"  AND is_deleted = 0  AND is_new_card = ? ", new String[]{"1"}), null, null, null, 0, 60, null));
            List<CardModel> list = this.marshallingHelper.cardListFromCursor(cursor);
            return list;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getNewCards() : "), (Throwable)e);
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void storeShowAllTabState(boolean state) {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).putBoolean("card_show_all_tab", state);
    }

    @Override
    public boolean isShowAllTabEnabled() {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        return StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).getBoolean("card_show_all_tab", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CardModel> getCards() {
        Cursor cursor = null;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)CardsDataContract.CardsEntity.PROJECTION, (String)"CardsEntity.PROJECTION");
            cursor = this.dbAdapter.query("CARDS", new QueryParams(CardsDataContract.CardsEntity.PROJECTION, new WhereClause("visibility_status = \"SHOW\"  AND is_deleted = 0 ", null), null, null, "last_updated_time DESC", 0, 44, null));
            List<CardModel> list = this.marshallingHelper.cardListFromCursor(cursor);
            return list;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getCards() : "), (Throwable)e);
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CardModel> getPinnedCards() {
        Cursor cursor = null;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)CardsDataContract.CardsEntity.PROJECTION, (String)"CardsEntity.PROJECTION");
            cursor = this.dbAdapter.query("CARDS", new QueryParams(CardsDataContract.CardsEntity.PROJECTION, new WhereClause("is_pinned = ?  AND visibility_status = \"SHOW\"  AND is_deleted = 0 ", new String[]{"1"}), null, null, "last_updated_time DESC", 0, 44, null));
            List<CardModel> list = this.marshallingHelper.cardListFromCursor(cursor);
            return list;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getPinnedCards() : "), (Throwable)e);
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void storeShownCards(@NotNull Set<String> cardIds) {
        Intrinsics.checkNotNullParameter(cardIds, (String)"cardIds");
        Set<String> savedIds = this.getShownCards();
        Set updatedSet = CollectionsKt.toMutableSet((Iterable)savedIds);
        updatedSet.addAll((Collection)cardIds);
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).putStringSet("card_shown_ids", updatedSet);
    }

    @Override
    @NotNull
    public Set<String> getShownCards() {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        Set set = StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).getStringSet("card_shown_ids", (Set)new HashSet());
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Override
    public void clearShownCards() {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sdkConfig, (String)"SdkConfig.getConfig()");
        StorageProvider.INSTANCE.getSharedPreference(this.context, sdkConfig).removeKey("card_shown_ids");
    }

    @Override
    public int updateNewCardState(@NotNull String cardId, boolean state) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("is_new_card", Integer.valueOf(state ? 1 : 0));
            return this.dbAdapter.update("CARDS", contentValues, new WhereClause("card_id = ? ", new String[]{cardId}));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " updateNewCardState() : "), (Throwable)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<String> getCampaignsEligibleForDeletion(long currentTime) {
        Cursor cursor = null;
        try {
            cursor = this.dbAdapter.query("CARDS", new QueryParams(new String[]{"card_id"}, new WhereClause("is_deleted = 0  AND deletion_time < ? AND deletion_time > 0", new String[]{String.valueOf(currentTime)}), null, null, null, 0, 60, null));
            Set set = CollectionsKt.toSet((Iterable)this.marshallingHelper.cardIdListFromCursor(cursor));
            return set;
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " getCampaignsEligibleForDeletion() : "), (Throwable)e);
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public FeatureStatus getFeatureStatus() {
        return StorageProvider.INSTANCE.getRepository(this.context, this.config).getFeatureStatus();
    }

    public LocalRepositoryImpl(@NotNull Context context, @NotNull SdkConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        this.tag = "LocalRepositoryImpl";
        this.dbAdapter = StorageProvider.INSTANCE.getDbAdapter(this.context);
        this.marshallingHelper = new MarshallingHelper();
    }
}

