/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal.repository.local;

import android.content.ContentValues;
import android.database.Cursor;
import com.moengage.cards.internal.model.CardModel;
import com.moengage.cards.internal.repository.ParsingUtilsKt;
import com.moengage.cards.model.CampaignState;
import com.moengage.cards.model.enums.VisibilityStatus;
import com.moengage.core.internal.logger.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/moengage/cards/internal/repository/local/MarshallingHelper;", "", "()V", "tag", "", "campaignStateToContentValues", "Landroid/content/ContentValues;", "campaignState", "Lcom/moengage/cards/model/CampaignState;", "cardIdListFromCursor", "", "cursor", "Landroid/database/Cursor;", "cardListFromCursor", "Lcom/moengage/cards/internal/model/CardModel;", "cardMapFromCursor", "", "cardModelFromCursor", "cardModelToContentValues", "cardModel", "cards_release"})
public final class MarshallingHelper {
    private final String tag;

    @NotNull
    public final List<CardModel> cardListFromCursor(@Nullable Cursor cursor) {
        boolean bl = false;
        List cardList = new ArrayList();
        if (cursor == null || !cursor.moveToFirst()) {
            return cardList;
        }
        do {
            CardModel cardModel;
            if ((cardModel = this.cardModelFromCursor(cursor)) == null) continue;
            cardList.add(cardModel);
        } while (cursor.moveToNext());
        return cardList;
    }

    @NotNull
    public final List<String> cardIdListFromCursor(@Nullable Cursor cursor) {
        boolean bl = false;
        List idList = new ArrayList();
        if (cursor == null || !cursor.moveToFirst()) {
            return idList;
        }
        do {
            String string2 = cursor.getString(0);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cursor.getString(0)");
            idList.add(string2);
        } while (cursor.moveToNext());
        return idList;
    }

    @NotNull
    public final ContentValues cardModelToContentValues(@NotNull CardModel cardModel) {
        ContentValues contentValue;
        Intrinsics.checkNotNullParameter((Object)cardModel, (String)"cardModel");
        ContentValues contentValues = contentValue = new ContentValues();
        boolean bl = false;
        boolean bl2 = false;
        ContentValues $this$apply = contentValues;
        boolean bl3 = false;
        if (cardModel.getId() != -1L) {
            $this$apply.put("_id", Long.valueOf(cardModel.getId()));
        }
        $this$apply.put("card_id", cardModel.getCardId());
        $this$apply.put("category", cardModel.getCategory());
        $this$apply.put("campaign_state", ParsingUtilsKt.campaignStateToJson(cardModel.getCampaignState()).toString());
        $this$apply.put("visibility_status", cardModel.getVisibilityStatus().name());
        $this$apply.put("last_updated_time", Long.valueOf(cardModel.getLastUpdatedTime()));
        $this$apply.put("campaign_payload", cardModel.getCampaignPayload().toString());
        $this$apply.put("is_pinned", Integer.valueOf(cardModel.isPinned() ? 1 : 0));
        $this$apply.put("deletion_time", Long.valueOf(cardModel.getDeletionTime()));
        $this$apply.put("is_new_card", Integer.valueOf(cardModel.isNewCard() ? 1 : 0));
        $this$apply.put("is_deleted", Integer.valueOf(cardModel.isDeleted() ? 1 : 0));
        $this$apply.put("priority", Integer.valueOf(cardModel.getPriority()));
        return contentValue;
    }

    @Nullable
    public final CardModel cardModelFromCursor(@NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        try {
            long l = cursor.getLong(0);
            String string2 = cursor.getString(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cursor.getString(CardsDa\u2026ity.COLUMN_INDEX_CARD_ID)");
            String string3 = cursor.getString(4);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cursor.getString(\n      \u2026TUS\n                    )");
            VisibilityStatus visibilityStatus = VisibilityStatus.valueOf(string3);
            String string4 = cursor.getString(2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"cursor.getString(CardsDa\u2026ty.COLUMN_INDEX_CATEGORY)");
            return new CardModel(l, string2, visibilityStatus, string4, cursor.getLong(5), new JSONObject(cursor.getString(6)), cursor.getInt(7) == 1, ParsingUtilsKt.campaignStateFromJson(new JSONObject(cursor.getString(3))), cursor.getLong(8), cursor.getInt(9) == 1, cursor.getInt(10) == 1, cursor.getInt(11));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " cardModelFromCursor() : "), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public final Map<String, CardModel> cardMapFromCursor(@Nullable Cursor cursor) {
        boolean bl = false;
        Map cardMap = new LinkedHashMap();
        if (cursor == null || !cursor.moveToFirst()) {
            return cardMap;
        }
        do {
            CardModel cardModel;
            if ((cardModel = this.cardModelFromCursor(cursor)) == null) continue;
            cardMap.put(cardModel.getCardId(), cardModel);
        } while (cursor.moveToNext());
        return cardMap;
    }

    @NotNull
    public final ContentValues campaignStateToContentValues(@NotNull CampaignState campaignState) {
        Intrinsics.checkNotNullParameter((Object)campaignState, (String)"campaignState");
        ContentValues contentValues = new ContentValues();
        contentValues.put("campaign_state", ParsingUtilsKt.campaignStateToJson(campaignState).toString());
        return contentValues;
    }

    public MarshallingHelper() {
        this.tag = "Cards_2.1.00_MarshallingHelper";
    }
}

