/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal.repository.remote;

import android.net.Uri;
import com.moengage.cards.internal.model.network.DeleteRequest;
import com.moengage.cards.internal.model.network.StatsRequest;
import com.moengage.cards.internal.model.network.SyncRequest;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.rest.RequestBuilder;
import com.moengage.core.internal.rest.Response;
import com.moengage.core.internal.rest.RestClient;
import com.moengage.core.internal.utils.ApiUtility;
import com.moengage.core.internal.utils.JsonBuilder;
import com.moengage.core.internal.utils.RestUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/moengage/cards/internal/repository/remote/ApiManager;", "", "()V", "tag", "", "deleteCards", "Lcom/moengage/core/internal/rest/Response;", "deleteRequest", "Lcom/moengage/cards/internal/model/network/DeleteRequest;", "syncCards", "syncRequest", "Lcom/moengage/cards/internal/model/network/SyncRequest;", "syncStats", "statsRequest", "Lcom/moengage/cards/internal/model/network/StatsRequest;", "cards_release"})
public final class ApiManager {
    private final String tag;

    @Nullable
    public final Response syncCards(@NotNull SyncRequest syncRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)syncRequest), (String)"syncRequest");
        try {
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath("v1/cards/get");
            RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder((Uri)uriBuilder.build(), (RequestBuilder.RequestType)RequestBuilder.RequestType.POST, (String)syncRequest.appId);
            JsonBuilder jsonBody = new JsonBuilder();
            JsonBuilder jsonBuilder = jsonBody.putLong("last_updated_time", syncRequest.getLastSyncTime()).putJsonArray("prev_sync_card_ids", ApiUtility.listToJsonArray(syncRequest.getCardIdList())).putString("request_id", syncRequest.getRequestId());
            JSONArray jSONArray = new JSONArray();
            String string2 = syncRequest.platform;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"syncRequest.platform");
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            jsonBuilder.putJsonArray("platforms", jSONArray.put((Object)string5)).putString("unique_id", syncRequest.uniqueId).putJsonObject("query_params", syncRequest.defaultParams.build());
            requestBuilder.addBody(jsonBody.build());
            RestClient restClient = new RestClient(requestBuilder.build());
            return restClient.executeRequest();
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " syncCards() : "), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final Response deleteCards(@NotNull DeleteRequest deleteRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)deleteRequest), (String)"deleteRequest");
        try {
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath("v1/cards/user/delete");
            RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder((Uri)uriBuilder.build(), (RequestBuilder.RequestType)RequestBuilder.RequestType.POST, (String)deleteRequest.appId);
            JsonBuilder jsonBody = new JsonBuilder().putString("request_id", deleteRequest.getRequestId());
            JsonBuilder cardData = new JsonBuilder();
            cardData.putJsonArray("unique_ids", new JSONArray().put((Object)deleteRequest.uniqueId)).putJsonArray("card_ids", ApiUtility.setToJsonArray(deleteRequest.getCardIds()));
            JSONArray dataArray = new JSONArray();
            dataArray.put((Object)cardData.build());
            jsonBody.putJsonArray("data", dataArray).putJsonObject("query_params", deleteRequest.defaultParams.build());
            requestBuilder.addBody(jsonBody.build());
            RestClient restClient = new RestClient(requestBuilder.build());
            return restClient.executeRequest();
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " deleteCards() : "), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final Response syncStats(@NotNull StatsRequest statsRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)statsRequest), (String)"statsRequest");
        try {
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath("v1/cards/user");
            RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder((Uri)uriBuilder.build(), (RequestBuilder.RequestType)RequestBuilder.RequestType.POST, (String)statsRequest.appId);
            JsonBuilder jsonBody = new JsonBuilder();
            jsonBody.putString("request_id", statsRequest.getRequestId()).putString("unique_id", statsRequest.uniqueId).putJsonObject("query_params", statsRequest.getBaseRequest().defaultParams.build()).putJsonArray("data", statsRequest.getPayloadJson());
            requestBuilder.addBody(jsonBody.build());
            RestClient restClient = new RestClient(requestBuilder.build());
            return restClient.executeRequest();
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " syncStats() : "), (Throwable)e);
            return null;
        }
    }

    public ApiManager() {
        this.tag = "Cards_2.1.00_ApiManager";
    }
}

