/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.internal.repository.remote;

import com.moengage.cards.internal.model.SyncData;
import com.moengage.cards.internal.model.SyncInterval;
import com.moengage.cards.internal.model.network.DeleteResponse;
import com.moengage.cards.internal.model.network.StatsResponse;
import com.moengage.cards.internal.model.network.SyncResponse;
import com.moengage.cards.internal.repository.CardParser;
import com.moengage.cards.internal.repository.ParsingUtilsKt;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.rest.Response;
import com.moengage.core.internal.utils.ApiUtility;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/moengage/cards/internal/repository/remote/ResponseParser;", "", "()V", "tag", "", "parseDeleteResponse", "Lcom/moengage/cards/internal/model/network/DeleteResponse;", "response", "Lcom/moengage/core/internal/rest/Response;", "parseStatsSyncResponse", "Lcom/moengage/cards/internal/model/network/StatsResponse;", "parseSyncResponse", "Lcom/moengage/cards/internal/model/network/SyncResponse;", "cards_release"})
public final class ResponseParser {
    private final String tag;

    @NotNull
    public final SyncResponse parseSyncResponse(@Nullable Response response) {
        try {
            if (response == null || response.responseCode != 200) {
                return new SyncResponse(false, null, 2, null);
            }
            CharSequence charSequence = response.responseBody;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                return new SyncResponse(false, null, 2, null);
            }
            JSONObject responseJson = new JSONObject(response.responseBody);
            JSONObject responseData = responseJson.getJSONObject("data");
            CardParser cardParser = new CardParser();
            JSONArray jSONArray = responseData.getJSONArray("card_categories");
            Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"responseData.getJSONArray(CARD_CATEGORIES)");
            JSONObject jSONObject = responseData.getJSONObject("sync_intervals");
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"responseData.getJSONObject(SYNC_INTERVAL)");
            SyncInterval syncInterval = ParsingUtilsKt.syncIntervalFromJson(jSONObject);
            Set set = ApiUtility.jsonArrayToStringSet((JSONArray)responseData.getJSONArray("deleted_card_ids"));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ApiUtility.jsonArrayToSt\u2026  )\n                    )");
            JSONArray jSONArray2 = responseData.getJSONArray("cards");
            Intrinsics.checkNotNullExpressionValue((Object)jSONArray2, (String)"responseData.getJSONArra\u2026                  (CARDS)");
            return new SyncResponse(true, new SyncData(jSONArray, syncInterval, set, cardParser.cardDataListFromResponse$cards_release(jSONArray2), responseData.optBoolean("show_all_tab", false)));
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " parseSyncResponse() : "), (Throwable)e);
            return new SyncResponse(false, null, 2, null);
        }
    }

    @NotNull
    public final DeleteResponse parseDeleteResponse(@Nullable Response response) {
        if (response == null) {
            return new DeleteResponse(false);
        }
        if (response.responseCode == 200) {
            return new DeleteResponse(true);
        }
        return new DeleteResponse(false);
    }

    @NotNull
    public final StatsResponse parseStatsSyncResponse(@Nullable Response response) {
        if (response == null) {
            return new StatsResponse(false);
        }
        if (response.responseCode == 200) {
            return new StatsResponse(true);
        }
        return new StatsResponse(false);
    }

    public ResponseParser() {
        this.tag = "Cards_2.1.00_ResponseParser";
    }
}

