/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.listener;

import androidx.annotation.MainThread;
import com.moengage.cards.model.Card;
import com.moengage.cards.model.action.NavigationAction;
import com.moengage.core.internal.logger.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0006H\u0017J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0013H\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/moengage/cards/listener/CardListener;", "", "()V", "tag", "", "onCardAvailable", "", "cardList", "", "Lcom/moengage/cards/model/Card;", "category", "onCardClick", "", "card", "navigationAction", "Lcom/moengage/cards/model/action/NavigationAction;", "onCardDelete", "onNewCardCountAvailable", "newCount", "", "onSyncComplete", "onUnClickedCountAvailable", "unClickedCount", "cards_release"})
public class CardListener {
    private final String tag;

    @MainThread
    public void onUnClickedCountAvailable(long unClickedCount) {
        Logger.v((String)(this.tag + " onUnReadCardCountAvailable() : unread count: " + unClickedCount));
    }

    @MainThread
    public void onNewCardCountAvailable(long newCount) {
        Logger.v((String)(this.tag + " onNewCardCountAvailable() : new card count: " + newCount));
    }

    @MainThread
    public boolean onCardClick(@NotNull Card card, @NotNull NavigationAction navigationAction) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Intrinsics.checkNotNullParameter((Object)navigationAction, (String)"navigationAction");
        Logger.v((String)(this.tag + " onCardClick() : Card clicked: Template - " + card + " Navigation Action -" + ' ' + navigationAction));
        return false;
    }

    @MainThread
    public void onSyncComplete() {
        Logger.v((String)(this.tag + " onSyncComplete() : Card Sync Complete."));
    }

    public void onCardAvailable(@NotNull List<Card> cardList, @NotNull String category) {
        Intrinsics.checkNotNullParameter(cardList, (String)"cardList");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Logger.v((String)(this.tag + " onAllCardsAvailable() : All cards available: " + cardList));
    }

    public void onCardDelete(@NotNull Card card) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Logger.v((String)(this.tag + " onCardDelete() : Card deleted: " + card));
    }

    public CardListener() {
        this.tag = "Cards_2.1.00_CardListener";
    }
}

