/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.moengage.cards.MoECardHelper;
import com.moengage.cards.R;
import com.moengage.cards.internal.CardController;
import com.moengage.cards.internal.Injection;
import com.moengage.cards.internal.listener.CategoryCallback;
import com.moengage.cards.internal.listener.SyncCompleteListener;
import com.moengage.cards.internal.model.SyncType;
import com.moengage.cards.model.Card;
import com.moengage.cards.ui.CategoryFragment;
import com.moengage.cards.ui.CategoryViewModel;
import com.moengage.cards.ui.adapter.CardListAdapter;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.logger.Logger;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u0000 >2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0012\u0010%\u001a\u00020\u001b2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J&\u0010(\u001a\u0004\u0018\u00010\u001d2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010-\u001a\u00020\u001bH\u0016J\b\u0010.\u001a\u00020\u001bH\u0016J\b\u0010/\u001a\u00020\u001bH\u0016J\b\u00100\u001a\u00020\u001bH\u0016J\u0010\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\nH\u0016J\b\u00103\u001a\u00020\u001bH\u0016J\b\u00104\u001a\u00020\u001bH\u0016J\b\u00105\u001a\u00020\u001bH\u0016J&\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\n2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\b0;H\u0016J\b\u0010<\u001a\u00020\u001bH\u0002J\u0016\u0010=\u001a\u00020\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/moengage/cards/ui/CategoryFragment;", "Landroidx/fragment/app/Fragment;", "Lcom/moengage/cards/internal/listener/CategoryCallback;", "Lcom/moengage/cards/internal/listener/SyncCompleteListener;", "()V", "adapter", "Lcom/moengage/cards/ui/adapter/CardListAdapter;", "categoryName", "", "isActivityInForeground", "", "logTag", "getLogTag", "()Ljava/lang/String;", "newUpdates", "Landroid/widget/Button;", "noCardAvailableImage", "Landroid/widget/ImageView;", "noCardsLayout", "Landroid/widget/LinearLayout;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "swipeRefreshLayout", "Landroidx/swiperefreshlayout/widget/SwipeRefreshLayout;", "viewModel", "Lcom/moengage/cards/ui/CategoryViewModel;", "initViews", "", "view", "Landroid/view/View;", "onAttach", "context", "Landroid/content/Context;", "onCardsAvailable", "cards", "", "Lcom/moengage/cards/model/Card;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroy", "onDestroyView", "onDetach", "onPause", "onRefreshComplete", "newCardsAvailable", "onResume", "onStart", "onStop", "onSyncComplete", "syncType", "Lcom/moengage/cards/internal/model/SyncType;", "hasUpdatedCards", "affectedCategories", "", "showEmptyInbox", "updateUi", "Companion", "cards_release"})
public final class CategoryFragment
extends Fragment
implements CategoryCallback,
SyncCompleteListener {
    private boolean isActivityInForeground;
    private SwipeRefreshLayout swipeRefreshLayout;
    private RecyclerView recyclerView;
    private LinearLayout noCardsLayout;
    private ImageView noCardAvailableImage;
    private Button newUpdates;
    private CardListAdapter adapter;
    private String categoryName = "";
    private CategoryViewModel viewModel;
    private static final String ARG_CATEGORY_NAME = "category_name";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final String getLogTag() {
        return "Cards_2.1.00_CategoryFragment_" + this.categoryName;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Object object = this.getArguments();
        if (object == null || (object = object.getString(ARG_CATEGORY_NAME)) == null) {
            object = "";
        }
        this.categoryName = object;
        Logger.v((String)(this.getLogTag() + " onCreate() : "));
        CharSequence charSequence = this.categoryName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            throw (Throwable)new IllegalStateException("Cannot inflate fragment without category name.");
        }
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        this.viewModel = new CategoryViewModel(Injection.INSTANCE.getRepository(context));
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view;
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        Logger.v((String)(this.getLogTag() + " onCreateView() : "));
        View view2 = view = inflater.inflate(R.layout.moe_fragment_category, container, false);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
        this.initViews(view2);
        return view;
    }

    private final void initViews(View view) {
        View view2 = view.findViewById(R.id.swipeRefresh);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.findViewById<SwipeR\u2026ayout>(R.id.swipeRefresh)");
        SwipeRefreshLayout swipeRefreshLayout = this.swipeRefreshLayout = (SwipeRefreshLayout)view2;
        if (swipeRefreshLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"swipeRefreshLayout");
        }
        swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(this){
            final /* synthetic */ CategoryFragment this$0;

            public final void onRefresh() {
                Logger.v((String)(CategoryFragment.access$getLogTag$p(this.this$0) + " initViews() : Refresh Requested."));
                CategoryFragment.access$getViewModel$p(this.this$0).refreshCardsIfRequired();
            }
            {
                this.this$0 = categoryFragment;
            }
        });
        SwipeRefreshLayout swipeRefreshLayout2 = this.swipeRefreshLayout;
        if (swipeRefreshLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"swipeRefreshLayout");
        }
        swipeRefreshLayout2.setEnabled(SdkConfig.getConfig().cardConfig.isSwipeRefreshEnabled);
        View view3 = view.findViewById(R.id.recyclerView);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view.findViewById(R.id.recyclerView)");
        this.recyclerView = (RecyclerView)view3;
        View view4 = view.findViewById(R.id.noCards);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"view.findViewById(R.id.noCards)");
        this.noCardsLayout = (LinearLayout)view4;
        View view5 = view.findViewById(R.id.noCardAvailableImage);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"view.findViewById(R.id.noCardAvailableImage)");
        this.noCardAvailableImage = (ImageView)view5;
        View view6 = view.findViewById(R.id.newUpdates);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"view.findViewById(R.id.newUpdates)");
        this.newUpdates = (Button)view6;
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        MoECardHelper moECardHelper = MoECardHelper.Companion.getInstance();
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        this.adapter = new CardListAdapter(context, moECardHelper.getCardAdapter((Activity)fragmentActivity));
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
        }
        CardListAdapter cardListAdapter = this.adapter;
        if (cardListAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        recyclerView.setAdapter((RecyclerView.Adapter)cardListAdapter);
    }

    public void onAttach(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.onAttach(context);
        Logger.v((String)(this.getLogTag() + " onAttach() : "));
    }

    public void onStart() {
        super.onStart();
        Logger.v((String)(this.getLogTag() + " onStart() : "));
        this.isActivityInForeground = true;
        CategoryViewModel categoryViewModel = this.viewModel;
        if (categoryViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        CategoryFragment categoryFragment = this;
        if (categoryFragment == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.moengage.cards.internal.listener.CategoryCallback");
        }
        categoryViewModel.registerCallback(categoryFragment);
        CardController.Companion.getInstance().registerSyncCompleteListener(this);
        CategoryViewModel categoryViewModel2 = this.viewModel;
        if (categoryViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        categoryViewModel2.cardsForCategory(this.categoryName);
    }

    public void onResume() {
        super.onResume();
        Logger.v((String)(this.getLogTag() + " onResume() : "));
    }

    public void onPause() {
        super.onPause();
        Logger.v((String)(this.getLogTag() + " onPause() : "));
    }

    public void onStop() {
        super.onStop();
        Logger.v((String)(this.getLogTag() + " onStop() : "));
        this.isActivityInForeground = false;
        CategoryViewModel categoryViewModel = this.viewModel;
        if (categoryViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        categoryViewModel.unregisterCallback();
        CardController.Companion.getInstance().unregisterSyncCompleteListener(this);
    }

    public void onDetach() {
        super.onDetach();
        Logger.v((String)(this.getLogTag() + " onDetach() : "));
    }

    public void onDestroyView() {
        super.onDestroyView();
        Logger.v((String)(this.getLogTag() + " onDestroyView() : "));
    }

    public void onDestroy() {
        super.onDestroy();
        Logger.v((String)(this.getLogTag() + " onDestroy() : "));
    }

    @Override
    public void onCardsAvailable(@NotNull List<Card> cards) {
        Intrinsics.checkNotNullParameter(cards, (String)"cards");
        try {
            CardController.Companion.getInstance().getMainThread().post(new Runnable(this, cards){
                final /* synthetic */ CategoryFragment this$0;
                final /* synthetic */ List $cards;

                public final void run() {
                    CategoryFragment.access$updateUi(this.this$0, this.$cards);
                }
                {
                    this.this$0 = categoryFragment;
                    this.$cards = list;
                }
            });
        }
        catch (Exception e) {
            Logger.e((String)(this.getLogTag() + " onCardsAvailable() : "), (Throwable)e);
        }
    }

    private final void updateUi(List<Card> cards) {
        try {
            Logger.v((String)(this.getLogTag() + " updateUi() : Cards available."));
            if (!this.isActivityInForeground) {
                return;
            }
            if (cards.isEmpty()) {
                Logger.v((String)(this.getLogTag() + " updateUi() : No cards available. Will show empty indicator."));
                this.showEmptyInbox();
                return;
            }
            LinearLayout linearLayout = this.noCardsLayout;
            if (linearLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"noCardsLayout");
            }
            linearLayout.setVisibility(8);
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            }
            recyclerView.setVisibility(0);
            CardListAdapter cardListAdapter = this.adapter;
            if (cardListAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            }
            cardListAdapter.setCardList(CollectionsKt.toMutableList((Collection)cards));
        }
        catch (Exception e) {
            Logger.v((String)(this.getLogTag() + " updateUi() : "), (Throwable)e);
        }
    }

    @Override
    public void onRefreshComplete(boolean newCardsAvailable) {
        Logger.v((String)(this.getLogTag() + " onSyncComplete() : Sync complete"));
        if (!this.isActivityInForeground) {
            return;
        }
        CardController.Companion.getInstance().getMainThread().post(new Runnable(this, newCardsAvailable){
            final /* synthetic */ CategoryFragment this$0;
            final /* synthetic */ boolean $newCardsAvailable;

            public final void run() {
                CategoryFragment.access$getSwipeRefreshLayout$p(this.this$0).setRefreshing(false);
                if (this.$newCardsAvailable) {
                    CategoryFragment.access$getViewModel$p(this.this$0).cardsForCategory(CategoryFragment.access$getCategoryName$p(this.this$0));
                    MoECardHelper moECardHelper = MoECardHelper.Companion.getInstance();
                    Context context = this.this$0.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                    moECardHelper.trackCardDelivered(context);
                } else {
                    Toast.makeText((Context)this.this$0.requireContext(), (int)R.string.moe_card_no_new_updates, (int)1).show();
                }
            }
            {
                this.this$0 = categoryFragment;
                this.$newCardsAvailable = bl;
            }
        });
    }

    private final void showEmptyInbox() {
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
        }
        recyclerView.setVisibility(8);
        if (SdkConfig.getConfig().cardConfig.inboxEmptyImage > 0) {
            ImageView imageView = this.noCardAvailableImage;
            if (imageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"noCardAvailableImage");
            }
            imageView.setImageResource(SdkConfig.getConfig().cardConfig.inboxEmptyImage);
        }
        LinearLayout linearLayout = this.noCardsLayout;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"noCardsLayout");
        }
        linearLayout.setVisibility(0);
    }

    @Override
    public void onSyncComplete(@NotNull SyncType syncType, boolean hasUpdatedCards, @NotNull Set<String> affectedCategories) {
        Intrinsics.checkNotNullParameter((Object)((Object)syncType), (String)"syncType");
        Intrinsics.checkNotNullParameter(affectedCategories, (String)"affectedCategories");
        try {
            Logger.v((String)(this.getLogTag() + " onSyncComplete() : Sync Type: " + (Object)((Object)syncType) + " Has new Cards: " + hasUpdatedCards + ", Categories: " + affectedCategories));
            if (syncType != SyncType.INBOX_OPEN) {
                return;
            }
            if (!this.isActivityInForeground) {
                return;
            }
            MoECardHelper moECardHelper = MoECardHelper.Companion.getInstance();
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            moECardHelper.trackCardDelivered(context);
            if (hasUpdatedCards) {
                CardController.Companion.getInstance().getMainThread().post(new Runnable(this){
                    final /* synthetic */ CategoryFragment this$0;

                    public final void run() {
                        CategoryFragment.access$getNewUpdates$p(this.this$0).setVisibility(0);
                        CategoryFragment.access$getNewUpdates$p(this.this$0).setOnClickListener(new View.OnClickListener(this){
                            final /* synthetic */ onSyncComplete.1 this$0;

                            public final void onClick(View it) {
                                CategoryFragment.access$getViewModel$p(this.this$0.this$0).cardsForCategory(CategoryFragment.access$getCategoryName$p(this.this$0.this$0));
                                CategoryFragment.access$getNewUpdates$p(this.this$0.this$0).setVisibility(8);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = categoryFragment;
                    }
                });
            }
        }
        catch (Exception e) {
            Logger.e((String)(this.getLogTag() + " onSyncComplete() : "), (Throwable)e);
        }
    }

    public static final /* synthetic */ String access$getLogTag$p(CategoryFragment $this) {
        return $this.getLogTag();
    }

    public static final /* synthetic */ CategoryViewModel access$getViewModel$p(CategoryFragment $this) {
        CategoryViewModel categoryViewModel = $this.viewModel;
        if (categoryViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        return categoryViewModel;
    }

    public static final /* synthetic */ void access$setViewModel$p(CategoryFragment $this, CategoryViewModel categoryViewModel) {
        $this.viewModel = categoryViewModel;
    }

    public static final /* synthetic */ void access$updateUi(CategoryFragment $this, List cards) {
        $this.updateUi(cards);
    }

    public static final /* synthetic */ SwipeRefreshLayout access$getSwipeRefreshLayout$p(CategoryFragment $this) {
        SwipeRefreshLayout swipeRefreshLayout = $this.swipeRefreshLayout;
        if (swipeRefreshLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"swipeRefreshLayout");
        }
        return swipeRefreshLayout;
    }

    public static final /* synthetic */ void access$setSwipeRefreshLayout$p(CategoryFragment $this, SwipeRefreshLayout swipeRefreshLayout) {
        $this.swipeRefreshLayout = swipeRefreshLayout;
    }

    public static final /* synthetic */ String access$getCategoryName$p(CategoryFragment $this) {
        return $this.categoryName;
    }

    public static final /* synthetic */ void access$setCategoryName$p(CategoryFragment $this, String string) {
        $this.categoryName = string;
    }

    public static final /* synthetic */ Button access$getNewUpdates$p(CategoryFragment $this) {
        Button button = $this.newUpdates;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"newUpdates");
        }
        return button;
    }

    public static final /* synthetic */ void access$setNewUpdates$p(CategoryFragment $this, Button button) {
        $this.newUpdates = button;
    }

    @JvmStatic
    @NotNull
    public static final CategoryFragment newInstance(@NotNull String categoryName) {
        return Companion.newInstance(categoryName);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/moengage/cards/ui/CategoryFragment$Companion;", "", "()V", "ARG_CATEGORY_NAME", "", "newInstance", "Lcom/moengage/cards/ui/CategoryFragment;", "categoryName", "cards_release"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final CategoryFragment newInstance(@NotNull String categoryName) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)categoryName, (String)"categoryName");
            CategoryFragment categoryFragment = new CategoryFragment();
            boolean bl = false;
            boolean bl2 = false;
            CategoryFragment $this$apply2 = categoryFragment;
            boolean bl3 = false;
            Bundle bundle = new Bundle();
            boolean bl4 = false;
            boolean bl5 = false;
            Bundle bundle2 = bundle;
            CategoryFragment categoryFragment2 = $this$apply2;
            boolean bl6 = false;
            $this$apply.putString(CategoryFragment.ARG_CATEGORY_NAME, categoryName);
            Unit unit = Unit.INSTANCE;
            categoryFragment2.setArguments(bundle);
            return categoryFragment;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

