/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.ui;

import com.moengage.cards.internal.listener.CategoryCallback;
import com.moengage.cards.internal.model.CardMeta;
import com.moengage.cards.internal.model.SyncType;
import com.moengage.cards.internal.repository.CardParser;
import com.moengage.cards.internal.repository.CardRepository;
import com.moengage.core.internal.logger.Logger;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/moengage/cards/ui/CategoryViewModel;", "", "cardRepository", "Lcom/moengage/cards/internal/repository/CardRepository;", "(Lcom/moengage/cards/internal/repository/CardRepository;)V", "categoryCallback", "Lcom/moengage/cards/internal/listener/CategoryCallback;", "executors", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "tag", "", "cardsForCategory", "", "category", "refreshCardsIfRequired", "registerCallback", "unregisterCallback", "cards_release"})
public final class CategoryViewModel {
    private final ExecutorService executors;
    private CategoryCallback categoryCallback;
    private final String tag;
    private final CardRepository cardRepository;

    public final void cardsForCategory(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Logger.v((String)(this.tag + " cardsForCategory() : Will fetch card for category. " + category));
        this.executors.submit(new Runnable(this, category){
            final /* synthetic */ CategoryViewModel this$0;
            final /* synthetic */ String $category;

            public final void run() {
                block2: {
                    List<CardMeta> cardMeta = CategoryViewModel.access$getCardRepository$p(this.this$0).cardsByCategory(this.$category);
                    if (cardMeta.isEmpty()) {
                        Logger.v((String)(CategoryViewModel.access$getTag$p(this.this$0) + " cardsForCategory() : No cards found for category."));
                        CategoryCallback categoryCallback = CategoryViewModel.access$getCategoryCallback$p(this.this$0);
                        if (categoryCallback != null) {
                            categoryCallback.onCardsAvailable(CollectionsKt.emptyList());
                        }
                        return;
                    }
                    CategoryCallback categoryCallback = CategoryViewModel.access$getCategoryCallback$p(this.this$0);
                    if (categoryCallback == null) break block2;
                    categoryCallback.onCardsAvailable(new CardParser().cardTemplateFromMeta(cardMeta));
                }
            }
            {
                this.this$0 = categoryViewModel;
                this.$category = string2;
            }
        });
    }

    public final void refreshCardsIfRequired() {
        Logger.v((String)(this.tag + " refreshCardsIfRequired() : Will refresh cards if required."));
        this.executors.submit(new Runnable(this){
            final /* synthetic */ CategoryViewModel this$0;

            public final void run() {
                block0: {
                    CategoryCallback categoryCallback = CategoryViewModel.access$getCategoryCallback$p(this.this$0);
                    if (categoryCallback == null) break block0;
                    categoryCallback.onRefreshComplete(CategoryViewModel.access$getCardRepository$p(this.this$0).syncCards(SyncType.PULL_TO_REFRESH));
                }
            }
            {
                this.this$0 = categoryViewModel;
            }
        });
    }

    public final void registerCallback(@NotNull CategoryCallback categoryCallback) {
        Intrinsics.checkNotNullParameter((Object)categoryCallback, (String)"categoryCallback");
        this.categoryCallback = categoryCallback;
    }

    public final void unregisterCallback() {
        this.categoryCallback = null;
    }

    public CategoryViewModel(@NotNull CardRepository cardRepository) {
        Intrinsics.checkNotNullParameter((Object)cardRepository, (String)"cardRepository");
        this.cardRepository = cardRepository;
        this.executors = Executors.newSingleThreadExecutor();
        this.tag = "Cards_2.1.00_CategoryViewModel";
    }

    public static final /* synthetic */ CardRepository access$getCardRepository$p(CategoryViewModel $this) {
        return $this.cardRepository;
    }

    public static final /* synthetic */ String access$getTag$p(CategoryViewModel $this) {
        return $this.tag;
    }

    public static final /* synthetic */ CategoryCallback access$getCategoryCallback$p(CategoryViewModel $this) {
        return $this.categoryCallback;
    }

    public static final /* synthetic */ void access$setCategoryCallback$p(CategoryViewModel $this, CategoryCallback categoryCallback) {
        $this.categoryCallback = categoryCallback;
    }
}

