/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.ui.adapter;

import android.content.Context;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.moengage.cards.MoECardHelper;
import com.moengage.cards.model.Card;
import com.moengage.cards.ui.adapter.CardAdapter;
import com.moengage.cards.ui.adapter.ViewHolder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0014\u0010\u0018\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/moengage/cards/ui/adapter/CardListAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/moengage/cards/ui/adapter/ViewHolder;", "context", "Landroid/content/Context;", "cardAdapter", "Lcom/moengage/cards/ui/adapter/CardAdapter;", "(Landroid/content/Context;Lcom/moengage/cards/ui/adapter/CardAdapter;)V", "cardList", "", "Lcom/moengage/cards/model/Card;", "deleteItem", "", "position", "", "card", "getItemCount", "getItemViewType", "onBindViewHolder", "viewHolder", "onCreateViewHolder", "viewGroup", "Landroid/view/ViewGroup;", "viewType", "setCardList", "cards_release"})
public final class CardListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<Card> cardList;
    private final Context context;
    private final CardAdapter cardAdapter;

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int viewType) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        return this.cardAdapter.onCreateViewHolder(viewGroup, viewType);
    }

    public int getItemCount() {
        return this.cardList.size();
    }

    public int getItemViewType(int position) {
        Card card = this.cardList.get(position);
        return this.cardAdapter.getItemViewType(position, card);
    }

    public void onBindViewHolder(@NotNull ViewHolder viewHolder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        Card cardTemplate = this.cardList.get(position);
        this.cardAdapter.onBindViewHolder(viewHolder, position, cardTemplate, this);
        MoECardHelper.Companion.getInstance().onCardShown(this.context, cardTemplate);
    }

    public final void deleteItem(int position, @NotNull Card card) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        this.cardList.remove(position);
        this.notifyItemRemoved(position);
        this.notifyItemRangeChanged(position, this.cardList.size());
        MoECardHelper.Companion.getInstance().deleteCard(this.context, card);
    }

    public final void setCardList(@NotNull List<Card> cardList) {
        Intrinsics.checkNotNullParameter(cardList, (String)"cardList");
        this.cardList = cardList;
        this.notifyDataSetChanged();
    }

    public CardListAdapter(@NotNull Context context, @NotNull CardAdapter cardAdapter) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cardAdapter, (String)"cardAdapter");
        this.context = context;
        this.cardAdapter = cardAdapter;
        boolean bl = false;
        this.cardList = new ArrayList();
    }
}

