/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.cards.ui.adapter.sdkdefault;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Keep;
import androidx.core.text.HtmlCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.moengage.cards.R;
import com.moengage.cards.UtilsKt;
import com.moengage.cards.internal.ActionManager;
import com.moengage.cards.internal.CardController;
import com.moengage.cards.internal.ImageUtils;
import com.moengage.cards.internal.repository.ImageLoader;
import com.moengage.cards.model.Card;
import com.moengage.cards.model.Container;
import com.moengage.cards.model.Widget;
import com.moengage.cards.model.enums.WidgetType;
import com.moengage.cards.model.styles.ContainerStyle;
import com.moengage.cards.ui.adapter.CardListAdapter;
import com.moengage.cards.ui.adapter.ViewHolder;
import com.moengage.cards.ui.adapter.sdkdefault.IllustrationViewHolder;
import com.moengage.cards.widgets.MoEUnClickedIndicator;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.ViewDimension;
import com.moengage.core.internal.utils.MoEUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J.\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020$2\u0006\u0010!\u001a\u00020\"H\u0002J\u001e\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020 J \u00105\u001a\u00020$2\u0006\u00106\u001a\u0002072\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J(\u00108\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u00106\u001a\u0002072\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00069"}, d2={"Lcom/moengage/cards/ui/adapter/sdkdefault/IllustrationViewHolder;", "Lcom/moengage/cards/ui/adapter/ViewHolder;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "ctaButton", "Landroid/widget/Button;", "getCtaButton", "()Landroid/widget/Button;", "header", "Landroid/widget/TextView;", "getHeader", "()Landroid/widget/TextView;", "image", "Landroid/widget/ImageView;", "getImage", "()Landroid/widget/ImageView;", "message", "getMessage", "pinIndicator", "getPinIndicator", "tag", "", "time", "getTime", "unClickedIndicator", "Lcom/moengage/cards/widgets/MoEUnClickedIndicator;", "getUnClickedIndicator", "()Lcom/moengage/cards/widgets/MoEUnClickedIndicator;", "getView", "()Landroid/view/View;", "getImageViewDimensions", "Lcom/moengage/core/internal/model/ViewDimension;", "context", "Landroid/content/Context;", "onBind", "", "activity", "Landroid/app/Activity;", "card", "Lcom/moengage/cards/model/Card;", "imageLoader", "Lcom/moengage/cards/internal/repository/ImageLoader;", "position", "", "cardListAdapter", "Lcom/moengage/cards/ui/adapter/CardListAdapter;", "resetDefaultState", "scaleBitmapAndLoadImage", "imageView", "bitmap", "Landroid/graphics/Bitmap;", "viewDimension", "setupCta", "widget", "Lcom/moengage/cards/model/Widget;", "setupImage", "cards_release"})
@Keep
public final class IllustrationViewHolder
extends ViewHolder {
    private final String tag;
    @NotNull
    private final ImageView image;
    @NotNull
    private final TextView header;
    @NotNull
    private final MoEUnClickedIndicator unClickedIndicator;
    @NotNull
    private final TextView message;
    @NotNull
    private final TextView time;
    @NotNull
    private final Button ctaButton;
    @NotNull
    private final ImageView pinIndicator;
    @NotNull
    private final View view;

    @NotNull
    public final ImageView getImage() {
        return this.image;
    }

    @NotNull
    public final TextView getHeader() {
        return this.header;
    }

    @NotNull
    public final MoEUnClickedIndicator getUnClickedIndicator() {
        return this.unClickedIndicator;
    }

    @NotNull
    public final TextView getMessage() {
        return this.message;
    }

    @NotNull
    public final TextView getTime() {
        return this.time;
    }

    @NotNull
    public final Button getCtaButton() {
        return this.ctaButton;
    }

    @NotNull
    public final ImageView getPinIndicator() {
        return this.pinIndicator;
    }

    public final void onBind(@NotNull Activity activity, @NotNull Card card, @NotNull ImageLoader imageLoader, int position, @NotNull CardListAdapter cardListAdapter) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Intrinsics.checkNotNullParameter((Object)imageLoader, (String)"imageLoader");
        Intrinsics.checkNotNullParameter((Object)((Object)cardListAdapter), (String)"cardListAdapter");
        Context context = activity.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
        this.resetDefaultState(context);
        Container container = card.getTemplate().getContainer().get(0);
        for (Widget widget : container.getWidgetList()) {
            Logger.v((String)(this.tag + " onBind() : Widget: " + widget));
            if (widget.getId() == 0 && widget.getWidgetType() == WidgetType.IMAGE) {
                this.setupImage(activity, widget, imageLoader, card);
                continue;
            }
            if (widget.getId() == 1 && widget.getWidgetType() == WidgetType.TEXT) {
                this.header.setText((CharSequence)HtmlCompat.fromHtml((String)widget.getContent(), (int)63));
                continue;
            }
            if (widget.getId() == 2 && widget.getWidgetType() == WidgetType.TEXT) {
                CharSequence charSequence = widget.getContent();
                boolean bl = false;
                if (charSequence.length() == 0) {
                    Logger.v((String)(this.tag + " onBind() : Widget text missing will not show widget."));
                    continue;
                }
                this.message.setText((CharSequence)HtmlCompat.fromHtml((String)widget.getContent(), (int)63));
                this.message.setVisibility(0);
                continue;
            }
            if (widget.getId() != 3 || widget.getWidgetType() != WidgetType.BUTTON) continue;
            this.setupCta(widget, activity, card);
        }
        if (card.getMetaData().isPinned() && position == 0) {
            this.pinIndicator.setVisibility(0);
        }
        if (!card.getMetaData().getCampaignState().isClicked()) {
            this.unClickedIndicator.setVisibility(0);
        }
        this.view.setOnClickListener(new View.OnClickListener(this, activity, container, card){
            final /* synthetic */ IllustrationViewHolder this$0;
            final /* synthetic */ Activity $activity;
            final /* synthetic */ Container $container;
            final /* synthetic */ Card $card;

            public final void onClick(View it) {
                this.this$0.getUnClickedIndicator().setVisibility(8);
                ActionManager.onActionPerformed$default(new ActionManager(), this.$activity, this.$container.getAction(), this.$card, 0, 8, null);
            }
            {
                this.this$0 = illustrationViewHolder;
                this.$activity = activity;
                this.$container = container;
                this.$card = card;
            }
        });
        Object object = container.getStyle();
        if (object != null && (object = ((ContainerStyle)object).getBackgroundColor()) != null) {
            CharSequence charSequence = (CharSequence)object;
            boolean bl = false;
            if (charSequence.length() > 0) {
                this.view.setBackgroundColor(Color.parseColor((String)container.getStyle().getBackgroundColor()));
            }
        }
        this.view.setOnLongClickListener(new View.OnLongClickListener(this, activity, cardListAdapter, position, card){
            final /* synthetic */ IllustrationViewHolder this$0;
            final /* synthetic */ Activity $activity;
            final /* synthetic */ CardListAdapter $cardListAdapter;
            final /* synthetic */ int $position;
            final /* synthetic */ Card $card;

            public final boolean onLongClick(View it) {
                Logger.v((String)(IllustrationViewHolder.access$getTag$p(this.this$0) + " onBind() : Long click callback"));
                AlertDialog.Builder dialog2 = new AlertDialog.Builder((Context)this.$activity).setItems((CharSequence[])new String[]{this.$activity.getApplicationContext().getString(R.string.moe_card_delete_title)}, new DialogInterface.OnClickListener(this){
                    final /* synthetic */ onBind.2 this$0;

                    public final void onClick(@NotNull DialogInterface $noName_0, int $noName_1) {
                        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                        this.this$0.$cardListAdapter.deleteItem(this.this$0.$position, this.this$0.$card);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                dialog2.create().show();
                return true;
            }
            {
                this.this$0 = illustrationViewHolder;
                this.$activity = activity;
                this.$cardListAdapter = cardListAdapter;
                this.$position = n;
                this.$card = card;
            }
        });
        this.time.setText((CharSequence)UtilsKt.getTime(card.getMetaData().getUpdatedTime() * (long)1000));
    }

    private final void setupImage(Activity activity, Widget widget, ImageLoader imageLoader, Card card) {
        ViewDimension imageDimensions = this.getImageViewDimensions((Context)activity);
        this.image.getLayoutParams().height = imageDimensions.height;
        this.image.getLayoutParams().width = imageDimensions.width;
        int placeHolder = SdkConfig.getConfig().cardConfig.cardPlaceHolderImage > -1 ? SdkConfig.getConfig().cardConfig.cardPlaceHolderImage : R.drawable.moe_card_placeholder;
        this.image.setImageResource(placeHolder);
        if (MoEUtils.isGif((String)widget.getContent()) && ImageUtils.hasGifSupport()) {
            Intrinsics.checkNotNullExpressionValue((Object)((RequestBuilder)Glide.with((Activity)activity).asGif().load(widget.getContent()).placeholder(placeHolder)).into(this.image), (String)"Glide.with(activity).asG\u2026(placeHolder).into(image)");
        } else {
            Context context = activity.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
            imageLoader.loadImage(context, widget.getContent(), this.image, imageDimensions, card.getCardId(), (Function3<? super ImageView, ? super Bitmap, ? super ViewDimension, Unit>)((Function3)new Function3<ImageView, Bitmap, ViewDimension, Unit>(this){

                public final void invoke(@NotNull ImageView p1, @NotNull Bitmap p2, @NotNull ViewDimension p3) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                    ((IllustrationViewHolder)((Object)this.receiver)).scaleBitmapAndLoadImage(p1, p2, p3);
                }
            }));
        }
    }

    private final void setupCta(Widget widget, Activity activity, Card card) {
        CharSequence charSequence = widget.getContent();
        boolean bl = false;
        if (charSequence.length() == 0) {
            Logger.v((String)(this.tag + " onBind() : Widget text missing will not show widget."));
            return;
        }
        this.ctaButton.setText((CharSequence)HtmlCompat.fromHtml((String)widget.getContent(), (int)63));
        this.ctaButton.setVisibility(0);
        this.ctaButton.setOnClickListener(new View.OnClickListener(this, activity, widget, card){
            final /* synthetic */ IllustrationViewHolder this$0;
            final /* synthetic */ Activity $activity;
            final /* synthetic */ Widget $widget;
            final /* synthetic */ Card $card;

            public final void onClick(View it) {
                this.this$0.getUnClickedIndicator().setVisibility(8);
                new ActionManager().onActionPerformed(this.$activity, this.$widget.getActionList(), this.$card, this.$widget.getId());
            }
            {
                this.this$0 = illustrationViewHolder;
                this.$activity = activity;
                this.$widget = widget;
                this.$card = card;
            }
        });
    }

    public final void scaleBitmapAndLoadImage(@NotNull ImageView imageView, @NotNull Bitmap bitmap, @NotNull ViewDimension viewDimension) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)viewDimension, (String)"viewDimension");
        try {
            Bitmap bitmap2;
            ViewDimension bitmapDimension = new ViewDimension(bitmap.getWidth(), bitmap.getHeight());
            if (bitmapDimension.height >= bitmapDimension.width) {
                int width = bitmapDimension.width * viewDimension.height / bitmapDimension.height;
                Bitmap bitmap3 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)viewDimension.height, (boolean)true);
                bitmap2 = bitmap3;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"Bitmap.createScaledBitma\u2026ewDimension.height, true)");
            } else {
                int height = bitmapDimension.height * viewDimension.width / bitmapDimension.width;
                Bitmap bitmap4 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)viewDimension.width, (int)height, (boolean)true);
                bitmap2 = bitmap4;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"Bitmap.createScaledBitma\u2026sion.width, height, true)");
            }
            Bitmap scaledBitmap = bitmap2;
            if (scaledBitmap != null) {
                CardController.Companion.getInstance().getMainThread().post(new Runnable(imageView, scaledBitmap, bitmapDimension){
                    final /* synthetic */ ImageView $imageView;
                    final /* synthetic */ Bitmap $scaledBitmap;
                    final /* synthetic */ ViewDimension $bitmapDimension;

                    public final void run() {
                        this.$imageView.setImageBitmap(this.$scaledBitmap);
                        if (this.$bitmapDimension.height >= this.$bitmapDimension.width) {
                            this.$imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        }
                    }
                    {
                        this.$imageView = imageView;
                        this.$scaledBitmap = bitmap;
                        this.$bitmapDimension = viewDimension;
                    }
                });
            }
        }
        catch (Exception e) {
            Logger.e((String)(this.tag + " scaleBitmapAndLoadImage() : "), (Throwable)e);
        }
    }

    private final ViewDimension getImageViewDimensions(Context context) {
        ViewDimension viewDimension;
        ViewDimension deviceDimensions = MoEUtils.getDeviceDimensions((Context)context);
        int availableWidth = deviceDimensions.width - MoEUtils.transformToPx((Context)context, (double)8.0) * 2;
        Logger.v((String)(this.tag + " getImageViewDimensions() : Device Dimension: " + deviceDimensions));
        if (com.moengage.core.internal.utils.UtilsKt.isTablet((Context)context) || com.moengage.core.internal.utils.UtilsKt.isLandscapeMode((Context)context)) {
            Logger.v((String)(this.tag + " getImageViewDimensions() : Device is either in landscape mode or it is" + " a tablet."));
            int width = (int)((double)availableWidth / 2.25);
            ViewDimension imageDimension = new ViewDimension(width, width / 2);
            Logger.v((String)(this.tag + " getImageViewDimensions() : ImageView Dimension: " + imageDimension));
            viewDimension = imageDimension;
        } else {
            Logger.v((String)(this.tag + " getImageViewDimensions() : Device is in portrait mode."));
            ViewDimension imageDimension = new ViewDimension(availableWidth, availableWidth / 2);
            Logger.v((String)(this.tag + " getImageViewDimensions() : ImageView Dimension: " + imageDimension));
            viewDimension = imageDimension;
        }
        return viewDimension;
    }

    private final void resetDefaultState(Context context) {
        this.unClickedIndicator.setVisibility(8);
        this.message.setVisibility(8);
        this.ctaButton.setVisibility(8);
        this.pinIndicator.setVisibility(8);
        this.view.setBackgroundColor(context.getResources().getColor(R.color.moe_card_background_color));
    }

    @NotNull
    public final View getView() {
        return this.view;
    }

    public IllustrationViewHolder(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super(view);
        this.view = view;
        this.tag = "Cards_2.1.00_IllustrationViewHolder";
        View view2 = this.view.findViewById(R.id.imageView);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.findViewById(R.id.imageView)");
        this.image = (ImageView)view2;
        View view3 = this.view.findViewById(R.id.header);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view.findViewById(R.id.header)");
        this.header = (TextView)view3;
        View view4 = this.view.findViewById(R.id.unClickedIndicator);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"view.findViewById(R.id.unClickedIndicator)");
        this.unClickedIndicator = (MoEUnClickedIndicator)view4;
        View view5 = this.view.findViewById(R.id.message);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"view.findViewById(R.id.message)");
        this.message = (TextView)view5;
        View view6 = this.view.findViewById(R.id.time);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"view.findViewById(R.id.time)");
        this.time = (TextView)view6;
        View view7 = this.view.findViewById(R.id.ctaButton);
        Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"view.findViewById(R.id.ctaButton)");
        this.ctaButton = (Button)view7;
        View view8 = this.view.findViewById(R.id.pin);
        Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"view.findViewById(R.id.pin)");
        this.pinIndicator = (ImageView)view8;
    }

    public static final /* synthetic */ String access$getTag$p(IllustrationViewHolder $this) {
        return $this.tag;
    }
}

