/*
 * Copyright (c) 2014-2021 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.internal

import com.moengage.inapp.BuildConfig

/**
 * @author Umang Chamaria
 */

internal const val MODULE_TAG: String = "InApp_" + BuildConfig.MOENGAGE_INAPP_VERSION + "_"

internal const val ERROR_CODE_GLOBAL_CONTROL_GROUP = "E001"

// test in-app error messages
internal const val ERROR_MESSAGE_TEST_CAMPAIGN = """Something went wrong. Could not show in-app.
 Try again or Contact MoEngage Support."""
internal const val ERROR_MESSAGE_INAPP_EXCEEDING_DEVICE_DIMENSION =
    """Created in-app exceeds screen dimensions.
 Cannot show in-app, please check and edit the in-app template on MoEngage Dashboard."""
internal const val ERROR_MESSAGE_UNSUPPORTED_ORIENTATION =
    "Cannot show in-app in the current orientation"
internal const val ERROR_MESSAGE_COULD_NOT_CREATE_VIEW =
    """Something went wrong in creating the in-app view. Cannot show in-app.
    Try again or Contact MoEngage Support."""

internal const val STATISTICS_BATCH_SIZE = 30

internal const val ENRICH_EVENT_ATTRIBUTE_SDK_VERSION = "sdkVersion"
internal const val ENRICH_EVENT_ATTRIBUTE_OS = "os"
internal const val ENRICH_EVENT_ATTRIBUTE_APP_VERSION_CODE = "appVersion"
internal const val ENRICH_EVENT_ATTRIBUTE_APP_VERSION_NAME = "appVersionName"

internal const val EVENT_ATTRIBUTE_FLOW_TWO_STEP_OPT_IN = "two step opt-in"