/*
 * Copyright (c) 2014-2021 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.internal;

import com.moengage.inapp.BuildConfig;

/**
 * @author Umang Chamaria
 */
public interface InAppConstants {

  String INAPP_LIB_VERSION = BuildConfig.MOENGAGE_INAPP_VERSION;

  String MODULE_TAG = "InApp_" + INAPP_LIB_VERSION + "_";

  String IN_APP_CAMPAIGN_STATUS_ACTIVE = "ACTIVE";

  String IN_APP_CAMPAIGN_STATUS_IN_ACTIVE = "IN_ACTIVE";

  String IN_APP_CAMPAIGN_TYPE_GENERAL = "general";

  String IN_APP_CAMPAIGN_TYPE_SMART = "smart";

  String IN_APP_TEMPLATE_TYPE_SELF_HANDLED = "SELF_HANDLED";

  String IN_APP_TEMPLATE_TYPE_POP_UP = "POP_UP";

  String IN_APP_TEMPLATE_TYPE_FULL_SCREEN = "FULL_SCREEN";

  long SIXTY_DAYS_SECONDS = 5184000L;

  String IN_APP_RATING_ATTRIBUTE = "rating";

  String PUSH_ATTR_CAMPAIGN_ID = "cid";

  String PUSH_ATTR_IS_TEST_CAMPAIGN = "isTest";

  String PUSH_ATTR_TRIGGER_DELAY = "timeDelay";

  long DEFAULT_API_SYNC_INTERVAL = 900L;
  long DEFAULT_LAST_SYNC_TIME = 0L;
  long DEFAULT_GLOBAL_DELAY_IN_APP = 900L;

  int CONTAINER_BASE_ID = 20000;
  int HTML_CONTAINER_ID = CONTAINER_BASE_ID + 1;

  int WIDGET_BASE_ID = 30000;

  String IN_APP_TEMPLATE_TYPE_NON_INTRUSIVE = "NON_INTRUSIVE";
}
