/*
 * Copyright (c) 2014-2021 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.internal

import android.content.Context
import com.moengage.core.internal.SdkInstanceManager
import com.moengage.inapp.internal.model.InAppGlobalState
import com.moengage.inapp.internal.model.meta.InAppCampaign
import com.moengage.inapp.internal.repository.PayloadMapper

/**
 *
 * @author Arshiya Khanum
 */
public class InAppInternalHelper {

    public fun inAppGlobalState(context: Context, appId: String): InAppGlobalState {
        val instance =
            SdkInstanceManager.getInstanceForAppId(appId) ?: return InAppGlobalState(0, 0, 0)
        return InAppInstanceProvider.getRepositoryForInstance(context, instance).getGlobalState()
    }

    public fun getAllActiveCampaigns(
        context: Context,
        appId: String
    ): List<InAppCampaign> {
        val instance = SdkInstanceManager.getInstanceForAppId(appId) ?: return emptyList()
        val mapper = PayloadMapper()
        return mapper.entityToCampaign(
            InAppInstanceProvider.getRepositoryForInstance(context, instance)
                .getAllActiveCampaigns()
        )
    }

    public fun getCampaignById(
        context: Context,
        campaignId: String,
        appId: String
    ): InAppCampaign? {
        val instance = SdkInstanceManager.getInstanceForAppId(appId) ?: return null
        val entity = InAppInstanceProvider.getRepositoryForInstance(context, instance)
            .getCampaignById(campaignId) ?: return null
        return PayloadMapper().campaignEntityToCampaign(entity)
    }

    public fun getContext(appId: String): Set<String> {
        val instance = SdkInstanceManager.getInstanceForAppId(appId) ?: return emptySet()
        return InAppInstanceProvider.getCacheForInstance(instance).inAppContext
    }

    public fun previewInApp(context: Context, campaign: InAppCampaign, appId: String) {
        val instance = SdkInstanceManager.getInstanceForAppId(appId) ?: return
        previewInApp(context, instance, campaign)
    }
}