/*
 * Copyright (c) 2014-2021 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.internal

import android.content.Context
import android.os.Bundle
import com.moengage.core.internal.PUSH_EXTRA_INAPP_LEGACY_META
import com.moengage.core.internal.PUSH_EXTRA_INAPP_META
import com.moengage.core.internal.model.SdkInstance
import org.json.JSONObject
import java.util.concurrent.Executors
import java.util.concurrent.TimeUnit

/**
 * @author Umang Chamaria
 */

private const val DEFAULT_TEST_INAPP_DELAY_TIME = 5L

internal class PushToInAppHandler(private val sdkInstance: SdkInstance) {

    private val tag = "${InAppConstants.MODULE_TAG}PushToInAppHandler"

    fun shownInApp(context: Context, pushPayload: Bundle) {
        sdkInstance.logger.log { "$tag shownInApp() : $pushPayload" }
        if (pushPayload.containsKey(PUSH_EXTRA_INAPP_LEGACY_META)) {
            val campaignId = pushPayload.getString(PUSH_EXTRA_INAPP_LEGACY_META) ?: return
            showTestInApp(context, campaignId, DEFAULT_TEST_INAPP_DELAY_TIME)
        } else if (pushPayload.containsKey(PUSH_EXTRA_INAPP_META)) {
            val payload = pushPayload.getString(PUSH_EXTRA_INAPP_META) ?: return
            sdkInstance.logger.log { "$tag shownInApp() : InApp payload: $payload" }
            val inAppMetaJson = JSONObject(payload)
            val campaignId = inAppMetaJson.getString(InAppConstants.PUSH_ATTR_CAMPAIGN_ID) ?: return
            val timeDelay = inAppMetaJson.optLong(
                InAppConstants.PUSH_ATTR_TRIGGER_DELAY,
                DEFAULT_TEST_INAPP_DELAY_TIME
            )
            if (inAppMetaJson.optBoolean(InAppConstants.PUSH_ATTR_IS_TEST_CAMPAIGN, false)) {
                showTestInApp(context, campaignId, timeDelay)
            }
        }
    }

    private fun showTestInApp(context: Context, campaignId: String, timeDelay: Long) {
        sdkInstance.logger.log { "$tag showTestInApp() : Campaign-id: $campaignId" }
        val controller = InAppInstanceProvider.getControllerForInstance(sdkInstance)
        if (controller.scheduledExecutorService == null || controller.scheduledExecutorService?.isShutdown == true) {
            controller.scheduledExecutorService = Executors.newScheduledThreadPool(1)
        }
        controller.scheduledExecutorService?.schedule({
            showTestInApp(
                context,
                sdkInstance,
                campaignId
            )
        }, timeDelay, TimeUnit.SECONDS)
    }
}