/*
 * Copyright (c) 2014-2021 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.internal

import android.content.Context
import com.moengage.core.Properties
import com.moengage.core.analytics.MoEAnalyticsHelper
import com.moengage.core.internal.ATTRIBUTE_WIDGET_ID
import com.moengage.core.internal.EVENT_IN_APP_AUTO_DISMISS
import com.moengage.core.internal.EVENT_IN_APP_CLICKED
import com.moengage.core.internal.EVENT_IN_APP_DISMISSED
import com.moengage.core.internal.EVENT_IN_APP_SHOWN
import com.moengage.core.internal.model.SdkInstance
import com.moengage.inapp.internal.model.CampaignPayload
import com.moengage.inapp.model.CampaignData

/**
 * @author Umang Chamaria
 */

internal fun trackInAppShown(
    context: Context,
    sdkInstance: SdkInstance,
    data: CampaignData
) {
    val properties = Properties()
    addAttributesToProperties(properties, data.campaignId, data.campaignName, data.campaignContext)
    properties.setNonInteractive()
    MoEAnalyticsHelper.trackEvent(
        context,
        EVENT_IN_APP_SHOWN,
        properties,
        sdkInstance.instanceMeta.instanceId
    )
}

internal fun trackInAppClicked(
    context: Context,
    sdkInstance: SdkInstance,
    data: CampaignData,
    widgetId: Any?
) {
    val properties = Properties()
    addAttributesToProperties(properties, data.campaignId, data.campaignName, data.campaignContext)
    if ((widgetId is Int && widgetId > 0) || (widgetId is String && widgetId.isNotBlank())) {
        properties.addAttribute(ATTRIBUTE_WIDGET_ID, widgetId)
    }
    MoEAnalyticsHelper.trackEvent(
        context,
        EVENT_IN_APP_CLICKED,
        properties,
        sdkInstance.instanceMeta.instanceId
    )
}

internal fun trackInAppDismissed(
    context: Context,
    sdkInstance: SdkInstance,
    data: CampaignData
) {
    val properties = Properties()
    addAttributesToProperties(properties, data.campaignId, data.campaignName, data.campaignContext)
    MoEAnalyticsHelper.trackEvent(
        context,
        EVENT_IN_APP_DISMISSED,
        properties,
        sdkInstance.instanceMeta.instanceId
    )
}

internal fun trackAutoDismiss(
    context: Context,
    sdkInstance: SdkInstance,
    campaignPayload: CampaignPayload
) {
    val properties = Properties()
    addAttributesToProperties(
        properties,
        campaignPayload.campaignId,
        campaignPayload.campaignName,
        campaignPayload.campaignContext
    )
    properties.setNonInteractive()

    MoEAnalyticsHelper
        .trackEvent(
            context,
            EVENT_IN_APP_AUTO_DISMISS,
            properties,
            sdkInstance.instanceMeta.instanceId
        )
}