package com.moengage.inapp.internal.html

/**
 * @author Arshiya Khanum
 */
internal val JAVASCRIPT_BRIDGE: String =
    """var moengage = {
    trackEvent: 
    function(eventName, generalAttrJson, locationAttrJson, dateAttrJson, isNonInteractive, shouldAttachCampaignMeta) {
        moengageInternal.trackEvent(eventName, JSON.stringify(generalAttrJson), JSON.stringify(locationAttrJson), JSON.stringify(dateAttrJson), isNonInteractive, shouldAttachCampaignMeta);
    },
    trackClick: function(widgetId) { 
         var payload = {"widgetId": widgetId };
        moengageInternal.trackClick(JSON.stringify(payload)); 
    },
    trackDismiss: function() { moengageInternal.trackDismiss(); },
    setAlias: function(alias) { moengageInternal.setAlias(alias); },
    setUniqueId: function(uniqueId) { moengageInternal.setUniqueId(uniqueId); },
    setUserName: function(userName) { moengageInternal.setUserName(userName); },
    setFirstName: function(firstName) { moengageInternal.setFirstName(firstName); },
    setLastName: function(lastName) { moengageInternal.setLastName(lastName); },
    setEmailId: function(emailId) { moengageInternal.setEmailId(emailId); },
    setMobileNumber: function(mobileNumber) { moengageInternal.setMobileNumber(mobileNumber); },
    setGender: function(gender) { moengageInternal.setGender(gender); },
    setBirthDate: function(isoDate) { moengageInternal.setBirthDate(isoDate); },
    setUserLocation: function(latitude, longitude) {
        var payload = {"latitude": latitude, "longitude": longitude};
        moengageInternal.setUserLocation(JSON.stringify(payload)); 
    },
    trackRating: function(rating) { 
        var payload = {"rating": rating };
        moengageInternal.trackRating(JSON.stringify(payload)); 
    },
    setUserAttribute: function(name, value) {
        var attrJson = { "name" : name, "value": value };
        moengageInternal.setUserAttribute(JSON.stringify(attrJson)); 
    },
    setUserAttributeDate: function(name, isoDate) { moengageInternal.setUserAttributeDate(name, isoDate); },
    setUserAttributeLocation: function(name, latitude, longitude) {
         var payload = { "name" : name, "latitude": latitude, "longitude": longitude};
        moengageInternal.setUserAttributeLocation(JSON.stringify(payload)); 
    },
    navigateToScreen: function(screenName, dataJson) { moengageInternal.navigateToScreen(screenName, JSON.stringify(dataJson)); },
    openDeepLink: function(deepLinkUrl, dataJson) { moengageInternal.openDeepLink(deepLinkUrl, JSON.stringify(dataJson)); },
    openRichLanding: function(url, dataJson) { moengageInternal.openRichLanding(url, JSON.stringify(dataJson)); },
    openWebURL: function(webUrl, dataJson) { moengageInternal.openWebURL(webUrl, JSON.stringify(dataJson)); },
    dismissMessage: function() { moengageInternal.dismissMessage(); },
    copyText: function(textToCopy, message) { moengageInternal.copyText(textToCopy, message); },
    call: function(mobileNumber) { moengageInternal.call(mobileNumber); },
    sms: function(mobileNumber, message) { moengageInternal.sms(mobileNumber, message); },
    share: function(shareContent) { moengageInternal.share(shareContent); },
    customAction: function(dataJson) { moengageInternal.customAction(JSON.stringify(dataJson)); },
    handleNotificationPopUp: function() { console.log("MoEngage: handleNotificationPopUp() : notsupported on Android"); },
    navigateToSettings: function() { console.log("MoEngage: handleNotificationPopUp() : notsupported on Android"); },
    requestNotificationPermission: function() { moengageInternal.requestNotificationPermission(); },
    navigateToNotificationSettings: function() { 
        moengageInternal.navigateToNotificationSettings();
     },
}
    """.trimIndent()