package com.moengage.inapp.internal.html

import com.moengage.core.Properties
import com.moengage.core.model.GeoLocation
import com.moengage.inapp.internal.isValidJavaScriptString
import org.json.JSONObject

/**
 * @author Arshiya Khanum
 */
internal class WebPayloadParser {

    internal fun toProperties(
        generalAttrJson: String?,
        locationAttrJson: String?,
        dateAttrJson: String?,
        nonInteractive: Boolean
    ): Properties {
        val properties = Properties()
        addGeneralAttributes(generalAttrJson, properties)
        addLocationAttributes(locationAttrJson, properties)
        addDateAttributes(dateAttrJson, properties)
        if (nonInteractive) {
            properties.setNonInteractive()
        }

        return properties
    }

    private fun addGeneralAttributes(generalAttrJson: String?, properties: Properties) {
        if (generalAttrJson.isNullOrBlank() || !isValidJavaScriptString(generalAttrJson)) return
        val attributesJson = JSONObject(generalAttrJson)
        val keys = attributesJson.keys()
        while (keys.hasNext()) {
            val key = keys.next()
            if (!key.isNullOrBlank()) {
                properties.addAttribute(key, attributesJson[key])
            }
        }
    }

    private fun addLocationAttributes(locationAttrJson: String?, properties: Properties) {
        if (locationAttrJson.isNullOrBlank() || !isValidJavaScriptString(locationAttrJson)) return
        val locationJson = JSONObject(locationAttrJson)
        val keys = locationJson.keys()
        while (keys.hasNext()) {
            val key = keys.next()
            val value: JSONObject = locationJson[key] as JSONObject
            if (!key.isNullOrBlank()) {
                properties.addAttribute(
                    key,
                    GeoLocation(
                        value.getDouble(ARGUMENT_LATITUDE),
                        value.getDouble(ARGUMENT_LONGITUDE)
                    )
                )
            }
        }
    }

    private fun addDateAttributes(dateAttrJson: String?, properties: Properties) {
        if (dateAttrJson.isNullOrBlank() || !isValidJavaScriptString(dateAttrJson)) return

        val dateAttributeJson = JSONObject(dateAttrJson)
        val keys = dateAttributeJson.keys()
        while (keys.hasNext()) {
            val key = keys.next()
            if (!key.isNullOrBlank()) {
                properties.addDateIso(key, dateAttributeJson.getString(key))
            }
        }
    }
}

private const val ARGUMENT_LATITUDE = "latitude"
private const val ARGUMENT_LONGITUDE = "longitude"