package com.moengage.inapp.internal.model

import com.moengage.inapp.internal.model.enums.InAppType
import com.moengage.inapp.internal.model.enums.ScreenOrientation
import com.moengage.inapp.model.CampaignContext
import org.json.JSONObject

/**
 * @author Arshiya Khanum
 */
public open class CampaignPayload(
    /**
     * A unique identifier for the campaign.
     */
    public open val campaignId: String,
    /**
     * A readable name for the campaign.
     */
    public open val campaignName: String,

    /**
     * Type of template. Embedded, Full Screen, Pop up or Self Handled.
     */
    public open val templateType: String,
    /**
     * Interval after which the campaign should be dismissed if not clicked.
     */
    public open val dismissInterval: Long,
    /**
     *
     */
    public open val payload: JSONObject,
    /**
     * Campaign context attributes.
     */
    public open val campaignContext: CampaignContext,
    /**
     * Type of InApp. HTML or Nativ.
     */
    public open val inAppType: InAppType,

    /**
     * Set of supported screen orientations [LANDSCAPE, PORTRAIT].
     */
    public open val supportedOrientations: Set<ScreenOrientation>
)