package com.moengage.inapp.internal.model

import com.moengage.inapp.internal.model.enums.InAppType
import com.moengage.inapp.internal.model.enums.ScreenOrientation
import com.moengage.inapp.model.CampaignContext
import org.json.JSONObject

/**
 * @author Arshiya Khanum
 */
public class HtmlCampaignPayload(
    public override val campaignId: String,
    public override val campaignName: String,
    public override val templateType: String,
    public override val dismissInterval: Long,
    public override val payload: JSONObject,
    public override val campaignContext: CampaignContext,
    public override val inAppType: InAppType,
    public override val supportedOrientations: Set<ScreenOrientation>,
    public val htmlAssets: HtmlMeta?,
    public val htmlPayload: String
) : CampaignPayload(
    campaignId,
    campaignName,
    templateType,
    dismissInterval,
    payload,
    campaignContext,
    inAppType,
    supportedOrientations
) {
    override fun toString(): String {
        return "(" +
            "campaignId: $campaignId, " +
            "campaignName: $campaignName, " +
            "templateType: $templateType, " +
            "dismissInterval: $dismissInterval, " +
            "payload: $payload, " +
            "campaignContext; $campaignContext, " +
            "inAppType: ${inAppType.name}, " +
            "supportedOrientations: $supportedOrientations, " +
            "htmlAssets: $htmlAssets, " +
            "htmlPayload: $htmlPayload" +
            ")"
    }
}