package com.moengage.inapp.internal.model

import com.moengage.inapp.internal.model.enums.InAppType
import com.moengage.inapp.internal.model.enums.ScreenOrientation
import com.moengage.inapp.internal.model.enums.TemplateAlignment
import com.moengage.inapp.model.CampaignContext
import com.moengage.inapp.model.enums.InAppPosition
import org.json.JSONObject

/**
 * @author Arshiya Khanum
 */
public class NativeCampaignPayload(
    public override val campaignId: String,
    public override val campaignName: String,
    public override val templateType: String,
    public override val dismissInterval: Long,
    public override val payload: JSONObject,
    public override val campaignContext: CampaignContext,
    public override val inAppType: InAppType,
    override val supportedOrientations: Set<ScreenOrientation>,
    public val primaryContainer: InAppContainer?,
    public val alignment: TemplateAlignment,
    public val customPayload: String?,
    public val position: InAppPosition
) : CampaignPayload(
    campaignId,
    campaignName,
    templateType,
    dismissInterval,
    payload,
    campaignContext,
    inAppType,
    supportedOrientations
) {

    public constructor(
        campaignId: String,
        campaignName: String,
        primaryContainer: InAppContainer,
        templateType: String,
        alignment: TemplateAlignment,
        dismissInterval: Long,
        campaignPayload: JSONObject,
        campaignContext: CampaignContext,
        inAppType: InAppType,
        supportedOrientations: Set<ScreenOrientation>,
        position: InAppPosition = InAppPosition.ANY
    ) : this(
        campaignId = campaignId,
        campaignName = campaignName,
        templateType = templateType,
        dismissInterval = dismissInterval,
        payload = campaignPayload,
        campaignContext = campaignContext,
        inAppType = inAppType,
        supportedOrientations = supportedOrientations,
        primaryContainer = primaryContainer,
        alignment = alignment,
        customPayload = null,
        position = position
    )

    public constructor(
        campaignId: String,
        campaignName: String,
        alignment: TemplateAlignment,
        templateType: String,
        dismissInterval: Long,
        campaignPayload: JSONObject,
        customPayload: String,
        campaignContext: CampaignContext,
        inAppType: InAppType,
        supportedOrientations: Set<ScreenOrientation>
    ) : this(
        campaignId = campaignId,
        campaignName = campaignName,
        templateType = templateType,
        dismissInterval = dismissInterval,
        payload = campaignPayload,
        campaignContext = campaignContext,
        inAppType = inAppType,
        supportedOrientations = supportedOrientations,
        primaryContainer = null,
        alignment = alignment,
        customPayload = customPayload,
        position = InAppPosition.ANY
    )

    override fun toString(): String {
        return "NativeCampaignPayload{" +
            "campaignId=$campaignId," +
            "campaignName=$campaignName," +
            "templateType=$templateType," +
            "dismissInterval=$dismissInterval," +
            "payload=$payload," +
            "campaignContext=$campaignContext," +
            "inAppType=$inAppType," +
            "supportedOrientations=$supportedOrientations," +
            "primaryContainer=$primaryContainer," +
            "alignment=$alignment," +
            "customPayload=$customPayload," +
            "position=$position" +
            "}"
    }
}