/*
 * Copyright (c) 2014-2023 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.internal.model.configmeta

import java.util.Collections

/**
 * @author Umang Chamaria
 */
internal class ConfigChangeMeta {
    /**
     * Last Shown General InApp Campaign Meta Data of type [InAppConfigMeta]
     * Applicable for Intrusive InApp Campaigns, where single InApp will be shown at a time
     * @since 7.1.2
     */
    var lastShownGeneralCampaign: InAppConfigMeta? = null

    /**
     * Last Shown Nudge InApp Campaign Meta Data of type [InAppConfigMeta]
     * Applicable for Non Intrusive Nudge InApps as multiple Nudges can be shown at a time
     * @since 7.1.2
     */
    var lastShownNudges: MutableList<InAppConfigMeta> =
        Collections.synchronizedList(arrayListOf<InAppConfigMeta>())

    /**
     * Name of the Current Activity, Defaults to `null`
     */
    var activityName: String? = null

    /**
     * Orientation of the Current Activity, Defaults to `-1`
     * Possible Values: 0 if Undefined, 1 if Portrait , 2 if Landscape
     */
    var activityOrientation = -1

    override fun toString(): String {
        return "ConfigChangeMeta(" +
            "lastShownCampaign=$lastShownGeneralCampaign, " +
            "activityName=$activityName, " +
            "activityOrientation=$activityOrientation" +
            "lastShownNudges= $lastShownNudges" +
            ")"
    }
}