/*
 * Copyright (c) 2014-2021 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.internal.model.meta;

import com.moengage.core.LogLevel;
import com.moengage.core.internal.logger.Logger;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 * Date: 2019-07-25
 */
public class DisplayControl {

  private static final String TAG = "DisplayControl";

  public final Rules rules;

  /**
   * Adds delay to show InApp
   */
  public final long delay;

  public DisplayControl(Rules rules, long delay) {
    this.rules = rules;
    this.delay = delay;
  }

  public static JSONObject toJson(DisplayControl displayControl) {
    try {
      JSONObject displayJson = new JSONObject();
      displayJson.put(RULES, Rules.toJson(displayControl.rules));
      displayJson.put(DELAY, displayControl.delay);
      return displayJson;
    } catch (Exception e) {
      Logger.print(LogLevel.ERROR, e, () -> TAG + "toJson()");
    }
    return null;
  }

  @Override public String toString() {
    return "DisplayControl{" +
        "rules=" + rules +','+
        "delay=" + delay +
        '}';
  }

  private static final String RULES = "rules";
  private static final String DELAY = "delay";

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    DisplayControl that = (DisplayControl) o;

    if(delay != that.delay) return false;
    return rules != null ? rules.equals(that.rules) : that.rules == null;
  }

}
