/*
 * Copyright (c) 2014-2022 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.internal.model.network;

import androidx.annotation.Nullable;
import com.moengage.core.internal.model.DeviceType;
import com.moengage.core.internal.model.network.BaseRequest;
import com.moengage.inapp.internal.InAppConstants;
import com.moengage.inapp.model.CampaignContext;
import com.moengage.inapp.internal.model.TriggerRequestMeta;
import com.moengage.inapp.internal.model.enums.InAppType;
import java.util.Set;

/**
 * @author Umang Chamaria
 * Date: 2019-05-03
 */
public class CampaignRequest extends BaseRequest {
  public final String campaignId;
  @Nullable public final TriggerRequestMeta triggerMeta;
  @Nullable public final String screenName;
  @Nullable public final Set<String> contextList;
  public final CampaignContext campaignContext;
  public final DeviceType deviceType;
  public final InAppType inAppType;
  public final String inAppVersion;

  public CampaignRequest(BaseRequest baseRequest, String campaignId, DeviceType deviceType){
    this(baseRequest, campaignId, null, null, null, null, deviceType, null);
  }

  public CampaignRequest(BaseRequest baseRequest, String campaignId, @Nullable String screenName,
      @Nullable Set<String> contextList, @Nullable TriggerRequestMeta triggerMeta,
      @Nullable CampaignContext campaignContext, DeviceType deviceType, InAppType inAppType) {
    super(baseRequest);
    this.campaignId = campaignId;
    this.triggerMeta = triggerMeta;
    this.screenName = screenName;
    this.contextList = contextList;
    this.campaignContext = campaignContext;
    this.deviceType = deviceType;
    this.inAppType = inAppType;
    this.inAppVersion = InAppConstants.INAPP_LIB_VERSION;
  }
}
