package com.moengage.inapp.internal.repository.local

import android.content.Context
import android.database.Cursor
import com.moengage.core.LogLevel
import com.moengage.core.internal.model.SdkInstance
import com.moengage.core.internal.model.database.QueryParams
import com.moengage.core.internal.storage.database.DbAdapter
import com.moengage.core.internal.storage.database.contract.PROJECTION_INAPP_STATS
import com.moengage.core.internal.storage.database.contract.PROJECTION_INAPP_V3
import com.moengage.core.internal.storage.database.contract.TABLE_NAME_INAPP_STATS
import com.moengage.core.internal.storage.database.contract.TABLE_NAME_INAPP_V3
import com.moengage.inapp.internal.InAppConstants.MODULE_TAG

/**
 * A helper class for migrating tables from non-encrypted to encrypted storage
 * @author Arshiya Khanum
 */
internal class DatabaseMigrationHandler(
    context: Context,
    unencryptedSdkInstance: SdkInstance,
    private val encryptedSdkInstance: SdkInstance,
    private val unencryptedDbAdapter: DbAdapter,
    private val encryptedDbAdapter: DbAdapter
) {
    private val tag = "${MODULE_TAG}DatabaseMigrationHelper"
    private val unEncryptedMarshallingHelper = Marshaller(context, unencryptedSdkInstance)
    private val encryptedMarshallingHelper = Marshaller(context, encryptedSdkInstance)

    internal fun migrate() {
        migrateInAppV3Table()
        migrateInAppStatsTable()
    }

    private fun migrateInAppV3Table() {
        var cursor: Cursor? = null
        try {
            encryptedSdkInstance.logger.log { "$tag migrateInAppV3Table() : will migrate data" }
            cursor = unencryptedDbAdapter.query(
                TABLE_NAME_INAPP_V3,
                QueryParams(
                    PROJECTION_INAPP_V3,
                    null
                )
            )
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    val campaignEntity = unEncryptedMarshallingHelper.entityFromCursor(cursor)
                    encryptedDbAdapter.insert(
                        TABLE_NAME_INAPP_V3,
                        encryptedMarshallingHelper.campaignEntityToContentValues(campaignEntity)
                    )
                } while (cursor.moveToNext())
            }
            encryptedSdkInstance.logger.log { "$tag migrateInAppV3Table() : migration completed" }
        } catch (t: Throwable) {
            encryptedSdkInstance.logger.log(LogLevel.ERROR, t) { "$tag migrateInAppV3Table() : " }
        } finally {
            cursor?.close()
        }
    }

    private fun migrateInAppStatsTable() {
        var cursor: Cursor? = null
        try {
            encryptedSdkInstance.logger.log { "$tag migrateInAppStatsTable() : will migrate data" }
            cursor = unencryptedDbAdapter.query(
                TABLE_NAME_INAPP_STATS,
                QueryParams(
                    PROJECTION_INAPP_STATS,
                    null
                )
            )
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    val statModel = unEncryptedMarshallingHelper.statFromCursor(cursor)
                    encryptedDbAdapter.insert(
                        TABLE_NAME_INAPP_STATS,
                        encryptedMarshallingHelper.statToContentValues(statModel)
                    )
                } while (cursor.moveToNext())
            }
            encryptedSdkInstance.logger.log { "$tag migrateInAppStatsTable() : migration completed" }
        } catch (t: Throwable) {
            encryptedSdkInstance.logger.log(
                LogLevel.ERROR,
                t
            ) { "$tag migrateInAppStatsTable() : " }
        } finally {
            cursor?.close()
        }
    }
}