/*
 * Copyright (c) 2014-2022 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.internal.repository.local

import com.moengage.core.internal.model.SdkStatus
import com.moengage.core.internal.model.network.BaseRequest
import com.moengage.inapp.internal.model.CampaignEntity
import com.moengage.inapp.internal.model.InAppGlobalState
import com.moengage.inapp.internal.model.StatModel
import com.moengage.inapp.internal.model.meta.CampaignState
import org.json.JSONException

/**
 * @author Arshiya Khanum
 */
internal interface LocalRepository {

    fun storeApiSyncInterval(syncInterval: Long)

    fun getApiSyncInterval(): Long

    fun storeLastApiSyncTime(nextSyncTime: Long)

    fun getLastSyncTime(): Long

    fun storeGlobalDelay(globalDelay: Long)

    fun getGlobalState(): InAppGlobalState

    fun addOrUpdateInApp(newCampaigns: List<CampaignEntity>)

    fun deleteExpiredCampaigns()

    fun clearData()

    fun getGeneralCampaigns(): List<CampaignEntity>

    fun getSelfHandledCampaign(): List<CampaignEntity>

    @Throws(JSONException::class)
    fun baseRequest(): BaseRequest

    fun updateCampaignState(state: CampaignState, campaignId: String): Int

    fun updateLastShowTime(time: Long)

    fun getAllActiveCampaigns(): List<CampaignEntity>

    fun getCampaignById(campaignId: String): CampaignEntity?

    fun getStats(batchSize: Int): List<StatModel>

    fun deleteStatById(stat: StatModel): Int

    fun getSdkStatus(): SdkStatus

    fun writeStats(statModel: StatModel): Long

    fun getAllCampaigns(): List<CampaignEntity>

    fun storeHtmlAssetsDeleteTime(deleteTime: Long)

    fun getLastHtmlAssetsDeleteTime(): Long

    fun getTriggerCampaigns(): List<CampaignEntity>

    fun getPushPermissionRequestCount(): Int

    fun isStorageAndAPICallEnabled(): Boolean

    fun getNonIntrusiveNudgeCampaigns(): List<CampaignEntity>
}