/*
 * Copyright (c) 2014-2023 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moengage.inapp.internal.widgets.ratingbar

import android.annotation.SuppressLint
import android.content.Context
import android.util.AttributeSet
import androidx.annotation.Keep
import com.moengage.core.internal.logger.Logger
import com.moengage.inapp.internal.MODULE_TAG
import com.moengage.inapp.internal.engine.getColor
import com.moengage.inapp.internal.model.customrating.RatingIcon
import com.moengage.inapp.internal.model.enums.RatingType

/**
 * Custom RatingBar
 * @since 7.0.0
 */
@Suppress("SameParameterValue")
@SuppressLint("AppCompatCustomView")
@Keep
internal class MoECustomRatingBar : BaseRatingBar {

    private val tag = "${MODULE_TAG}MoECustomRatingBar"
    private var ratingIcons: Map<Int, RatingIcon> = emptyMap()

    @JvmOverloads
    constructor(
        context: Context,
        ratingType: RatingType,
        attrs: AttributeSet? = null
    ) : super(
        context,
        ratingType,
        attrs
    )

    constructor(
        context: Context,
        ratingType: RatingType,
        attrs: AttributeSet?,
        defStyleAttr: Int
    ) : super(context, ratingType, attrs, defStyleAttr)

    /**
     * Sets value to [ratingIcons]
     */
    fun setRatingIcons(ratingIcons: Map<Int, RatingIcon>) {
        Logger.print { "$tag setRatingIcons(): " }
        this.ratingIcons = ratingIcons
    }

    override fun getColorOn(position: Int): Int? {
        Logger.print { "$tag getColorOn(): for position $position" }
        val ratingIcon = ratingIcons[position] ?: return null
        val color = ratingIcon.selectedState.style.background.color ?: return null
        return getColor(color)
    }

    override fun getColorOff(position: Int): Int? {
        Logger.print { "$tag getColorOff(): for position $position" }
        val ratingIcon = ratingIcons[position] ?: return null
        val color = ratingIcon.unselectedState.style.background.color ?: return null
        return getColor(color)
    }
}