/*
 * Copyright (c) 2014-2022 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.model

import com.moengage.core.internal.utils.MoEUtils
import org.json.JSONObject

/**
 *
 * @author Arshiya Khanum
 */
public class CampaignContext(
    /**
     * Formatted Campaign-id
     */
    public val formattedCampaignId: String,
    /**
     * complete payload received in `campaign_context` key.
     */
    public val payload: JSONObject,
    /**
     * Map of `campaign_context` object.
     */
    public val attributes: Map<String, Any>
) {

    public override fun toString(): String {
        return payload.toString()
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other == null || javaClass != other.javaClass) return false

        val that = other as CampaignContext
        if (this.formattedCampaignId != that.formattedCampaignId) return false
        return this.attributes == that.attributes
    }

    public companion object {

        @JvmStatic
        public fun fromJson(payload: JSONObject): CampaignContext {
            return CampaignContext(
                payload.getString(CAMPAIGN_ID),
                payload,
                MoEUtils.jsonToMap(payload)
            )
        }

        private const val CAMPAIGN_ID: String = "cid"
    }
}