/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal;

import android.content.Context;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.core.internal.utils.TimeUtilsKt;
import com.moengage.inapp.internal.DeliveryLoggerKt;
import com.moengage.inapp.internal.InAppInstanceProvider;
import com.moengage.inapp.internal.UtilsKt;
import com.moengage.inapp.internal.model.CampaignPayload;
import com.moengage.inapp.internal.model.CampaignStats;
import com.moengage.inapp.internal.model.StatModel;
import com.moengage.inapp.internal.model.enums.EvaluationStatusCode;
import com.moengage.inapp.internal.model.meta.InAppCampaign;
import com.moengage.inapp.internal.repository.InAppRepository;
import com.moengage.inapp.model.CampaignContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J\u001b\u0010\u0019\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u00a2\u0006\u0002\b\u001bJ\u001d\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\u001d\u0010\"\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b#J%\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b'J%\u0010$\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b'J%\u0010$\u001a\u00020\f2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b'J\u0015\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J\u0015\u0010.\u001a\u00020\f2\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b/R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/moengage/inapp/internal/DeliveryLogger;", "", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Lcom/moengage/core/internal/model/SdkInstance;)V", "lock", "stats", "", "", "Lcom/moengage/inapp/internal/model/CampaignStats;", "tag", "bulkLogging", "", "campaignList", "", "Lcom/moengage/inapp/internal/model/meta/InAppCampaign;", "reason", "campaignStatToJson", "Lorg/json/JSONObject;", "campaignStatToJson$inapp_release", "isStatsLoggingEnabled", "", "listToJsonArray", "Lorg/json/JSONArray;", "timestampList", "logCampaignAttempted", "campaignMetaList", "logCampaignAttempted$inapp_release", "logImpressionStageFailure", "campaign", "Lcom/moengage/inapp/internal/model/CampaignPayload;", "statusCode", "Lcom/moengage/inapp/internal/model/enums/EvaluationStatusCode;", "logImpressionStageFailure$inapp_release", "logPriorityStageFailure", "logPriorityStageFailure$inapp_release", "updateStatForCampaign", "campaignPayload", "timestamp", "updateStatForCampaign$inapp_release", "campaignContext", "Lcom/moengage/inapp/model/CampaignContext;", "uploadStats", "context", "Landroid/content/Context;", "uploadStats$inapp_release", "writeStatsToStorage", "writeStatsToStorage$inapp_release", "inapp_release"})
public final class DeliveryLogger {
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;
    @NotNull
    private Map<String, CampaignStats> stats;
    @NotNull
    private final Object lock;

    public DeliveryLogger(@NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.sdkInstance = sdkInstance;
        this.tag = "InApp_7.1.1_StatsLogger";
        this.stats = new HashMap();
        this.lock = new Object();
    }

    public final void logCampaignAttempted$inapp_release(@NotNull List<InAppCampaign> campaignMetaList) {
        Intrinsics.checkNotNullParameter(campaignMetaList, (String)"campaignMetaList");
        this.bulkLogging(campaignMetaList, "ATM");
    }

    public final void logPriorityStageFailure$inapp_release(@NotNull InAppCampaign campaign, @NotNull EvaluationStatusCode statusCode) {
        Intrinsics.checkNotNullParameter((Object)campaign, (String)"campaign");
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, campaign, statusCode){
            final /* synthetic */ DeliveryLogger this$0;
            final /* synthetic */ InAppCampaign $campaign;
            final /* synthetic */ EvaluationStatusCode $statusCode;
            {
                this.this$0 = $receiver;
                this.$campaign = $campaign;
                this.$statusCode = $statusCode;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return DeliveryLogger.access$getTag$p(this.this$0) + " logPriorityStageFailure() : Campaign-id: " + this.$campaign.getCampaignMeta().campaignId + ", status code: " + (Object)((Object)this.$statusCode);
            }
        }), (int)3, null);
        String string = (String)DeliveryLoggerKt.access$getPriorityStageFailureMap$p().get((Object)statusCode);
        if (string == null) {
            return;
        }
        String reason = string;
        if (campaign.getCampaignMeta().campaignContext == null) {
            return;
        }
        CampaignContext campaignContext = campaign.getCampaignMeta().campaignContext;
        Intrinsics.checkNotNullExpressionValue((Object)campaignContext, (String)"campaign.campaignMeta.campaignContext");
        this.updateStatForCampaign$inapp_release(campaignContext, TimeUtilsKt.currentISOTime(), reason);
    }

    public final void logImpressionStageFailure$inapp_release(@NotNull CampaignPayload campaign, @NotNull EvaluationStatusCode statusCode) {
        Intrinsics.checkNotNullParameter((Object)campaign, (String)"campaign");
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, campaign, statusCode){
            final /* synthetic */ DeliveryLogger this$0;
            final /* synthetic */ CampaignPayload $campaign;
            final /* synthetic */ EvaluationStatusCode $statusCode;
            {
                this.this$0 = $receiver;
                this.$campaign = $campaign;
                this.$statusCode = $statusCode;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return DeliveryLogger.access$getTag$p(this.this$0) + " logImpressionStageFailure() : Campaign-id: " + this.$campaign.getCampaignId() + ", status code: " + (Object)((Object)this.$statusCode);
            }
        }), (int)3, null);
        String string = (String)DeliveryLoggerKt.access$getImpressionStageFailureMap$p().get((Object)statusCode);
        if (string == null) {
            return;
        }
        String reason = string;
        campaign.getCampaignContext();
        this.updateStatForCampaign$inapp_release(campaign.getCampaignContext(), TimeUtilsKt.currentISOTime(), reason);
    }

    private final void bulkLogging(List<InAppCampaign> campaignList, String reason) {
        if (!this.isStatsLoggingEnabled()) {
            return;
        }
        String timestamp = TimeUtilsKt.currentISOTime();
        for (InAppCampaign campaignMeta : campaignList) {
            if (campaignMeta.getCampaignMeta().campaignContext == null) continue;
            CampaignContext campaignContext = campaignMeta.getCampaignMeta().campaignContext;
            Intrinsics.checkNotNullExpressionValue((Object)campaignContext, (String)"campaignMeta.campaignMeta.campaignContext");
            this.updateStatForCampaign$inapp_release(campaignContext, timestamp, reason);
        }
    }

    public final void updateStatForCampaign$inapp_release(@NotNull InAppCampaign campaign, @NotNull String timestamp, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)campaign, (String)"campaign");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, campaign, reason){
            final /* synthetic */ DeliveryLogger this$0;
            final /* synthetic */ InAppCampaign $campaign;
            final /* synthetic */ String $reason;
            {
                this.this$0 = $receiver;
                this.$campaign = $campaign;
                this.$reason = $reason;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return DeliveryLogger.access$getTag$p(this.this$0) + " updateStatForCampaign() : Campaign-id: " + this.$campaign.getCampaignMeta().campaignId + ", reason: " + this.$reason;
            }
        }), (int)3, null);
        if (campaign.getCampaignMeta().campaignContext == null) {
            return;
        }
        CampaignContext campaignContext = campaign.getCampaignMeta().campaignContext;
        Intrinsics.checkNotNullExpressionValue((Object)campaignContext, (String)"campaign.campaignMeta.campaignContext");
        this.updateStatForCampaign$inapp_release(campaignContext, timestamp, reason);
    }

    public final void updateStatForCampaign$inapp_release(@NotNull CampaignPayload campaignPayload, @NotNull String timestamp, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)campaignPayload, (String)"campaignPayload");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.updateStatForCampaign$inapp_release(campaignPayload.getCampaignContext(), timestamp, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateStatForCampaign$inapp_release(@NotNull CampaignContext campaignContext, @NotNull String timestamp, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)campaignContext, (String)"campaignContext");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Object object = this.lock;
        synchronized (object) {
            Boolean bl;
            boolean bl2 = false;
            if (!this.isStatsLoggingEnabled()) {
                return;
            }
            CampaignStats campaignStats = this.stats.get(campaignContext.getFormattedCampaignId());
            if (campaignStats == null) {
                campaignStats = new CampaignStats();
                Map<String, List<String>> map = campaignStats.reasons;
                Intrinsics.checkNotNullExpressionValue(map, (String)"campaignStats.reasons");
                Map<String, List<String>> map2 = map;
                Object object2 = new String[]{timestamp};
                object2 = CollectionsKt.mutableListOf((Object[])object2);
                map2.put(reason, (List<String>)object2);
                this.stats.put(campaignContext.getFormattedCampaignId(), campaignStats);
                return;
            }
            List<String> occurrencesList = campaignStats.reasons.get(reason);
            if (occurrencesList == null) {
                List timestampList = new ArrayList();
                timestampList.add(timestamp);
                Map<String, List<String>> map = campaignStats.reasons;
                Intrinsics.checkNotNullExpressionValue(map, (String)"campaignStats.reasons");
                map.put(reason, timestampList);
                bl = Unit.INSTANCE;
            } else {
                bl = occurrencesList.add(timestamp);
            }
            Boolean bl3 = bl;
        }
    }

    public final void writeStatsToStorage$inapp_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            if (!this.isStatsLoggingEnabled()) {
                Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ DeliveryLogger this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return DeliveryLogger.access$getTag$p(this.this$0) + " writeStatsToStorage() : Stats upload is disabled, will not store stats.";
                    }
                }), (int)3, null);
                this.stats.clear();
                return;
            }
            if (this.stats.isEmpty()) {
                Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ DeliveryLogger this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return DeliveryLogger.access$getTag$p(this.this$0) + " writeStatsToStorage() : Not stats to store";
                    }
                }), (int)3, null);
                return;
            }
            JSONObject statsJson = new JSONObject();
            for (Map.Entry<String, CampaignStats> entry : this.stats.entrySet()) {
                String key = entry.getKey();
                CampaignStats value = entry.getValue();
                statsJson.put(key, (Object)this.campaignStatToJson$inapp_release(value));
            }
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, statsJson){
                final /* synthetic */ DeliveryLogger this$0;
                final /* synthetic */ JSONObject $statsJson;
                {
                    this.this$0 = $receiver;
                    this.$statsJson = $statsJson;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return DeliveryLogger.access$getTag$p(this.this$0) + " writeStatsToStorage() : Recorded Stats: " + this.$statsJson;
                }
            }), (int)3, null);
            if (statsJson.length() == 0) {
                return;
            }
            this.stats.clear();
            InAppInstanceProvider.INSTANCE.getRepositoryForInstance$inapp_release(context, this.sdkInstance).writeStats(new StatModel(TimeUtilsKt.currentSeconds(), CoreUtils.getRequestId(), statsJson));
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ DeliveryLogger this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return DeliveryLogger.access$getTag$p(this.this$0) + " writeStatsToStorage() : ";
                }
            });
        }
    }

    @NotNull
    public final JSONObject campaignStatToJson$inapp_release(@NotNull CampaignStats stats) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        JSONObject campaignStatJson = new JSONObject();
        Map<String, List<String>> map = stats.reasons;
        Intrinsics.checkNotNullExpressionValue(map, (String)"stats.reasons");
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(value, (String)"value");
            campaignStatJson.put(key, (Object)this.listToJsonArray(value));
        }
        return campaignStatJson;
    }

    private final JSONArray listToJsonArray(List<String> timestampList) {
        JSONArray jsonArray = new JSONArray();
        for (String timeStamp : timestampList) {
            jsonArray.put((Object)timeStamp);
        }
        return jsonArray;
    }

    private final boolean isStatsLoggingEnabled() {
        return this.sdkInstance.getRemoteConfig().getInAppConfig().isStatsEnabled();
    }

    public final void uploadStats$inapp_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            InAppRepository repository = InAppInstanceProvider.INSTANCE.getRepositoryForInstance$inapp_release(context, this.sdkInstance);
            if (!UtilsKt.isModuleEnabled(context, this.sdkInstance)) {
                return;
            }
            InAppInstanceProvider.INSTANCE.getDeliveryLoggerForInstance$inapp_release(this.sdkInstance).writeStatsToStorage$inapp_release(context);
            repository.uploadStats();
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ DeliveryLogger this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return DeliveryLogger.access$getTag$p(this.this$0) + " uploadStats() : ";
                }
            });
        }
    }

    public static final /* synthetic */ String access$getTag$p(DeliveryLogger $this) {
        return $this.tag;
    }
}

