/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.MultiTransformation;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.moengage.core.Properties;
import com.moengage.core.internal.global.GlobalResources;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.AppMeta;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.model.ViewDimension;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.core.internal.utils.TimeUtilsKt;
import com.moengage.inapp.internal.Evaluator;
import com.moengage.inapp.internal.InAppInstanceProvider;
import com.moengage.inapp.internal.InAppModuleManager;
import com.moengage.inapp.internal.UtilsKt;
import com.moengage.inapp.internal.model.CampaignPayload;
import com.moengage.inapp.internal.model.InAppContainer;
import com.moengage.inapp.internal.model.InAppGlobalState;
import com.moengage.inapp.internal.model.NativeCampaignPayload;
import com.moengage.inapp.internal.model.ViewCreationMeta;
import com.moengage.inapp.internal.model.enums.EvaluationStatusCode;
import com.moengage.inapp.internal.model.enums.InAppType;
import com.moengage.inapp.internal.model.enums.ScreenOrientation;
import com.moengage.inapp.internal.model.meta.InAppCampaign;
import com.moengage.inapp.model.CampaignContext;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0090\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u001c\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u001a\u000e\u0010 \u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0000\u001a\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a(\u0010*\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001fH\u0000\u001a\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0000\u001a\u0018\u0010/\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'H\u0000\u001a\u0018\u00100\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0010\u00101\u001a\u00020\u000f2\b\u00102\u001a\u0004\u0018\u00010\u0005\u001a\u0012\u00103\u001a\u00020\u000f2\b\u00102\u001a\u0004\u0018\u000104H\u0000\u001a8\u00105\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u0002042\u0006\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020\u000f\u001a\u0018\u0010;\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010=\u001a\u00020>\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"screenOrientationMapper", "", "", "Lcom/moengage/inapp/internal/model/enums/ScreenOrientation;", "tag", "", "addAttributesToProperties", "", "properties", "Lcom/moengage/core/Properties;", "campaignId", "campaignName", "campaignContext", "Lcom/moengage/inapp/model/CampaignContext;", "canShowInApp", "", "context", "Landroid/content/Context;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "canShowInAppInCurrentOrientation", "orientation", "supportedOrientations", "", "enrichAttributesForTriggeredEvaluation", "Lorg/json/JSONObject;", "attributes", "appMeta", "Lcom/moengage/core/internal/model/AppMeta;", "getContainerIdFromCampaignPayload", "campaignPayload", "Lcom/moengage/inapp/internal/model/CampaignPayload;", "getCurrentOrientation", "getNavigationBarHeight", "getScreenDimension", "Lcom/moengage/core/internal/model/ViewDimension;", "getStatusBarHeight", "getUnspecifiedViewDimension", "view", "Landroid/view/View;", "getViewCreationMeta", "Lcom/moengage/inapp/internal/model/ViewCreationMeta;", "isCampaignEligibleForDisplay", "campaign", "Lcom/moengage/inapp/internal/model/meta/InAppCampaign;", "payload", "isDelayedInApp", "isInAppExceedingScreen", "isModuleEnabled", "isValidJavaScriptString", "string", "isValidJavaScriptValue", "", "loadContainerImageBackground", "borderRadius", "src", "imageView", "Landroid/widget/ImageView;", "isGif", "logCurrentInAppState", "screenOrientationFromJson", "jsonArray", "Lorg/json/JSONArray;", "inapp_release"})
public final class UtilsKt {
    @NotNull
    private static final String tag = "InApp_7.1.1_Utils";
    @NotNull
    private static final Map<Integer, ScreenOrientation> screenOrientationMapper;

    public static final boolean isModuleEnabled(@NotNull Context context, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        if (!InAppInstanceProvider.INSTANCE.getRepositoryForInstance$inapp_release(context, sdkInstance).isModuleEnabled()) {
            Logger.Companion.print$default((Logger.Companion)Logger.Companion, (int)0, null, (Function0)isModuleEnabled.1.INSTANCE, (int)3, null);
            return false;
        }
        return true;
    }

    public static final boolean isValidJavaScriptString(@Nullable String string) {
        CharSequence charSequence;
        return !Intrinsics.areEqual((Object)string, (Object)"undefined") && !Intrinsics.areEqual((Object)string, (Object)"null") && !((charSequence = (CharSequence)string) == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    @NotNull
    public static final Set<ScreenOrientation> screenOrientationFromJson(@NotNull JSONArray jsonArray) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        Set screenOrientations = new LinkedHashSet();
        int n = jsonArray.length();
        for (int i = 0; i < n; ++i) {
            String string = jsonArray.getString(i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.getString(i)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            screenOrientations.add(ScreenOrientation.valueOf(string2));
        }
        return screenOrientations;
    }

    public static final boolean canShowInAppInCurrentOrientation(int orientation, @NotNull Set<? extends ScreenOrientation> supportedOrientations) {
        Intrinsics.checkNotNullParameter(supportedOrientations, (String)"supportedOrientations");
        return CollectionsKt.contains((Iterable)supportedOrientations, (Object)((Object)screenOrientationMapper.get(orientation)));
    }

    public static final int getCurrentOrientation(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getConfiguration().orientation;
    }

    public static final void addAttributesToProperties(@NotNull Properties properties, @NotNull String campaignId, @NotNull String campaignName, @Nullable CampaignContext campaignContext) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        Intrinsics.checkNotNullParameter((Object)campaignName, (String)"campaignName");
        properties.addAttribute("campaign_id", (Object)campaignId).addAttribute("campaign_name", (Object)campaignName);
        if (campaignContext != null) {
            for (Map.Entry<String, Object> entry : campaignContext.getAttributes().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                properties.addAttribute(key, value);
            }
        }
    }

    public static /* synthetic */ void addAttributesToProperties$default(Properties properties, String string, String string2, CampaignContext campaignContext, int n, Object object) {
        if ((n & 8) != 0) {
            campaignContext = null;
        }
        UtilsKt.addAttributesToProperties(properties, string, string2, campaignContext);
    }

    public static final boolean isValidJavaScriptValue(@Nullable Object string) {
        return !Intrinsics.areEqual((Object)string, (Object)"undefined") && !Intrinsics.areEqual((Object)string, (Object)"null");
    }

    public static final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int marginTop = 0;
        int resource = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resource > 0) {
            marginTop = context.getResources().getDimensionPixelSize(resource);
        }
        return marginTop;
    }

    @NotNull
    public static final ViewDimension getScreenDimension(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return new ViewDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
    }

    @NotNull
    public static final ViewCreationMeta getViewCreationMeta(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new ViewCreationMeta(UtilsKt.getScreenDimension(context), UtilsKt.getStatusBarHeight(context), UtilsKt.getNavigationBarHeight(context));
    }

    public static final boolean canShowInApp(@NotNull Context context, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        boolean canShowInApp2 = UtilsKt.isModuleEnabled(context, sdkInstance) && InAppInstanceProvider.INSTANCE.getControllerForInstance$inapp_release(sdkInstance).isInAppSynced();
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(canShowInApp2){
            final /* synthetic */ boolean $canShowInApp;
            {
                this.$canShowInApp = $canShowInApp;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "InApp_7.1.1_Utils canShowInApp() : Can show InApp? " + this.$canShowInApp;
            }
        }), (int)3, null);
        return canShowInApp2;
    }

    public static final void logCurrentInAppState(@NotNull Context context, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)logCurrentInAppState.1.INSTANCE, (int)3, null);
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(sdkInstance){
            final /* synthetic */ SdkInstance $sdkInstance;
            {
                this.$sdkInstance = $sdkInstance;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "InApp_7.1.1_Utils logCurrentInAppState() : InApp-Context: " + InAppInstanceProvider.INSTANCE.getCacheForInstance$inapp_release(this.$sdkInstance).getInAppContext();
            }
        }), (int)3, null);
        InAppGlobalState globalState = InAppInstanceProvider.INSTANCE.getRepositoryForInstance$inapp_release(context, sdkInstance).getGlobalState();
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(globalState){
            final /* synthetic */ InAppGlobalState $globalState;
            {
                this.$globalState = $globalState;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "InApp_7.1.1_Utils logCurrentInAppState() : \n Global Delay: " + this.$globalState.getGlobalDelay() + " \n Last campaign show at: " + TimeUtilsKt.isoStringFromSeconds((long)this.$globalState.getLastShowTime()) + "\n Current Time: " + TimeUtilsKt.isoStringFromSeconds((long)this.$globalState.getCurrentDeviceTime());
            }
        }), (int)3, null);
    }

    @NotNull
    public static final ViewDimension getUnspecifiedViewDimension(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.measure(0, 0);
        return new ViewDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    public static final boolean isInAppExceedingScreen(@NotNull Context context, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewDimension screenDimension = UtilsKt.getScreenDimension(context);
        ViewDimension inAppDimension = UtilsKt.getUnspecifiedViewDimension(view);
        return screenDimension.height < inAppDimension.height;
    }

    public static final boolean isCampaignEligibleForDisplay(@NotNull Context context, @NotNull SdkInstance sdkInstance, @NotNull InAppCampaign campaign, @NotNull CampaignPayload payload2) {
        EvaluationStatusCode statusCode;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)campaign, (String)"campaign");
        Intrinsics.checkNotNullParameter((Object)payload2, (String)"payload");
        Evaluator evaluator = new Evaluator(sdkInstance);
        Set<String> set = InAppInstanceProvider.INSTANCE.getCacheForInstance$inapp_release(sdkInstance).getInAppContext();
        String string = InAppModuleManager.INSTANCE.getCurrentActivityName();
        if (string == null) {
            string = "";
        }
        if ((statusCode = evaluator.isCampaignEligibleForDisplay(campaign, set, string, InAppInstanceProvider.INSTANCE.getRepositoryForInstance$inapp_release(context, sdkInstance).getGlobalState(), UtilsKt.getCurrentOrientation(context), CoreUtils.isNotificationEnabled((Context)context))) != EvaluationStatusCode.SUCCESS) {
            Logger.log$default((Logger)sdkInstance.logger, (int)3, null, (Function0)isCampaignEligibleForDisplay.1.INSTANCE, (int)2, null);
            InAppInstanceProvider.INSTANCE.getDeliveryLoggerForInstance$inapp_release(sdkInstance).logImpressionStageFailure$inapp_release(payload2, statusCode);
            return false;
        }
        return true;
    }

    public static final boolean isDelayedInApp(@NotNull InAppCampaign campaign) {
        Intrinsics.checkNotNullParameter((Object)campaign, (String)"campaign");
        return campaign.getCampaignMeta().displayControl.delay != -1L;
    }

    public static final int getNavigationBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int marginBottom = 0;
        int resource = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        if (resource > 0) {
            marginBottom = context.getResources().getDimensionPixelSize(resource);
        }
        return marginBottom;
    }

    @NotNull
    public static final JSONObject enrichAttributesForTriggeredEvaluation(@NotNull JSONObject attributes, @NotNull AppMeta appMeta) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)appMeta, (String)"appMeta");
        JSONObject enrichedAttributes = new JSONObject(attributes.toString());
        enrichedAttributes.put("sdkVersion", (Object)String.valueOf(CoreUtils.getSdkVersion()));
        enrichedAttributes.put("os", (Object)"ANDROID");
        enrichedAttributes.put("appVersion", (Object)String.valueOf(appMeta.getVersionCode()));
        enrichedAttributes.put("appVersionName", (Object)appMeta.getVersionName());
        return enrichedAttributes;
    }

    public static final void loadContainerImageBackground(@NotNull Context context, @NotNull SdkInstance sdkInstance, int borderRadius, @NotNull Object src, @NotNull ImageView imageView, boolean isGif) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Logger.log$default((Logger)sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(borderRadius){
            final /* synthetic */ int $borderRadius;
            {
                this.$borderRadius = $borderRadius;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "InApp_7.1.1_Utils loadContainerImageBackground () : will load bitmap. borderRadius: " + this.$borderRadius;
            }
        }), (int)3, null);
        GlobalResources.INSTANCE.getMainThread().post(() -> UtilsKt.loadContainerImageBackground$lambda-0(context, src, sdkInstance, isGif, borderRadius, imageView));
    }

    public static /* synthetic */ void loadContainerImageBackground$default(Context context, SdkInstance sdkInstance, int n, Object object, ImageView imageView, boolean bl, int n2, Object object2) {
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        UtilsKt.loadContainerImageBackground(context, sdkInstance, n, object, imageView, bl);
    }

    public static final int getContainerIdFromCampaignPayload(@NotNull CampaignPayload campaignPayload) {
        int n;
        Intrinsics.checkNotNullParameter((Object)campaignPayload, (String)"campaignPayload");
        try {
            int n2;
            if (campaignPayload.getInAppType() == InAppType.NATIVE) {
                InAppContainer inAppContainer = ((NativeCampaignPayload)campaignPayload).getPrimaryContainer();
                Intrinsics.checkNotNull((Object)inAppContainer);
                n2 = 20000 + inAppContainer.id;
            } else {
                n2 = 20001;
            }
            n = n2;
        }
        catch (Throwable t) {
            Logger.Companion.print$default((Logger.Companion)Logger.Companion, (int)0, null, (Function0)((Function0)new Function0<String>(campaignPayload){
                final /* synthetic */ CampaignPayload $campaignPayload;
                {
                    this.$campaignPayload = $campaignPayload;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "getContainerIdFromCampaignPayload() : " + this.$campaignPayload;
                }
            }), (int)3, null);
            n = -1;
        }
        return n;
    }

    private static final void loadContainerImageBackground$lambda-0(Context $context, Object $src, SdkInstance $sdkInstance, boolean $isGif, int $borderRadius, ImageView $imageView) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$src, (String)"$src");
        Intrinsics.checkNotNullParameter((Object)$sdkInstance, (String)"$sdkInstance");
        Intrinsics.checkNotNullParameter((Object)$imageView, (String)"$imageView");
        try {
            RequestBuilder requestBuilder2;
            RequestManager requestManager = Glide.with((Context)$context);
            Intrinsics.checkNotNullExpressionValue((Object)requestManager, (String)"with(context)");
            RequestManager requestManager2 = requestManager;
            if ($src instanceof Bitmap) {
                Logger.log$default((Logger)$sdkInstance.logger, (int)0, null, (Function0)loadContainerImageBackground.2.requestBuilder.1.INSTANCE, (int)3, null);
                RequestBuilder requestBuilder3 = requestManager2.asBitmap();
                requestBuilder2 = requestBuilder3;
                Intrinsics.checkNotNullExpressionValue((Object)requestBuilder3, (String)"{\n                    sd\u2026itmap()\n                }");
            } else if ($isGif) {
                Logger.log$default((Logger)$sdkInstance.logger, (int)0, null, (Function0)loadContainerImageBackground.2.requestBuilder.2.INSTANCE, (int)3, null);
                RequestBuilder requestBuilder4 = requestManager2.asGif();
                requestBuilder2 = requestBuilder4;
                Intrinsics.checkNotNullExpressionValue((Object)requestBuilder4, (String)"{\n                    sd\u2026asGif()\n                }");
            } else {
                throw new Exception("loadContainerImageBackground(): src type is not supported");
            }
            RequestBuilder requestBuilder5 = requestBuilder2;
            if ($borderRadius > 0) {
                Logger.log$default((Logger)$sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>($borderRadius){
                    final /* synthetic */ int $borderRadius;
                    {
                        this.$borderRadius = $borderRadius;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "InApp_7.1.1_Utils loadContainerImageBackground () : applying borderRadius: " + this.$borderRadius + "px";
                    }
                }), (int)3, null);
                Transformation[] transformationArray = new Transformation[]{(Transformation)new RoundedCorners($borderRadius)};
                BaseRequestOptions baseRequestOptions = requestBuilder5.transform((Transformation)new MultiTransformation(transformationArray));
                Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions, (String)"requestBuilder.transform\u2026      )\n                )");
                requestBuilder5 = (RequestBuilder)baseRequestOptions;
            }
            requestBuilder5.load($src).into($imageView);
            Logger.log$default((Logger)$sdkInstance.logger, (int)0, null, (Function0)loadContainerImageBackground.2.2.INSTANCE, (int)3, null);
        }
        catch (Throwable t) {
            $sdkInstance.logger.log(1, t, (Function0)loadContainerImageBackground.2.3.INSTANCE);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)((Object)ScreenOrientation.PORTRAIT)), TuplesKt.to((Object)2, (Object)((Object)ScreenOrientation.LANDSCAPE))};
        screenOrientationMapper = MapsKt.mapOf((Pair[])pairArray);
    }
}

