/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.engine;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.widget.RelativeLayout;
import androidx.annotation.MainThread;
import androidx.annotation.WorkerThread;
import androidx.core.view.ViewCompat;
import com.moengage.core.internal.global.GlobalCache;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.model.ViewDimension;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.inapp.internal.ActionHandler;
import com.moengage.inapp.internal.InAppInstanceProvider;
import com.moengage.inapp.internal.engine.BaseViewEngine;
import com.moengage.inapp.internal.html.HtmlJavaScriptInterface;
import com.moengage.inapp.internal.html.InAppWebView;
import com.moengage.inapp.internal.html.InAppWebViewClient;
import com.moengage.inapp.internal.model.HtmlCampaignPayload;
import com.moengage.inapp.internal.model.ViewCreationMeta;
import com.moengage.inapp.internal.model.actions.DismissAction;
import com.moengage.inapp.internal.repository.InAppFileManager;
import com.moengage.inapp.model.enums.ActionType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0017J\b\u0010\u0015\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0003J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/moengage/inapp/internal/engine/HtmlViewEngine;", "Lcom/moengage/inapp/internal/engine/BaseViewEngine;", "activity", "Landroid/app/Activity;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "payload", "Lcom/moengage/inapp/internal/model/HtmlCampaignPayload;", "viewCreationMeta", "Lcom/moengage/inapp/internal/model/ViewCreationMeta;", "(Landroid/app/Activity;Lcom/moengage/core/internal/model/SdkInstance;Lcom/moengage/inapp/internal/model/HtmlCampaignPayload;Lcom/moengage/inapp/internal/model/ViewCreationMeta;)V", "inAppView", "Landroid/view/View;", "parentViewDimensions", "Lcom/moengage/core/internal/model/ViewDimension;", "kotlin.jvm.PlatformType", "statusBarHeight", "", "tag", "", "createInApp", "createPrimaryContainer", "createWebView", "", "containerLayout", "Landroid/view/ViewGroup;", "assetsPath", "dismissInApp", "downloadAssets", "", "getBaseUrlPath", "handleBackPress", "setUpWebView", "inapp_release"})
public final class HtmlViewEngine
extends BaseViewEngine {
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final HtmlCampaignPayload payload;
    @NotNull
    private final String tag;
    @Nullable
    private View inAppView;
    private final int statusBarHeight;
    private final ViewDimension parentViewDimensions;

    public HtmlViewEngine(@NotNull Activity activity2, @NotNull SdkInstance sdkInstance, @NotNull HtmlCampaignPayload payload2, @NotNull ViewCreationMeta viewCreationMeta) {
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)payload2, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)viewCreationMeta, (String)"viewCreationMeta");
        super(activity2, payload2, viewCreationMeta);
        this.sdkInstance = sdkInstance;
        this.payload = payload2;
        this.tag = "InApp_7.1.1_HtmlViewEngine";
        this.statusBarHeight = viewCreationMeta.statusBarHeight;
        this.parentViewDimensions = viewCreationMeta.deviceDimensions;
    }

    @Override
    @WorkerThread
    @androidx.annotation.Nullable
    @Nullable
    public View createInApp() {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ HtmlViewEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return HtmlViewEngine.access$getTag$p(this.this$0) + " createInApp() : Will try to create in-app view for campaign-id: " + HtmlViewEngine.access$getPayload$p(this.this$0).getCampaignId();
            }
        }), (int)3, null);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ HtmlViewEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return HtmlViewEngine.access$getTag$p(this.this$0) + " createInApp() : Device Dimensions: " + HtmlViewEngine.access$getParentViewDimensions$p(this.this$0) + ", status bar height: " + HtmlViewEngine.access$getStatusBarHeight$p(this.this$0);
            }
        }), (int)3, null);
        Context context = this.getActivity().getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
        if (!CoreUtils.canUseWebView((Context)context)) {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ HtmlViewEngine this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return HtmlViewEngine.access$getTag$p(this.this$0) + " createInApp() : Web-view cannot be used, either does not exist or is disabled.";
                }
            }), (int)3, null);
            return null;
        }
        if (this.downloadAssets()) {
            this.inAppView = this.createPrimaryContainer();
        }
        return this.inAppView;
    }

    private final boolean downloadAssets() {
        if (this.payload.getHtmlAssets() == null) {
            return true;
        }
        Map<String, String> assets = this.payload.getHtmlAssets().getAssets();
        int count = new InAppFileManager((Context)this.getActivity(), this.sdkInstance).downloadAndSaveHtmlAssets(this.payload.getCampaignId(), assets);
        if (count != assets.size()) {
            this.updateStatForCampaign(this.getCampaignPayload(), "IMP_FILE_DWNLD_FLR", this.sdkInstance);
            Logger.log$default((Logger)this.sdkInstance.logger, (int)1, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ HtmlViewEngine this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return HtmlViewEngine.access$getTag$p(this.this$0) + " downloadAssets() : Assets download failed, cannot show inapp.";
                }
            }), (int)2, null);
            return false;
        }
        return true;
    }

    private final View createPrimaryContainer() {
        RelativeLayout containerLayout = new RelativeLayout((Context)this.getActivity());
        containerLayout.setId(20001);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.parentViewDimensions.width, -1);
        layoutParams.setMargins(0, this.statusBarHeight, 0, 0);
        containerLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.createWebView((ViewGroup)containerLayout, new InAppFileManager((Context)this.getActivity(), this.sdkInstance).getHtmlAssetsPath(this.payload.getCampaignId()));
        this.handleBackPress((View)containerLayout);
        return (View)containerLayout;
    }

    @MainThread
    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private final void createWebView(ViewGroup containerLayout, String assetsPath) {
        this.getActivity().runOnUiThread(() -> HtmlViewEngine.createWebView$lambda-0(this, assetsPath, containerLayout));
    }

    private final String getBaseUrlPath(String assetsPath) {
        return "file://" + assetsPath + '/';
    }

    private final void dismissInApp() {
        View view = this.inAppView;
        if (view == null) {
            return;
        }
        View view2 = view;
        new ActionHandler(this.getActivity(), this.sdkInstance).onActionPerformed(view2, new DismissAction(ActionType.DISMISS), this.payload);
    }

    private final void handleBackPress(View inAppView) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ HtmlViewEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return HtmlViewEngine.access$getTag$p(this.this$0) + " handleBackPress() : ";
            }
        }), (int)3, null);
        inAppView.setClickable(true);
        inAppView.setFocusable(true);
        inAppView.setFocusableInTouchMode(true);
        inAppView.requestFocus();
        inAppView.setOnFocusChangeListener((arg_0, arg_1) -> HtmlViewEngine.handleBackPress$lambda-1(this, arg_0, arg_1));
        inAppView.setOnKeyListener((arg_0, arg_1, arg_2) -> HtmlViewEngine.handleBackPress$lambda-2(this, arg_0, arg_1, arg_2));
    }

    private final void setUpWebView(String assetsPath, ViewGroup containerLayout) {
        try {
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ HtmlViewEngine this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return HtmlViewEngine.access$getTag$p(this.this$0) + " setUpWebView() : will create web view.";
                }
            }), (int)3, null);
            InAppWebView webView = new InAppWebView((Context)this.getActivity());
            webView.setId(ViewCompat.generateViewId());
            WebSettings $this$setUpWebView_u24lambda_u2d3 = webView.getSettings();
            boolean bl = false;
            $this$setUpWebView_u24lambda_u2d3.setJavaScriptEnabled(GlobalCache.INSTANCE.getJsConfig().isJavaScriptEnabled());
            $this$setUpWebView_u24lambda_u2d3.setUseWideViewPort(true);
            $this$setUpWebView_u24lambda_u2d3.setLoadWithOverviewMode(true);
            $this$setUpWebView_u24lambda_u2d3.setDisplayZoomControls(false);
            $this$setUpWebView_u24lambda_u2d3.setDomStorageEnabled(true);
            $this$setUpWebView_u24lambda_u2d3.setAllowFileAccess(true);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            InAppWebView $this$setUpWebView_u24lambda_u2d4 = webView;
            boolean bl2 = false;
            $this$setUpWebView_u24lambda_u2d4.setWebViewClient(new InAppWebViewClient(this.payload));
            $this$setUpWebView_u24lambda_u2d4.addJavascriptInterface(new HtmlJavaScriptInterface(this.getActivity(), this.payload, this.inAppView, this.sdkInstance), "moengageInternal");
            $this$setUpWebView_u24lambda_u2d4.loadDataWithBaseURL(this.getBaseUrlPath(assetsPath), this.payload.getHtmlPayload(), "text/html", "utf-8", null);
            $this$setUpWebView_u24lambda_u2d4.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            $this$setUpWebView_u24lambda_u2d4.setBackgroundColor(0);
            containerLayout.addView((View)webView);
        }
        catch (Throwable t) {
            Logger.Companion.print(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ HtmlViewEngine this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return HtmlViewEngine.access$getTag$p(this.this$0) + " createWebView() : ";
                }
            });
            InAppInstanceProvider.INSTANCE.getCacheForInstance$inapp_release(this.sdkInstance).setHasHtmlCampaignSetupFailed(true);
        }
    }

    private static final void createWebView$lambda-0(HtmlViewEngine this$0, String $assetsPath, ViewGroup $containerLayout) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$assetsPath, (String)"$assetsPath");
        Intrinsics.checkNotNullParameter((Object)$containerLayout, (String)"$containerLayout");
        this$0.setUpWebView($assetsPath, $containerLayout);
    }

    private static final void handleBackPress$lambda-1(HtmlViewEngine this$0, View v, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Logger.log$default((Logger)this$0.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this$0, v, hasFocus){
            final /* synthetic */ HtmlViewEngine this$0;
            final /* synthetic */ View $v;
            final /* synthetic */ boolean $hasFocus;
            {
                this.this$0 = $receiver;
                this.$v = $v;
                this.$hasFocus = $hasFocus;
                super(0);
            }

            @NotNull
            public final String invoke() {
                View view = this.$v.findFocus();
                return HtmlViewEngine.access$getTag$p(this.this$0) + " onFocusChanged() : " + this.$v.getId() + " : " + this.$hasFocus + ' ' + (view != null ? Integer.valueOf(view.getId()) : null);
            }
        }), (int)3, null);
    }

    private static final boolean handleBackPress$lambda-2(HtmlViewEngine this$0, View view, int keyCode, KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            Logger.log$default((Logger)this$0.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this$0, keyCode, event){
                final /* synthetic */ HtmlViewEngine this$0;
                final /* synthetic */ int $keyCode;
                final /* synthetic */ KeyEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$keyCode = $keyCode;
                    this.$event = $event;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return HtmlViewEngine.access$getTag$p(this.this$0) + " inAppView() : onKey() : " + this.$keyCode + ' ' + this.$event.getAction();
                }
            }), (int)3, null);
            if (event.getAction() == 0 && keyCode == 4) {
                Logger.log$default((Logger)this$0.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this$0){
                    final /* synthetic */ HtmlViewEngine this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return HtmlViewEngine.access$getTag$p(this.this$0) + " handleBackPress() : on back button pressed";
                    }
                }), (int)3, null);
                this$0.dismissInApp();
                return true;
            }
        }
        catch (Exception e) {
            this$0.sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this$0){
                final /* synthetic */ HtmlViewEngine this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return HtmlViewEngine.access$getTag$p(this.this$0) + " onKey() : ";
                }
            });
        }
        return false;
    }

    public static final /* synthetic */ String access$getTag$p(HtmlViewEngine $this) {
        return $this.tag;
    }

    public static final /* synthetic */ HtmlCampaignPayload access$getPayload$p(HtmlViewEngine $this) {
        return $this.payload;
    }

    public static final /* synthetic */ ViewDimension access$getParentViewDimensions$p(HtmlViewEngine $this) {
        return $this.parentViewDimensions;
    }

    public static final /* synthetic */ int access$getStatusBarHeight$p(HtmlViewEngine $this) {
        return $this.statusBarHeight;
    }
}

