/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.internal.engine;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.media.MediaPlayer;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.DrawableRes;
import androidx.annotation.GravityInt;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.model.ViewDimension;
import com.moengage.inapp.R;
import com.moengage.inapp.internal.UtilsKt;
import com.moengage.inapp.internal.engine.ViewEngineUtilsKt;
import com.moengage.inapp.internal.exceptions.CouldNotCreateViewException;
import com.moengage.inapp.internal.exceptions.VideoNotFoundException;
import com.moengage.inapp.internal.listeners.OnInAppDisplaySizeChangeListener;
import com.moengage.inapp.internal.listeners.VideoPlaybackListener;
import com.moengage.inapp.internal.model.InAppContainer;
import com.moengage.inapp.internal.model.InAppWidget;
import com.moengage.inapp.internal.model.Margin;
import com.moengage.inapp.internal.model.MediaMeta;
import com.moengage.inapp.internal.model.NativeCampaignPayload;
import com.moengage.inapp.internal.model.Spacing;
import com.moengage.inapp.internal.model.ViewCreationMeta;
import com.moengage.inapp.internal.model.enums.DisplaySize;
import com.moengage.inapp.internal.model.enums.Orientation;
import com.moengage.inapp.internal.model.style.ContainerStyle;
import com.moengage.inapp.internal.model.style.ImageStyle;
import com.moengage.inapp.internal.model.style.InAppStyle;
import com.moengage.inapp.internal.repository.InAppFileManager;
import com.moengage.inapp.internal.widgets.MoEVideoView;
import com.moengage.inapp.model.enums.InAppPosition;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ8\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0002J&\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001eJ&\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u001cJ\u001c\u0010.\u001a\u00020%2\b\b\u0001\u0010/\u001a\u0002002\b\b\u0001\u00101\u001a\u000200H\u0002J\u000e\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u000204J0\u00105\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J0\u00108\u001a\u0002092\u0006\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J0\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020BH\u0002J \u0010C\u001a\u00020\u00162\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020!H\u0002J\u0016\u0010H\u001a\u00020\u00162\u0006\u0010I\u001a\u00020J2\u0006\u0010$\u001a\u00020%J\u0010\u0010K\u001a\u00020\u00162\b\u0010L\u001a\u0004\u0018\u00010\u0012J\u001e\u0010M\u001a\u00020\u00162\u0006\u0010N\u001a\u00020\u00182\u0006\u0010I\u001a\u00020J2\u0006\u0010O\u001a\u00020\u001cJ\u0018\u0010P\u001a\u00020\u00162\u0006\u0010Q\u001a\u00020!2\u0006\u0010R\u001a\u00020EH\u0002J\u0016\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XJ8\u0010Y\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010Z\u001a\u00020\u001c2\u0006\u0010[\u001a\u00020\u001c2\u0006\u0010\\\u001a\u00020\r2\u0006\u0010]\u001a\u00020\u001eH\u0002J(\u0010^\u001a\u00020\u00162\u0006\u0010_\u001a\u00020!2\u0006\u0010Z\u001a\u00020\u001c2\u0006\u0010[\u001a\u00020\u001c2\u0006\u0010\\\u001a\u00020\rH\u0002J\u0010\u0010`\u001a\u00020\u00162\u0006\u0010D\u001a\u00020EH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/moengage/inapp/internal/engine/NudgesViewEngineHelper;", "", "context", "Landroid/content/Context;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "viewCreationMeta", "Lcom/moengage/inapp/internal/model/ViewCreationMeta;", "payload", "Lcom/moengage/inapp/internal/model/NativeCampaignPayload;", "mediaManager", "Lcom/moengage/inapp/internal/repository/InAppFileManager;", "densityScale", "", "(Landroid/content/Context;Lcom/moengage/core/internal/model/SdkInstance;Lcom/moengage/inapp/internal/model/ViewCreationMeta;Lcom/moengage/inapp/internal/model/NativeCampaignPayload;Lcom/moengage/inapp/internal/repository/InAppFileManager;F)V", "mediaPlayer", "Landroid/media/MediaPlayer;", "onInAppDisplaySizeChangeListener", "Lcom/moengage/inapp/internal/listeners/OnInAppDisplaySizeChangeListener;", "tag", "", "attachDisplaySizeControllers", "", "primaryContainer", "Landroid/widget/RelativeLayout;", "mediaContainer", "Landroid/widget/FrameLayout;", "mediaDimension", "Lcom/moengage/core/internal/model/ViewDimension;", "displaySize", "Lcom/moengage/inapp/internal/model/enums/DisplaySize;", "controllerContainer", "mediaView", "Landroid/view/View;", "createContainerForResizeableImageView", "primaryContainerLayout", "imageView", "Landroid/widget/ImageView;", "imageStyle", "Lcom/moengage/inapp/internal/model/style/ImageStyle;", "createVideoView", "widget", "Lcom/moengage/inapp/internal/model/InAppWidget;", "parentOrientation", "Lcom/moengage/inapp/internal/model/enums/Orientation;", "toExclude", "getControllerButton", "gravity", "", "resId", "getFullScreenViewDimension", "primaryContainerStyle", "Lcom/moengage/inapp/internal/model/style/InAppStyle;", "getImageController", "imageContainer", "imageDimension", "getResizeValueAnimator", "Landroid/animation/AnimatorSet;", "getVideoController", "videoView", "Lcom/moengage/inapp/internal/widgets/MoEVideoView;", "videoContainer", "mediaMeta", "Lcom/moengage/inapp/internal/model/MediaMeta;", "getVideoMeta", "uri", "Landroid/net/Uri;", "handleAudioController", "isMute", "", "muteButton", "unmuteButton", "handleBackgroundImageForResizeableNudge", "containerStyle", "Lcom/moengage/inapp/internal/model/style/ContainerStyle;", "setOnInAppDisplaySizeChangeListener", "listener", "setPrimaryContainerDimensions", "containerLayout", "campaignDimensions", "showMediaController", "controllerView", "autoDismiss", "transformMarginForInAppPosition", "Lcom/moengage/inapp/internal/model/Spacing;", "margin", "Lcom/moengage/inapp/internal/model/Margin;", "position", "Lcom/moengage/inapp/model/enums/InAppPosition;", "updateContainerAnimatedDimension", "initialViewDimension", "targetViewDimension", "fraction", "animateToDisplaySize", "updateViewAnimatedDimension", "view", "updateVolume", "inapp_release"})
public final class NudgesViewEngineHelper {
    @NotNull
    private final Context context;
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final ViewCreationMeta viewCreationMeta;
    @NotNull
    private final NativeCampaignPayload payload;
    @NotNull
    private final InAppFileManager mediaManager;
    private final float densityScale;
    @NotNull
    private final String tag;
    private MediaPlayer mediaPlayer;
    @Nullable
    private OnInAppDisplaySizeChangeListener onInAppDisplaySizeChangeListener;

    public NudgesViewEngineHelper(@NotNull Context context, @NotNull SdkInstance sdkInstance, @NotNull ViewCreationMeta viewCreationMeta, @NotNull NativeCampaignPayload payload2, @NotNull InAppFileManager mediaManager, float densityScale) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        Intrinsics.checkNotNullParameter((Object)viewCreationMeta, (String)"viewCreationMeta");
        Intrinsics.checkNotNullParameter((Object)payload2, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)mediaManager, (String)"mediaManager");
        this.context = context;
        this.sdkInstance = sdkInstance;
        this.viewCreationMeta = viewCreationMeta;
        this.payload = payload2;
        this.mediaManager = mediaManager;
        this.densityScale = densityScale;
        this.tag = "InApp_7.1.2_NudgesViewEngineHelper";
    }

    @NotNull
    public final Spacing transformMarginForInAppPosition(@NotNull Margin margin, @NotNull InAppPosition position) throws CouldNotCreateViewException {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)margin, (String)"margin");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        ViewDimension viewDimension = this.viewCreationMeta.deviceDimensions;
        Intrinsics.checkNotNullExpressionValue((Object)viewDimension, (String)"viewCreationMeta.deviceDimensions");
        Spacing transformedMargin = ViewEngineUtilsKt.transformMargin(this.sdkInstance, viewDimension, margin);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, position){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ InAppPosition $position;
            {
                this.this$0 = $receiver;
                this.$position = $position;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " transformMarginForInAppPosition() : Position: " + (Object)((Object)this.$position);
            }
        }), (int)3, null);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " transformMarginForInAppPosition() : viewCreationMeta: " + NudgesViewEngineHelper.access$getViewCreationMeta$p(this.this$0);
            }
        }), (int)3, null);
        switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
            case 1: {
                spacing = new Spacing(transformedMargin.left, transformedMargin.right, transformedMargin.top + this.viewCreationMeta.statusBarHeight, transformedMargin.bottom);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                spacing = new Spacing(transformedMargin.left, transformedMargin.right, transformedMargin.top, transformedMargin.bottom + this.viewCreationMeta.navigationBarHeight);
                break;
            }
            default: {
                throw new CouldNotCreateViewException("Unsupported InApp position: " + (Object)((Object)position));
            }
        }
        return spacing;
    }

    @NotNull
    public final View createVideoView(@NotNull InAppWidget widget, @NotNull Orientation parentOrientation, @NotNull RelativeLayout primaryContainerLayout, @NotNull ViewDimension toExclude) throws CouldNotCreateViewException, VideoNotFoundException {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)((Object)parentOrientation), (String)"parentOrientation");
        Intrinsics.checkNotNullParameter((Object)primaryContainerLayout, (String)"primaryContainerLayout");
        Intrinsics.checkNotNullParameter((Object)toExclude, (String)"toExclude");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, widget){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ InAppWidget $widget;
            {
                this.this$0 = $receiver;
                this.$widget = $widget;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createVideoView() : Will create this widget: " + this.$widget;
            }
        }), (int)3, null);
        InAppContainer inAppContainer = this.payload.getPrimaryContainer();
        if (inAppContainer == null) {
            throw new CouldNotCreateViewException("Primary container is not defined.");
        }
        InAppContainer primaryContainer = inAppContainer;
        InAppStyle inAppStyle = primaryContainer.style;
        Intrinsics.checkNotNull((Object)inAppStyle, (String)"null cannot be cast to non-null type com.moengage.inapp.internal.model.style.ContainerStyle");
        ContainerStyle primaryContainerStyle = (ContainerStyle)inAppStyle;
        if (primaryContainerStyle.displaySize == null) {
            throw new CouldNotCreateViewException("'displaySize' is not defined for primary container.");
        }
        FrameLayout videoContainer = new FrameLayout(this.context);
        MoEVideoView videoView = new MoEVideoView(this.context);
        String string = widget.component.content;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"widget.component.content");
        Uri uri = this.mediaManager.getVideoFromUrl(string, this.payload.getCampaignId());
        if (uri == null) {
            throw new VideoNotFoundException("Error while fetching video from url: " + widget.component.content);
        }
        Uri videoUri = uri;
        videoView.setVideoURI(videoUri);
        MediaMeta mediaMeta = this.getVideoMeta(videoUri);
        ViewDimension viewDimension = this.viewCreationMeta.deviceDimensions;
        Intrinsics.checkNotNullExpressionValue((Object)viewDimension, (String)"viewCreationMeta.deviceDimensions");
        ViewDimension campaignViewDimension = ViewEngineUtilsKt.getViewDimensionsFromPercentage(viewDimension, primaryContainerStyle);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, campaignViewDimension){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ ViewDimension $campaignViewDimension;
            {
                this.this$0 = $receiver;
                this.$campaignViewDimension = $campaignViewDimension;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createVideoView(): Campaign Dimension: " + this.$campaignViewDimension;
            }
        }), (int)3, null);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, mediaMeta){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ MediaMeta $mediaMeta;
            {
                this.this$0 = $receiver;
                this.$mediaMeta = $mediaMeta;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createVideoView(): Video Dimension: " + this.$mediaMeta.getDimension();
            }
        }), (int)3, null);
        DisplaySize displaySize = primaryContainerStyle.displaySize;
        switch (displaySize == null ? -1 : WhenMappings.$EnumSwitchMapping$1[displaySize.ordinal()]) {
            case 1: {
                ViewDimension fullScreenDimension = this.getFullScreenViewDimension(primaryContainerStyle);
                Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, fullScreenDimension){
                    final /* synthetic */ NudgesViewEngineHelper this$0;
                    final /* synthetic */ ViewDimension $fullScreenDimension;
                    {
                        this.this$0 = $receiver;
                        this.$fullScreenDimension = $fullScreenDimension;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createVideoView(): fullScreen dimension: " + this.$fullScreenDimension;
                    }
                }), (int)3, null);
                campaignViewDimension.width = fullScreenDimension.width;
                campaignViewDimension.height = mediaMeta.getDimension().height * campaignViewDimension.width / mediaMeta.getDimension().width;
                break;
            }
            case 2: {
                campaignViewDimension.height = mediaMeta.getDimension().height * campaignViewDimension.width / mediaMeta.getDimension().width;
            }
        }
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, campaignViewDimension){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ ViewDimension $campaignViewDimension;
            {
                this.this$0 = $receiver;
                this.$campaignViewDimension = $campaignViewDimension;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createVideoView(): final computed dimension: " + this.$campaignViewDimension;
            }
        }), (int)3, null);
        campaignViewDimension.width -= toExclude.width;
        FrameLayout.LayoutParams videoViewLayoutParams = new FrameLayout.LayoutParams(campaignViewDimension.width, campaignViewDimension.height);
        videoViewLayoutParams.gravity = 17;
        videoView.setLayoutParams((ViewGroup.LayoutParams)videoViewLayoutParams);
        videoContainer.addView((View)videoView);
        DisplaySize displaySize2 = primaryContainerStyle.displaySize;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)displaySize2), (String)"primaryContainerStyle.displaySize");
        FrameLayout controllerLayout = this.getVideoController(videoView, primaryContainerLayout, videoContainer, mediaMeta, displaySize2);
        videoView.setOnPreparedListener(arg_0 -> NudgesViewEngineHelper.createVideoView$lambda-0(this, mediaMeta, controllerLayout, primaryContainerStyle, videoView, arg_0));
        videoView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(this, videoView){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ MoEVideoView $videoView;
            {
                this.this$0 = $receiver;
                this.$videoView = $videoView;
            }

            public void onViewAttachedToWindow(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Logger.log$default((Logger)NudgesViewEngineHelper.access$getSdkInstance$p((NudgesViewEngineHelper)this.this$0).logger, (int)0, null, (Function0)((Function0)new Function0<String>(this.this$0){
                    final /* synthetic */ NudgesViewEngineHelper this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createVideoView(): view attached to window now playing video";
                    }
                }), (int)3, null);
                this.$videoView.start();
            }

            public void onViewDetachedFromWindow(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Logger.log$default((Logger)NudgesViewEngineHelper.access$getSdkInstance$p((NudgesViewEngineHelper)this.this$0).logger, (int)0, null, (Function0)((Function0)new Function0<String>(this.this$0){
                    final /* synthetic */ NudgesViewEngineHelper this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createVideoView(): view detached from window now pausing video";
                    }
                }), (int)3, null);
                this.$videoView.pause();
            }
        });
        videoContainer.setOnClickListener(arg_0 -> NudgesViewEngineHelper.createVideoView$lambda-1(this, controllerLayout, arg_0));
        videoView.setOnCompletionListener(arg_0 -> NudgesViewEngineHelper.createVideoView$lambda-2(videoView, this, controllerLayout, arg_0));
        videoContainer.addView((View)controllerLayout);
        LinearLayout.LayoutParams videoContainerParams = new LinearLayout.LayoutParams(-1, -2);
        videoContainerParams.weight = 0.9f;
        ViewEngineUtilsKt.setLayoutGravity(videoContainerParams, parentOrientation);
        videoContainer.setLayoutParams((ViewGroup.LayoutParams)videoContainerParams);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, widget){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ InAppWidget $widget;
            {
                this.this$0 = $receiver;
                this.$widget = $widget;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createVideoView() : created widget: " + this.$widget;
            }
        }), (int)3, null);
        return (View)videoContainer;
    }

    private final FrameLayout getVideoController(MoEVideoView videoView, RelativeLayout primaryContainer, FrameLayout videoContainer, MediaMeta mediaMeta, DisplaySize displaySize) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getVideoController() : Will create video controller";
            }
        }), (int)3, null);
        FrameLayout controllerContainer = new FrameLayout(this.context);
        ImageView playButton = this.getControllerButton(17, R.drawable.moengage_inapp_play);
        playButton.setOnClickListener(arg_0 -> NudgesViewEngineHelper.getVideoController$lambda-3(videoView, arg_0));
        playButton.setVisibility(8);
        controllerContainer.addView((View)playButton);
        ImageView pauseButton = this.getControllerButton(17, R.drawable.moengage_inapp_pause);
        pauseButton.setOnClickListener(arg_0 -> NudgesViewEngineHelper.getVideoController$lambda-4(videoView, arg_0));
        pauseButton.setVisibility(8);
        controllerContainer.addView((View)pauseButton);
        videoView.setVideoPlaybackListener(new VideoPlaybackListener(videoView, playButton, pauseButton){
            final /* synthetic */ MoEVideoView $videoView;
            final /* synthetic */ ImageView $playButton;
            final /* synthetic */ ImageView $pauseButton;
            {
                this.$videoView = $videoView;
                this.$playButton = $playButton;
                this.$pauseButton = $pauseButton;
            }

            public void onStart() {
                if (!this.$videoView.isPlaying()) {
                    return;
                }
                this.$playButton.setVisibility(8);
                this.$pauseButton.setVisibility(0);
            }

            public void onPause() {
                if (this.$videoView.isPlaying()) {
                    return;
                }
                this.$pauseButton.setVisibility(8);
                this.$playButton.setVisibility(0);
            }
        });
        if (mediaMeta.getHasAudio()) {
            ImageView muteButton = this.getControllerButton(8388691, R.drawable.moengage_inapp_mute);
            ImageView unmuteButton = this.getControllerButton(8388691, R.drawable.moengage_inapp_unmute);
            muteButton.setOnClickListener(arg_0 -> NudgesViewEngineHelper.getVideoController$lambda-5(this, muteButton, unmuteButton, arg_0));
            unmuteButton.setOnClickListener(arg_0 -> NudgesViewEngineHelper.getVideoController$lambda-6(this, muteButton, unmuteButton, arg_0));
            controllerContainer.addView((View)muteButton);
            controllerContainer.addView((View)unmuteButton);
            this.handleAudioController(false, (View)muteButton, (View)unmuteButton);
        }
        this.attachDisplaySizeControllers(primaryContainer, videoContainer, mediaMeta.getDimension(), displaySize, controllerContainer, (View)videoView);
        FrameLayout.LayoutParams controllerContainerLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        controllerContainerLayoutParams.gravity = 17;
        controllerContainer.setLayoutParams((ViewGroup.LayoutParams)controllerContainerLayoutParams);
        controllerContainer.setVisibility(8);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getVideoController() : completed";
            }
        }), (int)3, null);
        return controllerContainer;
    }

    @NotNull
    public final FrameLayout createContainerForResizeableImageView(@NotNull RelativeLayout primaryContainerLayout, @NotNull ImageView imageView, @NotNull ImageStyle imageStyle, @NotNull DisplaySize displaySize) {
        Intrinsics.checkNotNullParameter((Object)primaryContainerLayout, (String)"primaryContainerLayout");
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)imageStyle, (String)"imageStyle");
        Intrinsics.checkNotNullParameter((Object)((Object)displaySize), (String)"displaySize");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createContainerForResizeableImageView() : will create image view";
            }
        }), (int)3, null);
        FrameLayout imageViewContainer = new FrameLayout(this.context);
        imageViewContainer.addView((View)imageView);
        FrameLayout mediaController = this.getImageController(primaryContainerLayout, imageViewContainer, new ViewDimension((int)imageStyle.realWidth, (int)imageStyle.realHeight), displaySize, imageView);
        imageViewContainer.addView((View)mediaController);
        imageViewContainer.setOnClickListener(arg_0 -> NudgesViewEngineHelper.createContainerForResizeableImageView$lambda-7(this, mediaController, arg_0));
        this.showMediaController((View)mediaController, true);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createContainerForResizeableImageView() : completed";
            }
        }), (int)3, null);
        return imageViewContainer;
    }

    private final FrameLayout getImageController(RelativeLayout primaryContainer, FrameLayout imageContainer, ViewDimension imageDimension, DisplaySize displaySize, ImageView imageView) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createImageController(): Will create the image/gif controller";
            }
        }), (int)3, null);
        FrameLayout controllerContainer = new FrameLayout(this.context);
        this.attachDisplaySizeControllers(primaryContainer, imageContainer, imageDimension, displaySize, controllerContainer, (View)imageView);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        controllerContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        controllerContainer.setVisibility(8);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createImageController(): Will create the image/gif controller";
            }
        }), (int)3, null);
        return controllerContainer;
    }

    private final void attachDisplaySizeControllers(RelativeLayout primaryContainer, FrameLayout mediaContainer, ViewDimension mediaDimension, DisplaySize displaySize, FrameLayout controllerContainer, View mediaView) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " addScreenControllers(): Will try to add displaySize controllers to media controller";
            }
        }), (int)3, null);
        ImageView fullscreenController = this.getControllerButton(0x800055, R.drawable.moengage_inapp_fullscreen);
        ImageView minimiseController = this.getControllerButton(0x800055, R.drawable.moengage_inapp_minimise);
        fullscreenController.setOnClickListener(arg_0 -> NudgesViewEngineHelper.attachDisplaySizeControllers$lambda-8(this, primaryContainer, mediaContainer, mediaDimension, mediaView, fullscreenController, minimiseController, arg_0));
        controllerContainer.addView((View)fullscreenController);
        minimiseController.setOnClickListener(arg_0 -> NudgesViewEngineHelper.attachDisplaySizeControllers$lambda-9(this, primaryContainer, mediaContainer, mediaDimension, mediaView, minimiseController, fullscreenController, arg_0));
        controllerContainer.addView((View)minimiseController);
        switch (WhenMappings.$EnumSwitchMapping$1[displaySize.ordinal()]) {
            case 1: {
                minimiseController.setVisibility(0);
                fullscreenController.setVisibility(8);
                break;
            }
            case 2: {
                minimiseController.setVisibility(8);
                fullscreenController.setVisibility(0);
            }
        }
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, displaySize){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ DisplaySize $displaySize;
            {
                this.this$0 = $receiver;
                this.$displaySize = $displaySize;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " addScreenControllers(): displaySize controllers added successfully. Default displaySize: " + (Object)((Object)this.$displaySize);
            }
        }), (int)3, null);
    }

    private final AnimatorSet getResizeValueAnimator(RelativeLayout primaryContainerLayout, FrameLayout mediaContainer, ViewDimension mediaDimension, DisplaySize displaySize, View mediaView) throws CouldNotCreateViewException {
        ViewDimension viewDimension;
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, displaySize){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ DisplaySize $displaySize;
            {
                this.this$0 = $receiver;
                this.$displaySize = $displaySize;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getResizeValueAnimator(): will try build animator according to displaySize=" + (Object)((Object)this.$displaySize);
            }
        }), (int)3, null);
        InAppContainer inAppContainer = this.payload.getPrimaryContainer();
        if (inAppContainer == null) {
            throw new CouldNotCreateViewException("primary container not defined");
        }
        InAppContainer primaryContainer = inAppContainer;
        ViewDimension initialContainerDimension = new ViewDimension(primaryContainerLayout.getLayoutParams().width, primaryContainerLayout.getLayoutParams().height);
        if (initialContainerDimension.height == -2) {
            initialContainerDimension.height = UtilsKt.getUnspecifiedViewDimension((View)((View)primaryContainerLayout)).height;
        }
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, initialContainerDimension){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ ViewDimension $initialContainerDimension;
            {
                this.this$0 = $receiver;
                this.$initialContainerDimension = $initialContainerDimension;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getResizeValueAnimator(): initial view dimension=" + this.$initialContainerDimension;
            }
        }), (int)3, null);
        InAppStyle inAppStyle = primaryContainer.style;
        Intrinsics.checkNotNullExpressionValue((Object)inAppStyle, (String)"primaryContainer.style");
        ViewDimension fullScreenMediaDimension = this.getFullScreenViewDimension(inAppStyle);
        fullScreenMediaDimension.height = mediaDimension.height * fullScreenMediaDimension.width / mediaDimension.width;
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, fullScreenMediaDimension){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ ViewDimension $fullScreenMediaDimension;
            {
                this.this$0 = $receiver;
                this.$fullScreenMediaDimension = $fullScreenMediaDimension;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getResizeValueAnimator(): fullscreen video dimension=" + this.$fullScreenMediaDimension;
            }
        }), (int)3, null);
        ViewDimension viewDimension2 = this.viewCreationMeta.deviceDimensions;
        Intrinsics.checkNotNullExpressionValue((Object)viewDimension2, (String)"viewCreationMeta.deviceDimensions");
        InAppStyle inAppStyle2 = primaryContainer.style;
        Intrinsics.checkNotNullExpressionValue((Object)inAppStyle2, (String)"primaryContainer.style");
        ViewDimension minimisedMediaDimension = ViewEngineUtilsKt.getViewDimensionsFromPercentage(viewDimension2, inAppStyle2);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, minimisedMediaDimension){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ ViewDimension $minimisedMediaDimension;
            {
                this.this$0 = $receiver;
                this.$minimisedMediaDimension = $minimisedMediaDimension;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getResizeValueAnimator(): minimised video dimension=" + this.$minimisedMediaDimension;
            }
        }), (int)3, null);
        minimisedMediaDimension.height = mediaDimension.height * minimisedMediaDimension.width / mediaDimension.width;
        switch (WhenMappings.$EnumSwitchMapping$1[displaySize.ordinal()]) {
            case 1: {
                InAppStyle inAppStyle3 = primaryContainer.style;
                Intrinsics.checkNotNullExpressionValue((Object)inAppStyle3, (String)"primaryContainer.style");
                viewDimension = this.getFullScreenViewDimension(inAppStyle3);
                break;
            }
            case 2: {
                ViewDimension viewDimension3 = this.viewCreationMeta.deviceDimensions;
                Intrinsics.checkNotNullExpressionValue((Object)viewDimension3, (String)"viewCreationMeta.deviceDimensions");
                InAppStyle inAppStyle4 = primaryContainer.style;
                Intrinsics.checkNotNullExpressionValue((Object)inAppStyle4, (String)"primaryContainer.style");
                viewDimension = ViewEngineUtilsKt.getViewDimensionsFromPercentage(viewDimension3, inAppStyle4);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ViewDimension targetContainerDimension = viewDimension;
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, targetContainerDimension){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ ViewDimension $targetContainerDimension;
            {
                this.this$0 = $receiver;
                this.$targetContainerDimension = $targetContainerDimension;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getResizeValueAnimator(): target view dimension=" + this.$targetContainerDimension;
            }
        }), (int)3, null);
        float[] fArray = new float[]{0.0f, 1.0f};
        ValueAnimator containerValueAnimator = ValueAnimator.ofFloat((float[])fArray);
        containerValueAnimator.addUpdateListener(arg_0 -> NudgesViewEngineHelper.getResizeValueAnimator$lambda-10(this, primaryContainerLayout, mediaContainer, initialContainerDimension, targetContainerDimension, displaySize, arg_0));
        float[] fArray2 = new float[]{0.0f, 1.0f};
        ValueAnimator videoValueAnimator = ValueAnimator.ofFloat((float[])fArray2);
        videoValueAnimator.addUpdateListener(arg_0 -> NudgesViewEngineHelper.getResizeValueAnimator$lambda-11(displaySize, this, mediaView, minimisedMediaDimension, fullScreenMediaDimension, arg_0));
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getResizeValueAnimator(): completed";
            }
        }), (int)3, null);
        AnimatorSet animatorSet = new AnimatorSet();
        Animator[] animatorArray = new Animator[]{(Animator)containerValueAnimator, (Animator)videoValueAnimator};
        animatorSet.playTogether(animatorArray);
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animatorSet.setDuration(300L);
        return animatorSet;
    }

    private final void updateContainerAnimatedDimension(RelativeLayout primaryContainer, FrameLayout mediaContainer, ViewDimension initialViewDimension, ViewDimension targetViewDimension, float fraction, DisplaySize animateToDisplaySize) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, fraction, animateToDisplaySize){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ float $fraction;
            final /* synthetic */ DisplaySize $animateToDisplaySize;
            {
                this.this$0 = $receiver;
                this.$fraction = $fraction;
                this.$animateToDisplaySize = $animateToDisplaySize;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " updateContainerAnimatedDimension(): will update the dimension for fraction=" + this.$fraction + " and animating to displaySize: " + (Object)((Object)this.$animateToDisplaySize);
            }
        }), (int)3, null);
        int currentWidth = (int)((float)initialViewDimension.width + (float)(targetViewDimension.width - initialViewDimension.width) * fraction);
        int currentHeight = (int)((float)initialViewDimension.height + (float)(targetViewDimension.height - initialViewDimension.height) * fraction);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, currentWidth, currentHeight){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ int $currentWidth;
            final /* synthetic */ int $currentHeight;
            {
                this.this$0 = $receiver;
                this.$currentWidth = $currentWidth;
                this.$currentHeight = $currentHeight;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " updateContainerAnimatedDimension(): currentWidth= " + this.$currentWidth + " currentHeight=" + this.$currentHeight;
            }
        }), (int)3, null);
        ViewGroup.LayoutParams mediaContainerLayoutParams = mediaContainer.getLayoutParams();
        mediaContainerLayoutParams.width = currentWidth;
        mediaContainerLayoutParams.height = currentHeight;
        ViewParent viewParent = mediaContainer.getParent();
        Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
        View mediaParent = (View)viewParent;
        ViewGroup.LayoutParams mediaParentLayoutParams = mediaParent.getLayoutParams();
        mediaParentLayoutParams.width = currentWidth;
        mediaParentLayoutParams.height = animateToDisplaySize == DisplaySize.FULLSCREEN ? currentHeight : -2;
        ViewGroup.LayoutParams primaryContainerLayoutParams = primaryContainer.getLayoutParams();
        primaryContainerLayoutParams.width = currentWidth;
        primaryContainerLayoutParams.height = animateToDisplaySize == DisplaySize.FULLSCREEN ? currentHeight : -2;
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, fraction, animateToDisplaySize){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ float $fraction;
            final /* synthetic */ DisplaySize $animateToDisplaySize;
            {
                this.this$0 = $receiver;
                this.$fraction = $fraction;
                this.$animateToDisplaySize = $animateToDisplaySize;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " updateContainerAnimatedDimension(): updated dimensions for fraction=" + this.$fraction + " and animating to displaySize: " + (Object)((Object)this.$animateToDisplaySize);
            }
        }), (int)3, null);
    }

    private final void showMediaController(View controllerView, boolean autoDismiss) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " showMediaController(): ";
            }
        }), (int)3, null);
        if (controllerView.getVisibility() == 0) {
            return;
        }
        Animation fadeInAnimation = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.fade_in);
        fadeInAnimation.setDuration(300L);
        fadeInAnimation.setFillAfter(true);
        controllerView.setAnimation(fadeInAnimation);
        controllerView.setVisibility(0);
        if (autoDismiss) {
            try {
                controllerView.postDelayed(() -> NudgesViewEngineHelper.showMediaController$lambda-12(controllerView, this), 1500L);
            }
            catch (Throwable t) {
                this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                    final /* synthetic */ NudgesViewEngineHelper this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " showMediaController(): ";
                    }
                });
            }
        }
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " showMediaController(): completed";
            }
        }), (int)3, null);
    }

    @NotNull
    public final ViewDimension getFullScreenViewDimension(@NotNull InAppStyle primaryContainerStyle) {
        Intrinsics.checkNotNullParameter((Object)primaryContainerStyle, (String)"primaryContainerStyle");
        ViewDimension viewDimension = this.viewCreationMeta.deviceDimensions;
        Intrinsics.checkNotNullExpressionValue((Object)viewDimension, (String)"viewCreationMeta.deviceDimensions");
        Margin margin = primaryContainerStyle.margin;
        Intrinsics.checkNotNullExpressionValue((Object)margin, (String)"primaryContainerStyle.margin");
        Spacing spacingMargin = ViewEngineUtilsKt.transformMargin(this.sdkInstance, viewDimension, margin);
        return new ViewDimension(this.viewCreationMeta.deviceDimensions.width - spacingMargin.left - spacingMargin.right, this.viewCreationMeta.deviceDimensions.height - spacingMargin.top - spacingMargin.bottom - this.viewCreationMeta.statusBarHeight);
    }

    private final ImageView getControllerButton(@GravityInt int gravity, @DrawableRes int resId) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getControllerButton() : ";
            }
        }), (int)3, null);
        Bitmap imageBitmap = ViewEngineUtilsKt.generateBitmapFromRes(this.sdkInstance, this.context, resId);
        if (!(imageBitmap != null)) {
            boolean $i$a$-check-NudgesViewEngineHelper$getControllerButton$32 = false;
            String $i$a$-check-NudgesViewEngineHelper$getControllerButton$32 = "getControllerButton() : Couldn't create controller button, imageBitmap is null.";
            throw new IllegalStateException($i$a$-check-NudgesViewEngineHelper$getControllerButton$32.toString());
        }
        ImageView imageView = new ImageView(this.context);
        int dimension = (int)((float)48 * this.densityScale);
        ViewDimension imageDimension = new ViewDimension(dimension, dimension);
        imageView.setImageBitmap(imageBitmap);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(imageDimension.width, imageDimension.height);
        layoutParams.gravity = gravity;
        int padding = (int)((float)8 * this.densityScale);
        imageView.setPadding(padding, padding, padding, padding);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setClickable(true);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getControllerButton() : completed";
            }
        }), (int)3, null);
        return imageView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MediaMeta getVideoMeta(Uri uri) throws CouldNotCreateViewException {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getVideoMeta() : ";
            }
        }), (int)3, null);
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        try {
            mediaMetadataRetriever.setDataSource(this.context, uri);
            String string = mediaMetadataRetriever.extractMetadata(18);
            if (string == null) {
                throw new CouldNotCreateViewException("unable to parse video width");
            }
            String videoWidth = string;
            String string2 = mediaMetadataRetriever.extractMetadata(19);
            if (string2 == null) {
                throw new CouldNotCreateViewException("unable to parse video height");
            }
            String videoHeight = string2;
            String string3 = mediaMetadataRetriever.extractMetadata(16);
            boolean hasAudio = string3 != null ? StringsKt.equals((String)string3, (String)"yes", (boolean)true) : false;
            MediaMeta metadata = new MediaMeta(new ViewDimension(Integer.parseInt(videoWidth), Integer.parseInt(videoHeight)), hasAudio);
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, metadata){
                final /* synthetic */ NudgesViewEngineHelper this$0;
                final /* synthetic */ MediaMeta $metadata;
                {
                    this.this$0 = $receiver;
                    this.$metadata = $metadata;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " getVideoMeta() : metadata: " + this.$metadata;
                }
            }), (int)3, null);
            MediaMeta mediaMeta = metadata;
            return mediaMeta;
        }
        catch (Throwable t) {
            this.sdkInstance.logger.log(1, t, (Function0)new Function0<String>(this){
                final /* synthetic */ NudgesViewEngineHelper this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " unable to fetch video dimensions";
                }
            });
            throw new CouldNotCreateViewException("unable to fetch video dimensions");
        }
        finally {
            mediaMetadataRetriever.release();
        }
    }

    private final void updateVolume(boolean isMute) {
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, isMute){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ boolean $isMute;
            {
                this.this$0 = $receiver;
                this.$isMute = $isMute;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " setVolume(): will try to update the media state to isMute=" + this.$isMute;
            }
        }), (int)3, null);
        MediaPlayer mediaPlayer = this.mediaPlayer;
        if (mediaPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaPlayer");
            mediaPlayer = null;
        }
        if (isMute) {
            MediaPlayer mediaPlayer2 = this.mediaPlayer;
            if (mediaPlayer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mediaPlayer");
                mediaPlayer2 = null;
            }
            mediaPlayer2.setVolume(0.0f, 0.0f);
        } else {
            MediaPlayer mediaPlayer3 = this.mediaPlayer;
            if (mediaPlayer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mediaPlayer");
                mediaPlayer3 = null;
            }
            mediaPlayer3.setVolume(1.0f, 1.0f);
        }
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, isMute){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ boolean $isMute;
            {
                this.this$0 = $receiver;
                this.$isMute = $isMute;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " setVolume(): updated media state to isMute=" + this.$isMute;
            }
        }), (int)3, null);
    }

    private final void handleAudioController(boolean isMute, View muteButton, View unmuteButton) {
        if (isMute) {
            muteButton.setVisibility(8);
            unmuteButton.setVisibility(0);
        } else {
            muteButton.setVisibility(0);
            unmuteButton.setVisibility(8);
        }
    }

    public final void setPrimaryContainerDimensions(@NotNull RelativeLayout containerLayout, @NotNull ContainerStyle containerStyle, @NotNull ViewDimension campaignDimensions) throws CouldNotCreateViewException {
        Intrinsics.checkNotNullParameter((Object)containerLayout, (String)"containerLayout");
        Intrinsics.checkNotNullParameter((Object)containerStyle, (String)"containerStyle");
        Intrinsics.checkNotNullParameter((Object)campaignDimensions, (String)"campaignDimensions");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " setPrimaryContainerDimensions() : will set primary container dimensions for nudges.";
            }
        }), (int)3, null);
        FrameLayout.LayoutParams nudgeLayoutParams = null;
        DisplaySize displaySize = containerStyle.displaySize;
        if ((displaySize == null ? -1 : WhenMappings.$EnumSwitchMapping$1[displaySize.ordinal()]) == 1) {
            ViewDimension fullScreenDimension = this.getFullScreenViewDimension(containerStyle);
            Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, fullScreenDimension){
                final /* synthetic */ NudgesViewEngineHelper this$0;
                final /* synthetic */ ViewDimension $fullScreenDimension;
                {
                    this.this$0 = $receiver;
                    this.$fullScreenDimension = $fullScreenDimension;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " setPrimaryContainerDimensions() : fullScreen dimension: " + this.$fullScreenDimension;
                }
            }), (int)3, null);
            campaignDimensions.width = fullScreenDimension.width;
            campaignDimensions.height = fullScreenDimension.height;
            nudgeLayoutParams = new FrameLayout.LayoutParams(campaignDimensions.width, -1);
        } else {
            nudgeLayoutParams = new FrameLayout.LayoutParams(campaignDimensions.width, -2);
        }
        Margin margin = containerStyle.margin;
        Intrinsics.checkNotNullExpressionValue((Object)margin, (String)"containerStyle.margin");
        Spacing spacingMargin = this.transformMarginForInAppPosition(margin, this.payload.getPosition());
        ViewEngineUtilsKt.setLayoutGravity(this.sdkInstance, nudgeLayoutParams, this.payload.getPosition());
        DisplaySize displaySize2 = containerStyle.displaySize;
        switch (displaySize2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[displaySize2.ordinal()]) {
            case 1: {
                nudgeLayoutParams.gravity |= 0x30;
                nudgeLayoutParams.setMargins(spacingMargin.left, spacingMargin.top + this.viewCreationMeta.statusBarHeight, spacingMargin.right, spacingMargin.bottom);
                break;
            }
            case 2: {
                nudgeLayoutParams.setMargins(spacingMargin.left, spacingMargin.top + this.viewCreationMeta.statusBarHeight, spacingMargin.right, spacingMargin.bottom);
                break;
            }
            default: {
                nudgeLayoutParams.setMargins(spacingMargin.left, spacingMargin.top, spacingMargin.right, spacingMargin.bottom);
            }
        }
        containerLayout.setLayoutParams((ViewGroup.LayoutParams)nudgeLayoutParams);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " setPrimaryContainerDimensions() : ";
            }
        }), (int)3, null);
    }

    private final void updateViewAnimatedDimension(View view, ViewDimension initialViewDimension, ViewDimension targetViewDimension, float fraction) {
        int currentWidth = (int)((float)initialViewDimension.width + (float)(targetViewDimension.width - initialViewDimension.width) * fraction);
        int currentHeight = (int)((float)initialViewDimension.height + (float)(targetViewDimension.height - initialViewDimension.height) * fraction);
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this, currentWidth, currentHeight){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ int $currentWidth;
            final /* synthetic */ int $currentHeight;
            {
                this.this$0 = $receiver;
                this.$currentWidth = $currentWidth;
                this.$currentHeight = $currentHeight;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " updateViewAnimatedDimension(): currentWidth= " + this.$currentWidth + " currentHeight=" + this.$currentHeight;
            }
        }), (int)3, null);
        ViewGroup.LayoutParams viewLayoutParams = view.getLayoutParams();
        viewLayoutParams.width = currentWidth;
        viewLayoutParams.height = currentHeight;
        view.setLayoutParams(viewLayoutParams);
    }

    public final void setOnInAppDisplaySizeChangeListener(@Nullable OnInAppDisplaySizeChangeListener listener) {
        this.onInAppDisplaySizeChangeListener = listener;
    }

    public final void handleBackgroundImageForResizeableNudge(@NotNull ContainerStyle containerStyle, @NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)containerStyle, (String)"containerStyle");
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " handleBackgroundImageForResizeableNudge() : ";
            }
        }), (int)3, null);
        if (containerStyle.displaySize == DisplaySize.MINIMISED) {
            imageView.setVisibility(8);
        }
        this.setOnInAppDisplaySizeChangeListener(new OnInAppDisplaySizeChangeListener(this, imageView){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ ImageView $imageView;
            {
                this.this$0 = $receiver;
                this.$imageView = $imageView;
            }

            public void onDisplaySizeChangeEnd(@NotNull DisplaySize currentDisplaySize) {
                Intrinsics.checkNotNullParameter((Object)((Object)currentDisplaySize), (String)"currentDisplaySize");
                Logger.log$default((Logger)NudgesViewEngineHelper.access$getSdkInstance$p((NudgesViewEngineHelper)this.this$0).logger, (int)0, null, (Function0)((Function0)new Function0<String>(this.this$0, currentDisplaySize){
                    final /* synthetic */ NudgesViewEngineHelper this$0;
                    final /* synthetic */ DisplaySize $currentDisplaySize;
                    {
                        this.this$0 = $receiver;
                        this.$currentDisplaySize = $currentDisplaySize;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " handleBackgroundImageForResizeableNudge() : onDisplaySizeChangeEnd(): currentDisplaySize: " + (Object)((Object)this.$currentDisplaySize);
                    }
                }), (int)3, null);
                if (currentDisplaySize == DisplaySize.MINIMISED) {
                    this.$imageView.setVisibility(8);
                }
            }

            public void onDisplaySizeChangeStart(@NotNull DisplaySize currentDisplaySize) {
                Intrinsics.checkNotNullParameter((Object)((Object)currentDisplaySize), (String)"currentDisplaySize");
                Logger.log$default((Logger)NudgesViewEngineHelper.access$getSdkInstance$p((NudgesViewEngineHelper)this.this$0).logger, (int)0, null, (Function0)((Function0)new Function0<String>(this.this$0, currentDisplaySize){
                    final /* synthetic */ NudgesViewEngineHelper this$0;
                    final /* synthetic */ DisplaySize $currentDisplaySize;
                    {
                        this.this$0 = $receiver;
                        this.$currentDisplaySize = $currentDisplaySize;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " handleBackgroundImageForResizeableNudge() : onDisplaySizeChangeStart(): currentDisplaySize: " + (Object)((Object)this.$currentDisplaySize);
                    }
                }), (int)3, null);
                this.$imageView.setVisibility(currentDisplaySize == DisplaySize.MINIMISED ? 0 : 8);
            }
        });
        Logger.log$default((Logger)this.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " handleBackgroundImageForResizeableNudge() : completed";
            }
        }), (int)3, null);
    }

    private static final void createVideoView$lambda-0(NudgesViewEngineHelper this$0, MediaMeta $mediaMeta, FrameLayout $controllerLayout, ContainerStyle $primaryContainerStyle, MoEVideoView $videoView, MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mediaMeta, (String)"$mediaMeta");
        Intrinsics.checkNotNullParameter((Object)$controllerLayout, (String)"$controllerLayout");
        Intrinsics.checkNotNullParameter((Object)$primaryContainerStyle, (String)"$primaryContainerStyle");
        Intrinsics.checkNotNullParameter((Object)((Object)$videoView), (String)"$videoView");
        Logger.log$default((Logger)this$0.sdkInstance.logger, (int)0, null, (Function0)((Function0)new Function0<String>(this$0, mediaPlayer){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ MediaPlayer $mediaPlayer;
            {
                this.this$0 = $receiver;
                this.$mediaPlayer = $mediaPlayer;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NudgesViewEngineHelper.access$getTag$p(this.this$0) + " createVideoView(): onPrepareListener(): currentPosition= " + this.$mediaPlayer.getCurrentPosition() + " videoHeight= " + this.$mediaPlayer.getVideoHeight() + " videoWidth= " + this.$mediaPlayer.getVideoWidth() + " aspectRatio= " + (float)this.$mediaPlayer.getVideoWidth() / (float)this.$mediaPlayer.getVideoHeight();
            }
        }), (int)3, null);
        mediaPlayer.setVideoScalingMode(2);
        Intrinsics.checkNotNullExpressionValue((Object)mediaPlayer, (String)"mediaPlayer");
        this$0.mediaPlayer = mediaPlayer;
        this$0.updateVolume(!$mediaMeta.getHasAudio());
        this$0.showMediaController((View)$controllerLayout, true);
        DisplaySize displaySize = $primaryContainerStyle.displaySize;
        switch (displaySize == null ? -1 : WhenMappings.$EnumSwitchMapping$1[displaySize.ordinal()]) {
            case 1: {
                ViewDimension fullScreenDimension = this$0.getFullScreenViewDimension($primaryContainerStyle);
                $videoView.getLayoutParams().width = fullScreenDimension.width;
                $videoView.getLayoutParams().height = mediaPlayer.getVideoHeight() * fullScreenDimension.width / mediaPlayer.getVideoWidth();
                break;
            }
            case 2: {
                $videoView.getLayoutParams().width = mediaPlayer.getVideoWidth();
                $videoView.getLayoutParams().height = mediaPlayer.getVideoHeight();
            }
        }
    }

    private static final void createVideoView$lambda-1(NudgesViewEngineHelper this$0, FrameLayout $controllerLayout, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controllerLayout, (String)"$controllerLayout");
        this$0.showMediaController((View)$controllerLayout, true);
    }

    private static final void createVideoView$lambda-2(MoEVideoView $videoView, NudgesViewEngineHelper this$0, FrameLayout $controllerLayout, MediaPlayer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$videoView), (String)"$videoView");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controllerLayout, (String)"$controllerLayout");
        $videoView.pause();
        this$0.showMediaController((View)$controllerLayout, false);
    }

    private static final void getVideoController$lambda-3(MoEVideoView $videoView, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$videoView), (String)"$videoView");
        $videoView.start();
    }

    private static final void getVideoController$lambda-4(MoEVideoView $videoView, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$videoView), (String)"$videoView");
        $videoView.pause();
    }

    private static final void getVideoController$lambda-5(NudgesViewEngineHelper this$0, ImageView $muteButton, ImageView $unmuteButton, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$muteButton, (String)"$muteButton");
        Intrinsics.checkNotNullParameter((Object)$unmuteButton, (String)"$unmuteButton");
        this$0.updateVolume(true);
        this$0.handleAudioController(true, (View)$muteButton, (View)$unmuteButton);
    }

    private static final void getVideoController$lambda-6(NudgesViewEngineHelper this$0, ImageView $muteButton, ImageView $unmuteButton, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$muteButton, (String)"$muteButton");
        Intrinsics.checkNotNullParameter((Object)$unmuteButton, (String)"$unmuteButton");
        this$0.updateVolume(false);
        this$0.handleAudioController(false, (View)$muteButton, (View)$unmuteButton);
    }

    private static final void createContainerForResizeableImageView$lambda-7(NudgesViewEngineHelper this$0, FrameLayout $mediaController, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mediaController, (String)"$mediaController");
        this$0.showMediaController((View)$mediaController, true);
    }

    private static final void attachDisplaySizeControllers$lambda-8(NudgesViewEngineHelper this$0, RelativeLayout $primaryContainer, FrameLayout $mediaContainer, ViewDimension $mediaDimension, View $mediaView, ImageView $fullscreenController, ImageView $minimiseController, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$primaryContainer, (String)"$primaryContainer");
        Intrinsics.checkNotNullParameter((Object)$mediaContainer, (String)"$mediaContainer");
        Intrinsics.checkNotNullParameter((Object)$mediaDimension, (String)"$mediaDimension");
        Intrinsics.checkNotNullParameter((Object)$mediaView, (String)"$mediaView");
        Intrinsics.checkNotNullParameter((Object)$fullscreenController, (String)"$fullscreenController");
        Intrinsics.checkNotNullParameter((Object)$minimiseController, (String)"$minimiseController");
        AnimatorSet animator = this$0.getResizeValueAnimator($primaryContainer, $mediaContainer, $mediaDimension, DisplaySize.FULLSCREEN, $mediaView);
        animator.addListener(new Animator.AnimatorListener(this$0, $primaryContainer, $mediaContainer, $fullscreenController, $minimiseController, animator){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ RelativeLayout $primaryContainer;
            final /* synthetic */ FrameLayout $mediaContainer;
            final /* synthetic */ ImageView $fullscreenController;
            final /* synthetic */ ImageView $minimiseController;
            final /* synthetic */ AnimatorSet $animator;
            {
                this.this$0 = $receiver;
                this.$primaryContainer = $primaryContainer;
                this.$mediaContainer = $mediaContainer;
                this.$fullscreenController = $fullscreenController;
                this.$minimiseController = $minimiseController;
                this.$animator = $animator;
            }

            public void onAnimationStart(@NotNull Animator animation) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    OnInAppDisplaySizeChangeListener onInAppDisplaySizeChangeListener = NudgesViewEngineHelper.access$getOnInAppDisplaySizeChangeListener$p(this.this$0);
                    if (onInAppDisplaySizeChangeListener == null) break block0;
                    onInAppDisplaySizeChangeListener.onDisplaySizeChangeStart(DisplaySize.MINIMISED);
                }
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    ViewGroup.LayoutParams layoutParams = this.$primaryContainer.getLayoutParams();
                    Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                    FrameLayout.LayoutParams primaryContainerLayoutParams = (FrameLayout.LayoutParams)layoutParams;
                    primaryContainerLayoutParams.gravity |= 0x30;
                    primaryContainerLayoutParams.height = -1;
                    this.$primaryContainer.setLayoutParams((ViewGroup.LayoutParams)primaryContainerLayoutParams);
                    ViewParent viewParent = this.$mediaContainer.getParent();
                    Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
                    View mediaParent = (View)viewParent;
                    ViewGroup.LayoutParams mediaParentLayoutParams = mediaParent.getLayoutParams();
                    mediaParentLayoutParams.height = -1;
                    mediaParent.setLayoutParams(mediaParentLayoutParams);
                    this.$fullscreenController.setVisibility(8);
                    this.$minimiseController.setVisibility(0);
                    this.$animator.removeListener((Animator.AnimatorListener)this);
                    OnInAppDisplaySizeChangeListener onInAppDisplaySizeChangeListener = NudgesViewEngineHelper.access$getOnInAppDisplaySizeChangeListener$p(this.this$0);
                    if (onInAppDisplaySizeChangeListener == null) break block0;
                    onInAppDisplaySizeChangeListener.onDisplaySizeChangeEnd(DisplaySize.FULLSCREEN);
                }
            }

            public void onAnimationCancel(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            }

            public void onAnimationRepeat(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            }
        });
        animator.start();
    }

    private static final void attachDisplaySizeControllers$lambda-9(NudgesViewEngineHelper this$0, RelativeLayout $primaryContainer, FrameLayout $mediaContainer, ViewDimension $mediaDimension, View $mediaView, ImageView $minimiseController, ImageView $fullscreenController, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$primaryContainer, (String)"$primaryContainer");
        Intrinsics.checkNotNullParameter((Object)$mediaContainer, (String)"$mediaContainer");
        Intrinsics.checkNotNullParameter((Object)$mediaDimension, (String)"$mediaDimension");
        Intrinsics.checkNotNullParameter((Object)$mediaView, (String)"$mediaView");
        Intrinsics.checkNotNullParameter((Object)$minimiseController, (String)"$minimiseController");
        Intrinsics.checkNotNullParameter((Object)$fullscreenController, (String)"$fullscreenController");
        AnimatorSet animator = this$0.getResizeValueAnimator($primaryContainer, $mediaContainer, $mediaDimension, DisplaySize.MINIMISED, $mediaView);
        animator.addListener(new Animator.AnimatorListener(this$0, $primaryContainer, $minimiseController, $fullscreenController, animator){
            final /* synthetic */ NudgesViewEngineHelper this$0;
            final /* synthetic */ RelativeLayout $primaryContainer;
            final /* synthetic */ ImageView $minimiseController;
            final /* synthetic */ ImageView $fullscreenController;
            final /* synthetic */ AnimatorSet $animator;
            {
                this.this$0 = $receiver;
                this.$primaryContainer = $primaryContainer;
                this.$minimiseController = $minimiseController;
                this.$fullscreenController = $fullscreenController;
                this.$animator = $animator;
            }

            public void onAnimationStart(@NotNull Animator animation) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    SdkInstance sdkInstance = NudgesViewEngineHelper.access$getSdkInstance$p(this.this$0);
                    ViewGroup.LayoutParams layoutParams = this.$primaryContainer.getLayoutParams();
                    Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                    ViewEngineUtilsKt.setLayoutGravity(sdkInstance, (FrameLayout.LayoutParams)layoutParams, NudgesViewEngineHelper.access$getPayload$p(this.this$0).getPosition());
                    OnInAppDisplaySizeChangeListener onInAppDisplaySizeChangeListener = NudgesViewEngineHelper.access$getOnInAppDisplaySizeChangeListener$p(this.this$0);
                    if (onInAppDisplaySizeChangeListener == null) break block0;
                    onInAppDisplaySizeChangeListener.onDisplaySizeChangeStart(DisplaySize.FULLSCREEN);
                }
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    this.$minimiseController.setVisibility(8);
                    this.$fullscreenController.setVisibility(0);
                    this.$animator.removeListener((Animator.AnimatorListener)this);
                    OnInAppDisplaySizeChangeListener onInAppDisplaySizeChangeListener = NudgesViewEngineHelper.access$getOnInAppDisplaySizeChangeListener$p(this.this$0);
                    if (onInAppDisplaySizeChangeListener == null) break block0;
                    onInAppDisplaySizeChangeListener.onDisplaySizeChangeEnd(DisplaySize.MINIMISED);
                }
            }

            public void onAnimationCancel(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            }

            public void onAnimationRepeat(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            }
        });
        animator.start();
    }

    private static final void getResizeValueAnimator$lambda-10(NudgesViewEngineHelper this$0, RelativeLayout $primaryContainerLayout, FrameLayout $mediaContainer, ViewDimension $initialContainerDimension, ViewDimension $targetContainerDimension, DisplaySize $displaySize, ValueAnimator animation) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$primaryContainerLayout, (String)"$primaryContainerLayout");
        Intrinsics.checkNotNullParameter((Object)$mediaContainer, (String)"$mediaContainer");
        Intrinsics.checkNotNullParameter((Object)$initialContainerDimension, (String)"$initialContainerDimension");
        Intrinsics.checkNotNullParameter((Object)$targetContainerDimension, (String)"$targetContainerDimension");
        Intrinsics.checkNotNullParameter((Object)((Object)$displaySize), (String)"$displaySize");
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this$0.updateContainerAnimatedDimension($primaryContainerLayout, $mediaContainer, $initialContainerDimension, $targetContainerDimension, animation.getAnimatedFraction(), $displaySize);
    }

    private static final void getResizeValueAnimator$lambda-11(DisplaySize $displaySize, NudgesViewEngineHelper this$0, View $mediaView, ViewDimension $minimisedMediaDimension, ViewDimension $fullScreenMediaDimension, ValueAnimator animation) {
        Intrinsics.checkNotNullParameter((Object)((Object)$displaySize), (String)"$displaySize");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mediaView, (String)"$mediaView");
        Intrinsics.checkNotNullParameter((Object)$minimisedMediaDimension, (String)"$minimisedMediaDimension");
        Intrinsics.checkNotNullParameter((Object)$fullScreenMediaDimension, (String)"$fullScreenMediaDimension");
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        switch (WhenMappings.$EnumSwitchMapping$1[$displaySize.ordinal()]) {
            case 1: {
                this$0.updateViewAnimatedDimension($mediaView, $minimisedMediaDimension, $fullScreenMediaDimension, animation.getAnimatedFraction());
                break;
            }
            case 2: {
                this$0.updateViewAnimatedDimension($mediaView, $fullScreenMediaDimension, $minimisedMediaDimension, animation.getAnimatedFraction());
            }
        }
    }

    private static final void showMediaController$lambda-12(View $controllerView, NudgesViewEngineHelper this$0) {
        Intrinsics.checkNotNullParameter((Object)$controllerView, (String)"$controllerView");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($controllerView.getVisibility() == 8) {
            return;
        }
        Animation fadeoutAnimation = AnimationUtils.loadAnimation((Context)this$0.context, (int)R.anim.fade_out);
        fadeoutAnimation.setDuration(300L);
        fadeoutAnimation.setFillAfter(false);
        $controllerView.setAnimation(fadeoutAnimation);
        $controllerView.setVisibility(8);
    }

    public static final /* synthetic */ String access$getTag$p(NudgesViewEngineHelper $this) {
        return $this.tag;
    }

    public static final /* synthetic */ ViewCreationMeta access$getViewCreationMeta$p(NudgesViewEngineHelper $this) {
        return $this.viewCreationMeta;
    }

    public static final /* synthetic */ SdkInstance access$getSdkInstance$p(NudgesViewEngineHelper $this) {
        return $this.sdkInstance;
    }

    public static final /* synthetic */ OnInAppDisplaySizeChangeListener access$getOnInAppDisplaySizeChangeListener$p(NudgesViewEngineHelper $this) {
        return $this.onInAppDisplaySizeChangeListener;
    }

    public static final /* synthetic */ NativeCampaignPayload access$getPayload$p(NudgesViewEngineHelper $this) {
        return $this.payload;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[InAppPosition.values().length];
            nArray[InAppPosition.TOP.ordinal()] = 1;
            nArray[InAppPosition.BOTTOM.ordinal()] = 2;
            nArray[InAppPosition.BOTTOM_LEFT.ordinal()] = 3;
            nArray[InAppPosition.BOTTOM_RIGHT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DisplaySize.values().length];
            nArray[DisplaySize.FULLSCREEN.ordinal()] = 1;
            nArray[DisplaySize.MINIMISED.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

